/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="v1/models")
public interface ModelResource {
    @Path(value="{tableName}/{id}")
    @GET
    @Produces(value={"application/json"})
    public Response getPO(@PathParam(value="tableName") String var1, @PathParam(value="id") String var2, @QueryParam(value="$expand") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="showsql") String var5);

    @Path(value="{tableName}/{id}/{property}")
    @GET
    @Produces(value={"application/json"})
    public Response getPOProperty(@PathParam(value="tableName") String var1, @PathParam(value="id") String var2, @PathParam(value="property") String var3, @QueryParam(value="showsql") String var4);

    @Path(value="{tableName}")
    @GET
    @Produces(value={"application/json"})
    public Response getPOs(@PathParam(value="tableName") String var1, @QueryParam(value="$expand") String var2, @QueryParam(value="$filter") String var3, @QueryParam(value="$orderby") String var4, @QueryParam(value="$select") String var5, @QueryParam(value="$top") int var6, @DefaultValue(value="0") @QueryParam(value="$skip") int var7, @QueryParam(value="$valrule") String var8, @QueryParam(value="$context") String var9, @QueryParam(value="showsql") String var10);

    @GET
    @Produces(value={"application/json"})
    public Response getModels(@QueryParam(value="$filter") String var1);

    @Path(value="{tableName}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(@PathParam(value="tableName") String var1, String var2);

    @Path(value="{tableName}/{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response update(@PathParam(value="tableName") String var1, @PathParam(value="id") String var2, String var3);

    @Path(value="{tableName}/{id}")
    @DELETE
    @Produces(value={"application/json"})
    public Response delete(@PathParam(value="tableName") String var1, @PathParam(value="id") String var2);

    @Path(value="{tableName}/{id}/attachments")
    @GET
    @Produces(value={"application/json"})
    public Response getAttachments(@PathParam(value="tableName") String var1, @PathParam(value="id") String var2);

    @Path(value="{tableName}/{id}/attachments/zip")
    @GET
    @Produces(value={"application/octet-stream"})
    public Response getAttachmentsAsZip(@PathParam(value="tableName") String var1, @PathParam(value="id") String var2, @QueryParam(value="json") String var3);

    @Path(value="{tableName}/{id}/attachments/zip")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createAttachmentsFromZip(@PathParam(value="tableName") String var1, @PathParam(value="id") String var2, String var3);

    @Path(value="{tableName}/{id}/attachments/{fileName}")
    @GET
    @Produces(value={"application/octet-stream"})
    public Response getAttachmentEntry(@PathParam(value="tableName") String var1, @PathParam(value="id") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="json") String var4);

    @Path(value="{tableName}/{id}/attachments")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addAttachmentEntry(@PathParam(value="tableName") String var1, @PathParam(value="id") String var2, String var3);

    @Path(value="{tableName}/{id}/attachments")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteAttachments(@PathParam(value="tableName") String var1, @PathParam(value="id") String var2);

    @Path(value="{tableName}/{id}/attachments/{fileName}")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteAttachmentEntry(@PathParam(value="tableName") String var1, @PathParam(value="id") String var2, @PathParam(value="fileName") String var3);

    @Path(value="{tableName}/{id}/print")
    @GET
    @Produces(value={"application/json"})
    public Response printModelRecord(@PathParam(value="tableName") String var1, @PathParam(value="id") String var2, @QueryParam(value="$report_type") String var3);

    @Path(value="{tableName}/yaml")
    @GET
    @Produces(value={"application/yaml"})
    public Response getModelYAML(@PathParam(value="tableName") String var1);
}

