/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.UUID;
import org.compiere.model.MStyle;
import org.compiere.model.MStyleLine;
import org.compiere.model.MSysConfig;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Label;
import org.compiere.util.Env;

public class MLabel
extends X_AD_Label {
    private static final long serialVersionUID = -964945898771768568L;
    private static final String[] VIVID_COLORS = new String[]{"#FFB300", "#FF6800", "#A6BDD7", "#CEA262", "#007D34", "#F6768E", "#00538A", "#FF7A5C", "#53377A", "#FF8E00", "#B32851", "#F4C800", "#93AA00", "#F13A13", "#1EABAF", "#3178C1", "#B83140", "#0C1326", "#C71BEF", "#4600AE", "#21AA1F", "#1238C1", "#0C8077", "#3F5CE3", "#1A5300", "#0CA452", "#A77A42", "#293C8D", "#F8155D", "#49C600", "#803120", "#8C0D22"};

    public MLabel(Properties ctx, String AD_Label_UU, String trxName) {
        super(ctx, AD_Label_UU, trxName);
    }

    public MLabel(Properties ctx, int AD_Label_ID, String trxName) {
        super(ctx, AD_Label_ID, trxName);
    }

    public MLabel(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String buildStyle() {
        StringBuilder result = new StringBuilder();
        if (MSysConfig.getBooleanValue("LABEL_AUTOMATIC_COLOR", true, this.getAD_Client_ID())) {
            result.append("color: ").append(MLabel.calculateHexColor(this.getName())).append(";");
        }
        if (this.getAD_LabelCategory() != null && this.getAD_LabelCategory().getAD_LabelStyle_ID() > 0) {
            result.append(this.buildStyle(this.getAD_LabelCategory().getAD_LabelStyle_ID()));
        }
        if (this.getAD_LabelStyle_ID() > 0) {
            result.append(this.buildStyle(this.getAD_LabelStyle_ID()));
        }
        return result.toString();
    }

    private String buildStyle(int AD_Style_ID) {
        StringBuilder result = new StringBuilder();
        if (AD_Style_ID > 0) {
            MStyleLine[] lines;
            MStyle style2 = new MStyle(this.getCtx(), AD_Style_ID, this.get_TrxName());
            MStyleLine[] mStyleLineArray = lines = style2.getStyleLines();
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                MStyleLine line = mStyleLineArray[n2];
                String inlineStyle = line.getInlineStyle().trim();
                if (result.length() > 0 && result.charAt(result.length() - 1) != ';') {
                    result.append("; ");
                }
                result.append(inlineStyle);
                ++n2;
            }
            result.append(";");
        }
        return result.toString();
    }

    public static String calculateHexColor(String text) {
        int colorIndex = Math.abs(UUID.nameUUIDFromBytes(text.getBytes()).toString().hashCode() % VIVID_COLORS.length);
        return VIVID_COLORS[colorIndex];
    }

    public static MLabel getByName(Properties ctx, String name, String trxName) {
        String sqlWhere = " AD_Client_ID=? AND UPPER(Name) LIKE ?";
        return (MLabel)new Query(ctx, "AD_Label", sqlWhere, trxName).setParameters(Env.getAD_Client_ID(ctx), name.toUpperCase()).setOnlyActiveRecords(true).setOrderBy("Name").first();
    }
}

