/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.oidc.amazoncognito;

import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.model.MOIDCService;
import com.trekglobal.idempiere.rest.api.oidc.AbstractOIDCProvider;
import com.trekglobal.idempiere.rest.api.oidc.AuthenticatedUser;
import com.trekglobal.idempiere.rest.api.oidc.IOIDCProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;
import javax.ws.rs.container.ContainerRequestContext;
import org.compiere.model.MOrg;
import org.compiere.model.MRole;
import org.compiere.model.MSession;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={IOIDCProvider.class}, property={"name=Amazon Cognito"})
public class AmazonCognitoProvider
extends AbstractOIDCProvider {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AuthenticatedUser getAuthenticatedUser(DecodedJWT decodedJwt, ContainerRequestContext requestContext, MOIDCService oidcService) {
        MSession session;
        String userInfo;
        boolean useEmail;
        String userId;
        MRole mRole;
        DecodedJWT decodedIdToken;
        String roleHeader;
        String orgHeader;
        int AD_Role_ID;
        int AD_User_ID;
        int AD_Org_ID;
        int AD_Client_ID;
        block31: {
            Query query;
            block28: {
                block30: {
                    Query query2;
                    ArrayList<String> roleNames;
                    block29: {
                        String[] roles;
                        AD_Client_ID = oidcService.getAD_Client_ID();
                        AD_Org_ID = -1;
                        AD_User_ID = -1;
                        AD_Role_ID = -1;
                        orgHeader = requestContext.getHeaderString("X-ID-Organization");
                        roleHeader = requestContext.getHeaderString("X-ID-Role");
                        decodedIdToken = oidcService.getDecodedIdToken(requestContext);
                        if (!oidcService.isAuthorization_OIDC()) break block28;
                        roleNames = new ArrayList<String>();
                        Claim rolesClaim = decodedJwt.getClaim("cognito:groups");
                        if (rolesClaim.isNull() || rolesClaim.isMissing()) {
                            if (decodedIdToken != null) {
                                rolesClaim = decodedIdToken.getClaim("cognito:groups");
                            }
                            if (rolesClaim.isNull() || rolesClaim.isMissing()) {
                                throw new JWTVerificationException("Missing roles claim");
                            }
                        }
                        String[] stringArray = roles = (String[])rolesClaim.asArray(String.class);
                        int n = roles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String role;
                            String roleName = role = stringArray[n2];
                            Query query3 = new Query(Env.getCtx(), "AD_Role", "AD_Client_ID=? AND REPLACE(Name,' ','')=?", null);
                            MRole mRole2 = (MRole)query3.setOnlyActiveRecords(true).setParameters(new Object[]{AD_Client_ID, roleName}).firstOnly();
                            if (mRole2 != null) {
                                roleNames.add(mRole2.getName());
                            }
                            ++n2;
                        }
                        String roleName = null;
                        if (roleNames.size() == 1) {
                            roleName = (String)roleNames.get(0);
                            if (!Util.isEmpty((String)roleHeader) && !roleHeader.equals(roleName)) {
                                throw new JWTVerificationException("Invalid %s header".formatted("X-ID-Role"));
                            }
                        } else if (!Util.isEmpty((String)roleHeader)) {
                            String finalRoleHeader = roleHeader;
                            Optional<String> optional = roleNames.stream().filter(e -> finalRoleHeader.equals(e)).findFirst();
                            if (!optional.isPresent()) throw new JWTVerificationException("Invalid %s header".formatted("X-ID-Role"));
                            roleName = optional.get();
                        }
                        query2 = new Query(Env.getCtx(), "AD_Role", "AD_Client_ID=? AND Name=?", null);
                        if (roleName == null) break block29;
                        mRole = (MRole)query2.setOnlyActiveRecords(true).setParameters(new Object[]{AD_Client_ID, roleName}).first();
                        if (mRole == null) break block30;
                        AD_Role_ID = mRole.get_ID();
                        break block30;
                    }
                    mRole = null;
                    for (String r : roleNames) {
                        mRole = (MRole)query2.setOnlyActiveRecords(true).setParameters(new Object[]{AD_Client_ID, r}).first();
                        if (mRole == null) continue;
                        AD_Role_ID = mRole.get_ID();
                        break;
                    }
                }
                if (AD_Role_ID == -1) {
                    throw new JWTVerificationException("Invalid Role claim");
                }
                break block31;
            }
            if (!Util.isEmpty((String)orgHeader)) {
                query = new Query(Env.getCtx(), "AD_Org", "AD_Client_ID=? AND Value=?", null);
                MOrg org = (MOrg)query.setOnlyActiveRecords(true).setParameters(new Object[]{AD_Client_ID, orgHeader}).first();
                if (org != null) {
                    AD_Org_ID = org.getAD_Org_ID();
                }
                if (AD_Org_ID == -1) {
                    throw new JWTVerificationException("Invalid %s header".formatted("X-ID-Organization"));
                }
            }
            if (!Util.isEmpty((String)roleHeader)) {
                query = new Query(Env.getCtx(), "AD_Role", "AD_Client_ID=? AND Name=?", null);
                MRole mRole3 = (MRole)query.setOnlyActiveRecords(true).setParameters(new Object[]{AD_Client_ID, roleHeader}).first();
                if (mRole3 == null) throw new JWTVerificationException("Invalid %s header".formatted("X-ID-Role"));
                AD_Role_ID = mRole3.getAD_Role_ID();
            }
        }
        if (Util.isEmpty((String)(userId = decodedJwt.getClaim((useEmail = MSysConfig.getBooleanValue((String)"USE_EMAIL_FOR_LOGIN", (boolean)false)) ? "email" : "username").asString())) && decodedIdToken != null) {
            userId = decodedIdToken.getClaim(useEmail ? "email" : "cognito:username").asString();
        }
        if (Util.isEmpty((String)userId) && !Util.isEmpty((String)(userInfo = this.getUserInfo(decodedJwt, requestContext, oidcService)))) {
            JsonObject json = (JsonObject)new Gson().fromJson(userInfo, JsonObject.class);
            userId = json.get(useEmail ? "email" : "username").getAsString();
        }
        if (Util.isEmpty((String)userId)) {
            throw new JWTVerificationException("Missing user claim");
        }
        Query query = new Query(Env.getCtx(), "AD_User", "AD_Client_ID IN (0,?) AND %s=?".formatted(useEmail ? "Email" : "Name"), null);
        MUser user = (MUser)query.setOnlyActiveRecords(true).setParameters(new Object[]{AD_Client_ID, userId}).setOrderBy("AD_Client_ID DESC").first();
        if (user == null) {
            throw new JWTVerificationException("Invalid user claim");
        }
        AD_User_ID = user.get_ID();
        boolean orgAccessValidated = false;
        if (AD_Role_ID == -1) {
            if (!Util.isEmpty((String)roleHeader)) {
                query = new Query(Env.getCtx(), "AD_Role", "AD_Client_ID=? AND Name=?", null);
                mRole = (MRole)query.setOnlyActiveRecords(true).setParameters(new Object[]{AD_Client_ID, roleHeader}).first();
                if (mRole == null) throw new JWTVerificationException("Invalid %s header".formatted("X-ID-Role"));
                AD_Role_ID = mRole.getAD_Role_ID();
            } else {
                AD_Role_ID = this.getSingleRoleIDOnly(AD_Client_ID, user);
            }
        }
        if (AD_Role_ID < 0) throw new JWTVerificationException("Missing Role Claim or Header");
        if (AD_Org_ID == -1) {
            if (!Util.isEmpty((String)orgHeader)) {
                query = new Query(Env.getCtx(), "AD_Org", "AD_Client_ID=? AND Value=?", null);
                MOrg org = (MOrg)query.setOnlyActiveRecords(true).setParameters(new Object[]{AD_Client_ID, orgHeader}).first();
                if (org == null) throw new JWTVerificationException("Invalid %s header".formatted("X-ID-Organization"));
                AD_Org_ID = org.getAD_Org_ID();
            } else {
                AD_Org_ID = this.getSingleOrgIdOnly(AD_Client_ID, AD_Role_ID, user);
                if (AD_Org_ID < 0) throw new JWTVerificationException("Missing Organization Claim or Header");
                orgAccessValidated = true;
            }
        }
        if (AD_Role_ID >= 0 && AD_Org_ID >= 0 && !orgAccessValidated) {
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_Client_ID", (int)AD_Client_ID);
            mRole = new MRole(Env.getCtx(), AD_Role_ID, null);
            if (mRole.isUseUserOrgAccess()) {
                mRole.setAD_User_ID(AD_User_ID);
            }
            if (!mRole.isOrgAccess(AD_Org_ID, false)) {
                throw new JWTVerificationException("Invalid user and organization combination");
            }
        }
        if ((session = MSession.get((Properties)Env.getCtx())) != null) return new AuthenticatedUser(AD_Client_ID, AD_Org_ID, AD_Role_ID, AD_User_ID, session.getAD_Session_ID());
        session = MSession.create((Properties)Env.getCtx());
        session.setWebSession("idempiere-rest-oidc");
        session.saveEx();
        return new AuthenticatedUser(AD_Client_ID, AD_Org_ID, AD_Role_ID, AD_User_ID, session.getAD_Session_ID());
    }

    private String getUserInfo(DecodedJWT decodedJwt, ContainerRequestContext requestContext, MOIDCService oidcService) {
        String scope = decodedJwt.getClaim("scope").asString();
        if (Util.isEmpty((String)scope) || !scope.contains("openid")) {
            return null;
        }
        String endpoint = null;
        String wellKnownUrl = oidcService.getOIDC_ConfigurationURL();
        HttpClient httpClient = HttpClient.newBuilder().build();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(wellKnownUrl)).GET().build();
        try {
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            JsonObject json = (JsonObject)new Gson().fromJson(response.body(), JsonObject.class);
            endpoint = json.get("userinfo_endpoint").getAsString();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        try {
            String authorizationHeader = requestContext.getHeaderString("Authorization");
            URL url = new URL(endpoint);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Authorization", authorizationHeader);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                return response.toString();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

