/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.json.filter;

import com.trekglobal.idempiere.rest.api.json.IDempiereRestException;
import com.trekglobal.idempiere.rest.api.json.filter.ConvertedQuery;
import com.trekglobal.idempiere.rest.api.json.filter.IQueryConverter;
import com.trekglobal.idempiere.rest.api.json.filter.IQueryConverterFactory;
import com.trekglobal.idempiere.rest.api.json.filter.ODataUtils;
import com.trekglobal.idempiere.rest.api.model.MRestView;
import java.lang.invoke.LambdaMetafactory;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.function.Predicate;
import javax.ws.rs.core.Response;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.osgi.service.component.annotations.Component;

@Component(name="com.trekglobal.idempiere.rest.api.json.DefaultQueryConverter", service={IQueryConverterFactory.class}, property={"service.ranking:Integer=0"}, immediate=true)
public class DefaultQueryConverter
implements IQueryConverter,
IQueryConverterFactory {
    private CCache<String, ConvertedQuery> convertCache = new CCache(null, "JSON_DB_Convert_Cache", 1000, 60, false);
    private ConvertedQuery convertedQuery;
    private MTable table;
    private MRestView view;

    @Override
    public synchronized ConvertedQuery convertStatement(String tableName, String queryStatement) {
        return this.convertStatement(null, tableName, queryStatement);
    }

    @Override
    public synchronized ConvertedQuery convertStatement(MRestView view, String tableName, String queryStatement) {
        ConvertedQuery cache = (ConvertedQuery)this.convertCache.get((Object)queryStatement);
        if (cache != null) {
            return cache;
        }
        this.convertedQuery = new ConvertedQuery();
        if (!Util.isEmpty((String)queryStatement, (boolean)true)) {
            this.table = MTable.get((Properties)Env.getCtx(), (String)tableName);
            this.view = view;
            this.convertStatement(queryStatement);
            this.convertCache.put((Object)queryStatement, (Object)this.convertedQuery);
        }
        return this.convertedQuery;
    }

    private void convertStatement(String originalFilter) {
        List<String> literals = DefaultQueryConverter.split(originalFilter);
        this.convertLiterals(literals);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void convertLiterals(List<String> literals) {
        int i = 0;
        while (i < literals.size()) {
            String literal = literals.get(i);
            Object sqlStatement = "";
            if ("and".equalsIgnoreCase(literal) || "or".equalsIgnoreCase(literal)) {
                sqlStatement = " " + literal.toUpperCase() + " ";
            } else if ("not".equalsIgnoreCase(literal)) {
                String nextOperator;
                if (!ODataUtils.isMethodCall(nextOperator = literals.get(++i))) throw new IDempiereRestException("Operator NOT is only compatible with certain functions. Not with " + nextOperator, Response.Status.BAD_REQUEST);
                sqlStatement = this.convertMethodWithParamsLiteral(nextOperator, true);
            } else if (literal.startsWith("(") && literal.endsWith(")")) {
                literal = literal.substring(1, literal.length() - 1);
                List<String> subliterals = DefaultQueryConverter.split(literal);
                this.convertedQuery.appendWhereClause("(");
                this.convertLiterals(subliterals);
                this.convertedQuery.appendWhereClause(")");
            } else if (ODataUtils.isMethodCall(literal) && ODataUtils.isMethodWithParameters(ODataUtils.getMethodCall(literal))) {
                sqlStatement = this.convertMethodWithParamsLiteral(literal, false);
            } else {
                String left = literal;
                String operator = literals.get(++i);
                String right = literals.get(++i);
                sqlStatement = this.convertBinaryOperator(left, operator, right);
            }
            this.convertedQuery.appendWhereClause((String)sqlStatement);
            ++i;
        }
    }

    private String convertMethodWithParamsLiteral(String literal, boolean isNot) {
        String leftParameter;
        String methodName = ODataUtils.getMethodCall(literal);
        String columnName = leftParameter = ODataUtils.getFirstParameter(methodName, literal);
        if (leftParameter.contains("(")) {
            String innerMethodName = ODataUtils.getMethodCall(leftParameter);
            columnName = ODataUtils.getFirstParameter(innerMethodName, leftParameter);
            leftParameter = ODataUtils.getSQLFunction(innerMethodName, columnName, false);
        }
        String value = ODataUtils.getSecondParameter(methodName, literal);
        return leftParameter + this.convertMethodCall(methodName, columnName, value, isNot);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String convertBinaryOperator(String left, String operator, String right) {
        MColumn column;
        String rightParameter;
        String strOperator;
        String leftParameter;
        block32: {
            leftParameter = null;
            strOperator = ODataUtils.getOperator(operator);
            rightParameter = null;
            if (strOperator == null) {
                throw new IDempiereRestException("Unsupported operator: " + operator, Response.Status.BAD_REQUEST);
            }
            column = null;
            if (left.contains("(")) {
                String innerMethodName = ODataUtils.getMethodCall(left);
                String columnName = ODataUtils.getFirstParameter(innerMethodName, left);
                MColumn tableColumn = this.table.getColumn(columnName.trim());
                String viewColumnName = null;
                if (this.view != null && (viewColumnName = this.view.toColumnName(columnName.trim())) == null && tableColumn != null) {
                    throw new IDempiereRestException("Invalid column for filter: " + columnName.trim(), Response.Status.BAD_REQUEST);
                }
                MColumn mColumn = column = viewColumnName != null && tableColumn == null ? this.table.getColumn(viewColumnName) : tableColumn;
                if (column == null || column.isSecure() || column.isEncrypted()) {
                    throw new IDempiereRestException("Invalid column for filter: " + columnName.trim(), Response.Status.BAD_REQUEST);
                }
                leftParameter = ODataUtils.getSQLFunction(innerMethodName, columnName, false);
            } else {
                MColumn tableColumn = this.table.getColumn(left.trim());
                String viewColumnName = null;
                if (this.view != null && (viewColumnName = this.view.toColumnName(left.trim())) == null && tableColumn != null) {
                    throw new IDempiereRestException("Invalid column for filter: " + left.trim(), Response.Status.BAD_REQUEST);
                }
                MColumn mColumn = column = viewColumnName != null && tableColumn == null ? this.table.getColumn(viewColumnName) : tableColumn;
                if (column == null || column.isSecure() || column.isEncrypted()) {
                    throw new IDempiereRestException("Invalid column for filter: " + left.trim(), Response.Status.BAD_REQUEST);
                }
                leftParameter = column.getColumnName();
            }
            if (!"null".equals(right)) break block32;
            switch (operator) {
                case "eq": {
                    strOperator = " IS ";
                    rightParameter = "NULL";
                    return leftParameter + strOperator + rightParameter;
                }
                case "neq": {
                    strOperator = " IS NOT ";
                    rightParameter = "NULL";
                    return leftParameter + strOperator + rightParameter;
                }
                default: {
                    throw new IDempiereRestException("Operator " + operator + " is not compatible with NULL comparision", Response.Status.BAD_REQUEST);
                }
            }
        }
        if ("in".equals(operator)) {
            String[] valueArray;
            if (!right.startsWith("(") || !right.endsWith(")")) throw new IDempiereRestException("Wrong right parameter for IN operator", Response.Status.BAD_REQUEST);
            StringBuilder rightParameterBuilder = new StringBuilder("(");
            String values = right.substring(1, right.length() - 1).trim();
            String[] stringArray = valueArray = values.split(",");
            int n = valueArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                this.convertedQuery.addParameter(column, value.trim());
                rightParameterBuilder.append("?,");
                ++n2;
            }
            rightParameterBuilder.setLength(rightParameterBuilder.length() - 1);
            rightParameterBuilder.append(")");
            rightParameter = rightParameterBuilder.toString();
            return leftParameter + strOperator + rightParameter;
        } else if (right.startsWith("'") && right.endsWith("'")) {
            this.convertedQuery.addParameter(column, right);
            rightParameter = " ?";
            return leftParameter + strOperator + rightParameter;
        } else if (right.contains("(")) {
            MColumn columnRight;
            String innerMethodName = ODataUtils.getMethodCall(right);
            String innerValue = ODataUtils.getFirstParameter(innerMethodName, right);
            MColumn tableColumn = this.table.getColumn(innerValue.trim());
            String viewColumnName = null;
            if (this.view != null && (viewColumnName = this.view.toColumnName(innerValue.trim())) == null && tableColumn != null) {
                throw new IDempiereRestException("Invalid column for filter: " + innerValue.trim(), Response.Status.BAD_REQUEST);
            }
            MColumn mColumn = columnRight = viewColumnName != null && tableColumn == null ? this.table.getColumn(viewColumnName) : tableColumn;
            if (columnRight != null) {
                if (columnRight.isSecure() || columnRight.isEncrypted()) {
                    throw new IDempiereRestException("Invalid column for filter: " + innerValue.trim(), Response.Status.BAD_REQUEST);
                }
                rightParameter = ODataUtils.getSQLFunction(innerMethodName, columnRight.getColumnName(), false);
                return leftParameter + strOperator + rightParameter;
            } else {
                this.convertedQuery.addParameter(column, innerValue);
                rightParameter = ODataUtils.getSQLFunction(innerMethodName, "?", false);
            }
            return leftParameter + strOperator + rightParameter;
        } else {
            MColumn columnRight;
            MColumn tableColumnRight = this.table.getColumn(right.trim());
            String viewRight = null;
            if (this.view != null && (viewRight = this.view.toColumnName(right.trim())) == null && tableColumnRight != null) {
                throw new IDempiereRestException("Invalid column for filter: " + tableColumnRight.getColumnName(), Response.Status.BAD_REQUEST);
            }
            MColumn mColumn = columnRight = viewRight != null && tableColumnRight == null ? this.table.getColumn(viewRight) : tableColumnRight;
            if (columnRight != null) {
                if (columnRight.isSecure() || columnRight.isEncrypted()) {
                    throw new IDempiereRestException("Invalid column for filter: " + right.trim(), Response.Status.BAD_REQUEST);
                }
                rightParameter = columnRight.getColumnName();
                return leftParameter + strOperator + rightParameter;
            } else {
                this.convertedQuery.addParameter(column, right);
                rightParameter = " ?";
            }
        }
        return leftParameter + strOperator + rightParameter;
    }

    private String convertMethodCall(String methodCall, String columnName, String value, boolean isNot) {
        String rightParameter;
        block19: {
            MColumn column;
            block18: {
                MColumn columnRight;
                rightParameter = "?";
                String innerMethodName = null;
                MColumn tableColumn = this.table.getColumn(columnName);
                String viewColumnName = null;
                if (this.view != null && (viewColumnName = this.view.toColumnName(columnName)) == null && tableColumn != null) {
                    throw new IDempiereRestException("Invalid column for filter: " + columnName, Response.Status.BAD_REQUEST);
                }
                MColumn mColumn = column = viewColumnName != null && tableColumn == null ? this.table.getColumn(viewColumnName) : tableColumn;
                if (column == null || column.isSecure() || column.isEncrypted()) {
                    throw new IDempiereRestException("Invalid column for filter: " + columnName, Response.Status.BAD_REQUEST);
                }
                if (value.contains("(")) {
                    innerMethodName = ODataUtils.getMethodCall(value);
                    value = ODataUtils.getFirstParameter(innerMethodName, value);
                    rightParameter = ODataUtils.getSQLFunction(innerMethodName, "?", false);
                }
                tableColumn = this.table.getColumn(value.trim());
                viewColumnName = null;
                if (this.view != null && (viewColumnName = this.view.toColumnName(value.trim())) == null && tableColumn != null) {
                    throw new IDempiereRestException("Invalid column for filter: " + value.trim(), Response.Status.BAD_REQUEST);
                }
                MColumn mColumn2 = columnRight = viewColumnName != null && tableColumn == null ? this.table.getColumn(viewColumnName) : tableColumn;
                if (columnRight == null) break block18;
                if (columnRight.isSecure() || columnRight.isEncrypted()) {
                    throw new IDempiereRestException("Invalid column for filter: " + value.trim(), Response.Status.BAD_REQUEST);
                }
                rightParameter = innerMethodName != null ? ODataUtils.getSQLFunction(innerMethodName, columnRight.getColumnName(), false) : columnRight.getColumnName();
                break block19;
            }
            value = ConvertedQuery.extractFromStringValue(value);
            switch (methodCall) {
                case "contains": {
                    this.convertedQuery.addParameter(column, "'%" + value + "%'");
                    break;
                }
                case "startswith": {
                    this.convertedQuery.addParameter(column, "'" + value + "%'");
                    break;
                }
                case "endswith": {
                    this.convertedQuery.addParameter(column, "'%" + value + "'");
                    break;
                }
                default: {
                    throw new IDempiereRestException("Method call " + methodCall + " not implemented", Response.Status.NOT_IMPLEMENTED);
                }
            }
        }
        return ODataUtils.getSQLMethodOperator(methodCall, isNot) + rightParameter;
    }

    /*
     * Unable to fully structure code
     */
    public static List<String> split(String expression) {
        operatorList = new LinkedList<String>();
        depth = 0;
        singleQuotes = false;
        sb = new StringBuilder();
        i = 0;
        while (i < expression.length()) {
            block5: {
                block4: {
                    block3: {
                        c = expression.charAt(i);
                        if (c != '(') break block3;
                        ++depth;
                        ** GOTO lbl-1000
                    }
                    if (c != ')') break block4;
                    --depth;
                    ** GOTO lbl-1000
                }
                if (c != '\'') break block5;
                singleQuotes = singleQuotes == false;
                ** GOTO lbl-1000
            }
            if (c == ' ' && depth == 0 && !singleQuotes) {
                operatorList.add(sb.toString());
                sb = new StringBuilder();
            } else lbl-1000:
            // 4 sources

            {
                sb.append(c);
            }
            ++i;
        }
        operatorList.add(sb.toString());
        operatorList.removeIf((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$0(java.lang.String ), (Ljava/lang/String;)Z)());
        return operatorList;
    }

    @Override
    public IQueryConverter getQueryConverter(String converterName) {
        if ("DEFAULT".equals(converterName)) {
            return this;
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$0(String item) {
        return item == null || "".equals(item);
    }
}

