/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.MEXPFormatLine;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_EXP_Format;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;
import org.idempiere.cache.POCopyCache;

public class MEXPFormat
extends X_EXP_Format
implements ImmutablePOSupport {
    private static final long serialVersionUID = -2749091471654364602L;
    private static CLogger s_log = CLogger.getCLogger(MEXPFormat.class);
    private static POCopyCache<String, MEXPFormat> s_cache = new POCopyCache("EXP_Format", 50);
    private static ImmutableIntPOCache<Integer, MEXPFormat> exp_format_by_id_cache = new ImmutableIntPOCache("EXP_Format", 50);
    private List<MEXPFormatLine> m_lines = null;
    private List<MEXPFormatLine> m_lines_unique = null;

    public MEXPFormat(Properties ctx, String EXP_Format_UU, String trxName) {
        super(ctx, EXP_Format_UU, trxName);
    }

    public MEXPFormat(Properties ctx, int EXP_Format_ID, String trxName) {
        super(ctx, EXP_Format_ID, trxName);
    }

    public MEXPFormat(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MEXPFormat(MEXPFormat copy) {
        this(Env.getCtx(), copy);
    }

    public MEXPFormat(Properties ctx, MEXPFormat copy) {
        this(ctx, copy, null);
    }

    public MEXPFormat(Properties ctx, MEXPFormat copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_lines = copy.m_lines != null ? (List)copy.m_lines.stream().map(e -> new MEXPFormatLine(ctx, (MEXPFormatLine)e, trxName)).collect(Collectors.toCollection(ArrayList::new)) : null;
        this.m_lines_unique = copy.m_lines_unique != null ? (List)copy.m_lines_unique.stream().map(e -> new MEXPFormatLine(ctx, (MEXPFormatLine)e, trxName)).collect(Collectors.toCollection(ArrayList::new)) : null;
    }

    public List<MEXPFormatLine> getFormatLines() {
        return this.getFormatLinesOrderedBy("Position");
    }

    public List<MEXPFormatLine> getFormatLinesOrderedBy(String orderBy) {
        if (this.m_lines != null) {
            return this.m_lines;
        }
        this.m_lines = new Query(this.getCtx(), "EXP_FormatLine", "EXP_Format_ID=?", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.getEXP_Format_ID()).setOrderBy(orderBy).list();
        if (this.is_Immutable() && this.m_lines.size() > 0) {
            this.m_lines.stream().forEach(e -> {
                MEXPFormatLine mEXPFormatLine = e.markImmutable();
            });
        }
        return this.m_lines;
    }

    public Collection<MEXPFormatLine> getUniqueColumns() throws SQLException {
        if (this.m_lines_unique != null) {
            return this.m_lines_unique;
        }
        this.m_lines_unique = new Query(this.getCtx(), "EXP_FormatLine", "EXP_Format_ID= ? AND IsPartUniqueIndex= ?", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.getEXP_Format_ID(), "Y").setOrderBy("Position").list();
        if (this.is_Immutable() && this.m_lines_unique.size() > 0) {
            this.m_lines_unique.stream().forEach(e -> {
                MEXPFormatLine mEXPFormatLine = e.markImmutable();
            });
        }
        return this.m_lines_unique;
    }

    public static MEXPFormat get(int EXP_Format_ID) {
        return MEXPFormat.get(EXP_Format_ID, null);
    }

    public static MEXPFormat get(int EXP_Format_ID, String trxName) {
        return MEXPFormat.get(Env.getCtx(), EXP_Format_ID, trxName);
    }

    public static MEXPFormat get(Properties ctx, int EXP_Format_ID, String trxName) {
        MEXPFormat exp_format = exp_format_by_id_cache.get(ctx, EXP_Format_ID, e -> new MEXPFormat(ctx, (MEXPFormat)e));
        if (exp_format != null) {
            return exp_format;
        }
        exp_format = new MEXPFormat(ctx, EXP_Format_ID, trxName);
        if (exp_format.getEXP_Format_ID() == EXP_Format_ID) {
            exp_format.getFormatLines();
            exp_format_by_id_cache.put(EXP_Format_ID, exp_format, e -> new MEXPFormat(Env.getCtx(), (MEXPFormat)e));
            return exp_format;
        }
        return null;
    }

    public static MEXPFormat getFormatByValueAD_Client_IDAndVersion(Properties ctx, String value, int AD_Client_ID, String version, String trxName) throws SQLException {
        String key = new String(value + version);
        MEXPFormat retValue = s_cache.get(key, e -> new MEXPFormat(ctx, (MEXPFormat)e, trxName));
        if (retValue != null) {
            return retValue;
        }
        StringBuilder whereClause = new StringBuilder("Value").append("=?").append(" AND AD_Client_ID = ?").append(" AND ").append("Version").append(" = ?");
        retValue = (MEXPFormat)new Query(ctx, "EXP_Format", whereClause.toString(), trxName).setParameters(value, AD_Client_ID, version).first();
        if (retValue != null) {
            retValue.getFormatLines();
            s_cache.put(key, retValue, e -> new MEXPFormat(Env.getCtx(), (MEXPFormat)e));
            exp_format_by_id_cache.put(retValue.getEXP_Format_ID(), new MEXPFormat(Env.getCtx(), retValue));
            return retValue;
        }
        return null;
    }

    public static MEXPFormat getFormatByAD_Client_IDAD_Table_IDAndVersion(Properties ctx, int AD_Client_ID, int AD_Table_ID, String version, String trxName) throws SQLException {
        String key = new String(MTable.getTableName(ctx, AD_Table_ID) + version);
        MEXPFormat retValue = s_cache.get(key, e -> new MEXPFormat(ctx, (MEXPFormat)e, trxName));
        if (retValue != null) {
            return retValue;
        }
        StringBuilder whereClause = new StringBuilder(" AD_Client_ID = ? ").append("  AND ").append("AD_Table_ID").append(" = ? ").append("  AND ").append("Version").append(" = ?");
        retValue = (MEXPFormat)new Query(ctx, "EXP_Format", whereClause.toString(), trxName).setParameters(AD_Client_ID, AD_Table_ID, version).first();
        if (retValue != null) {
            retValue.getFormatLines();
            s_cache.put(key, retValue, e -> new MEXPFormat(Env.getCtx(), (MEXPFormat)e));
            exp_format_by_id_cache.put(retValue.getEXP_Format_ID(), new MEXPFormat(Env.getCtx(), retValue));
            return retValue.markImmutable();
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("X_EXP_Format[ID=").append(this.get_ID()).append("; Value = ").append(this.getValue()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeDelete() {
        int[] ids;
        int[] nArray = ids = MEXPFormatLine.getAllIDs("EXP_FormatLine", "EXP_Format_ID=" + this.getEXP_Format_ID(), this.get_TrxName());
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            MEXPFormatLine line = new MEXPFormatLine(this.getCtx(), id, this.get_TrxName());
            line.delete(true);
            ++n2;
        }
        return true;
    }

    @Override
    public MEXPFormat markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_lines != null && this.m_lines.size() > 0) {
            this.m_lines.stream().forEach(e -> {
                MEXPFormatLine mEXPFormatLine = e.markImmutable();
            });
        }
        if (this.m_lines_unique != null && this.m_lines_unique.size() > 0) {
            this.m_lines_unique.stream().forEach(e -> {
                MEXPFormatLine mEXPFormatLine = e.markImmutable();
            });
        }
        return this;
    }
}

