/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base;

import java.util.logging.Level;
import org.adempiere.base.IPaymentProcessorFactory;
import org.adempiere.base.equinox.EquinoxExtensionLocator;
import org.compiere.model.PaymentProcessor;
import org.compiere.util.CLogger;

public class DefaultPaymentProcessorFactory
implements IPaymentProcessorFactory {
    private static final CLogger s_log = CLogger.getCLogger(DefaultPaymentProcessorFactory.class);

    @Override
    public PaymentProcessor newPaymentProcessorInstance(String className) {
        PaymentProcessor myProcessor = null;
        myProcessor = EquinoxExtensionLocator.instance().locate(PaymentProcessor.class, className, null).getExtension();
        if (myProcessor == null) {
            try {
                Class<?> ppClass = Class.forName(className);
                if (ppClass != null) {
                    myProcessor = (PaymentProcessor)ppClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (Error e1) {
                s_log.log(Level.SEVERE, className + " - Error=" + e1.getMessage());
                return null;
            }
            catch (Exception e2) {
                s_log.log(Level.SEVERE, className, e2);
                return null;
            }
        }
        return myProcessor;
    }
}

