/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.model;

import com.trekglobal.idempiere.rest.api.model.X_REST_Resource;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.compiere.model.MRole;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MRestResource
extends X_REST_Resource
implements ImmutablePOSupport {
    private static final long serialVersionUID = -3227579665231376856L;
    private static final ImmutableIntPOCache<Integer, MRestResource> s_cache = new ImmutableIntPOCache("REST_Resource", 100, 0);
    private static final CCache<Integer, String> s_patternCache = new CCache(null, "REST_Resource_PathPatternCache", 100, false);

    public MRestResource(Properties ctx, int REST_Resource_ID, String trxName) {
        super(ctx, REST_Resource_ID, trxName);
    }

    public MRestResource(Properties ctx, int REST_Resource_ID, String trxName, String ... virtualColumns) {
        super(ctx, REST_Resource_ID, trxName, virtualColumns);
    }

    public MRestResource(Properties ctx, String REST_Resource_UU, String trxName) {
        super(ctx, REST_Resource_UU, trxName);
    }

    public MRestResource(Properties ctx, String REST_Resource_UU, String trxName, String ... virtualColumns) {
        super(ctx, REST_Resource_UU, trxName, virtualColumns);
    }

    public MRestResource(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MRestResource[] getMatchResources(String path) {
        if (s_cache.isEmpty()) {
            MRestResource.loadRestResources();
        }
        ArrayList<MRestResource> matchList = new ArrayList<MRestResource>();
        Iterator iterator = s_patternCache.keySet().iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            String pathExpression = (String)s_patternCache.get((Object)id);
            if (!Pattern.matches(pathExpression, path)) continue;
            MRestResource restResource = (MRestResource)s_cache.get((Object)id);
            if (restResource != null) {
                matchList.add(restResource);
                continue;
            }
            MRestResource resource = new MRestResource(Env.getCtx(), id, null);
            if (resource.get_ID() == id && resource.getREST_ResourcePath().equals(pathExpression)) {
                s_cache.put((Object)id, (PO)resource);
                matchList.add(resource);
                restResource = resource;
            }
            if (restResource != null) continue;
            s_patternCache.remove((Object)id);
        }
        return matchList.toArray(new MRestResource[0]);
    }

    private static void loadRestResources() {
        Query query = new Query(Env.getCtx(), "REST_Resource", null, null);
        List resources = query.setOnlyActiveRecords(true).list();
        for (MRestResource resource : resources) {
            s_cache.put((Object)resource.get_ID(), (PO)resource);
            s_patternCache.put((Object)resource.get_ID(), (Object)resource.getREST_ResourcePath());
        }
        if (s_cache.isEmpty()) {
            s_cache.put((Object)0, (PO)new MRestResource(Env.getCtx(), 0, null));
        }
    }

    public boolean hasAccess(MRole role, String method) {
        Query query = new Query(Env.getCtx(), "REST_Resource_Access", "REST_Resource_ID=? AND AD_Role_ID=? AND REST_HttpMethods LIKE ?", null);
        return query.setOnlyActiveRecords(true).setParameters(new Object[]{this.getREST_Resource_ID(), role.getAD_Role_ID(), "%" + method + "%"}).count() == 1;
    }

    public PO markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (!Util.isEmpty((String)this.getREST_ResourcePath(), (boolean)true)) {
            try {
                Pattern.compile(this.getREST_ResourcePath());
            }
            catch (PatternSyntaxException e) {
                CLogger.getCLogger(this.getClass()).saveError("Error", "Invalid regular expression syntax. " + e.getLocalizedMessage(), (Exception)e);
                return false;
            }
        }
        return true;
    }
}

