/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.json.DateTypeConverter;
import com.trekglobal.idempiere.rest.api.json.RestUtils;
import com.trekglobal.idempiere.rest.api.util.ErrorBuilder;
import com.trekglobal.idempiere.rest.api.v1.resource.WorkflowResource;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.ws.rs.core.Response;
import org.compiere.model.MBPartner;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWFProcess;

public class WorkflowResourceImpl
implements WorkflowResource {
    private static final CLogger log = CLogger.getCLogger(WorkflowResourceImpl.class);

    @Override
    public Response getNodes() {
        return this.getNodes(null);
    }

    @Override
    public Response getNodes(String userId) {
        int AD_User_ID = this.getAD_User_ID(userId);
        if (AD_User_ID <= 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorBuilder().status(Response.Status.BAD_REQUEST).title("User not found").append("No user found matching id ").append(userId).build().toString()).build();
        }
        List<MWFActivity> activities = this.getUserPendingActivities(AD_User_ID);
        JsonArray array = new JsonArray();
        for (MWFActivity activity : activities) {
            array.add((JsonElement)this.getActivityJsonObject(activity));
        }
        JsonObject json = new JsonObject();
        json.addProperty("row-count", (Number)array.size());
        json.add("nodes", (JsonElement)array);
        return Response.ok((Object)json.toString()).build();
    }

    private int getAD_User_ID(String userId) {
        if (Util.isEmpty((String)userId)) {
            return Env.getAD_User_ID((Properties)Env.getCtx());
        }
        MUser user = (MUser)RestUtils.getPO("AD_User", userId, true, false);
        return user == null ? -1 : user.getAD_User_ID();
    }

    private List<MWFActivity> getUserPendingActivities(int AD_User_ID) {
        String whereClause = WorkflowResourceImpl.getWhereUserPendingActivities();
        return new Query(Env.getCtx(), "AD_WF_Activity", whereClause, null).setParameters(new Object[]{AD_User_ID, AD_User_ID, AD_User_ID, AD_User_ID, AD_User_ID, Env.getAD_Client_ID((Properties)Env.getCtx())}).setClient_ID().setOnlyActiveRecords(true).setOrderBy("AD_WF_Activity.Priority DESC, AD_WF_Activity.Created").list();
    }

    private JsonObject getActivityJsonObject(MWFActivity activity) {
        int recordId;
        int tableId;
        String history;
        String nodeHelp;
        String nodeDesc;
        JsonObject json = new JsonObject();
        json.addProperty("id", (Number)activity.getAD_WF_Activity_ID());
        if (!Util.isEmpty((String)activity.getAD_WF_Activity_UU())) {
            json.addProperty("uid", activity.getAD_WF_Activity_UU());
        }
        json.addProperty("model-name", activity.get_TableName().toLowerCase());
        json.addProperty("node-name", activity.getNodeName());
        json.addProperty("priority", (Number)activity.getPriority());
        String summary = activity.getSummary();
        if (!Util.isEmpty((String)summary, (boolean)true)) {
            json.addProperty("summary", summary);
        }
        if (!Util.isEmpty((String)(nodeDesc = activity.getNodeDescription()), (boolean)true)) {
            json.addProperty("node-description", nodeDesc);
        }
        if (!Util.isEmpty((String)(nodeHelp = activity.getNodeHelp()), (boolean)true)) {
            json.addProperty("node-help", nodeHelp);
        }
        if (!Util.isEmpty((String)(history = activity.getHistoryHTML()), (boolean)true)) {
            json.addProperty("history-records", history);
        }
        if ((tableId = activity.getAD_Table_ID()) > 0) {
            json.addProperty("table-name", MTable.getTableName((Properties)Env.getCtx(), (int)tableId));
            json.addProperty("ad_table_id", (Number)tableId);
        }
        if ((recordId = activity.getRecord_ID()) > 0) {
            json.addProperty("record_id", (Number)recordId);
        }
        json.addProperty("node-approval", Boolean.valueOf(activity.isUserApproval()));
        json.addProperty("node-confirmation", Boolean.valueOf(activity.isUserManual()));
        Object created = new DateTypeConverter().toJsonValue(16, new Date(activity.getCreated().getTime()));
        if (created != null) {
            json.addProperty("created", created.toString());
        }
        return json;
    }

    @Override
    public Response approve(String nodeId, String jsonText) {
        log.info("approve node: " + nodeId);
        log.info(jsonText);
        return this.actionActivity(nodeId, jsonText, "Y", true, false);
    }

    @Override
    public Response reject(String nodeId, String jsonText) {
        log.info("Reject node: " + nodeId);
        log.info(jsonText);
        return this.actionActivity(nodeId, jsonText, "N", true, false);
    }

    @Override
    public Response setUserChoice(String nodeId, String jsonText) {
        log.info("setuserchoice node: " + nodeId);
        log.info(jsonText);
        Gson gson = new GsonBuilder().create();
        JsonObject jsonObject = (JsonObject)gson.fromJson(jsonText, JsonObject.class);
        String value = this.getValueProperty(jsonObject);
        return this.actionActivity(nodeId, jsonText, value, false, false);
    }

    @Override
    public Response acknowledge(String nodeId, String jsonText) {
        log.info("acknowledge node: " + nodeId);
        log.info(jsonText);
        return this.actionActivity(nodeId, jsonText, null, false, true);
    }

    private Response actionActivity(String nodeId, String jsonText, String value, boolean isApproval, boolean isConfirmation) {
        String history;
        MWFActivity activity = null;
        try (Trx trx = null;){
            trx = Trx.get((String)Trx.createTrxName((String)"RWFS"), (boolean)true);
            trx.setDisplayName(String.valueOf(this.getClass().getName()) + "_setUserChoice");
            activity = (MWFActivity)RestUtils.getPO("AD_WF_Activity", nodeId, true, true);
            if (activity == null) {
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Activity not found").build().toString()).build();
                return response;
            }
            int currentUserId = Env.getAD_User_ID((Properties)Env.getCtx());
            if (!this.isValidActionUser(currentUserId, activity)) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorBuilder().status(Response.Status.BAD_REQUEST).title("The current User cannot action this Activity").build().toString()).build();
                return response;
            }
            activity.set_TrxName(trx.getTrxName());
            if (isApproval && !activity.getNode().isUserApproval()) {
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Not an approval node").build().toString()).build();
                return response;
            }
            if (isConfirmation && !activity.getNode().isUserManual()) {
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Not an acknowledgment node").build().toString()).build();
                return response;
            }
            if (!(isApproval || isConfirmation || activity.getNode().isUserChoice())) {
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Not a user choice node").build().toString()).build();
                return response;
            }
            try {
                String textMsg = null;
                if (!Util.isEmpty((String)jsonText, (boolean)true)) {
                    Gson gson = new GsonBuilder().create();
                    JsonObject jsonObject = (JsonObject)gson.fromJson(jsonText, JsonObject.class);
                    textMsg = this.getMessageProperty(jsonObject);
                }
                if (isConfirmation) {
                    activity.setUserConfirmation(currentUserId, textMsg);
                } else {
                    activity.setUserChoice(currentUserId, value, activity.getNode().getColumn().getAD_Reference_ID(), textMsg);
                }
                MWFProcess wfpr = new MWFProcess(activity.getCtx(), activity.getAD_WF_Process_ID(), activity.get_TrxName());
                wfpr.checkCloseActivities(activity.get_TrxName());
                trx.commit();
            }
            catch (Exception ex) {
                if (trx != null) {
                    trx.rollback();
                }
                log.log(Level.SEVERE, ex.getMessage(), (Throwable)ex);
                Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorBuilder().status(Response.Status.INTERNAL_SERVER_ERROR).title("Approve error").append("Approve error with exception: ").append(ex.getMessage()).build().toString()).build();
                return response;
            }
        }
        JsonObject json = new JsonObject();
        json.addProperty("msg", Msg.getMsg((Properties)Env.getCtx(), (String)"Updated"));
        String summary = activity.getSummary();
        if (!Util.isEmpty((String)summary, (boolean)true)) {
            json.addProperty("summary", summary);
        }
        if (!Util.isEmpty((String)(history = activity.getHistoryHTML()), (boolean)true)) {
            json.addProperty("history-records", history);
        }
        return Response.ok((Object)json.toString()).build();
    }

    @Override
    public Response forward(String nodeId, String jsonText) {
        String history;
        Gson gson = new GsonBuilder().create();
        JsonObject jsonObject = (JsonObject)gson.fromJson(jsonText, JsonObject.class);
        MUser user = this.getForwardToUser(jsonObject);
        if (user == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorBuilder().status(Response.Status.BAD_REQUEST).title("userTo property is mandatory.").append("userTo property is not set or it has an invalid value").build().toString()).build();
        }
        MBPartner bp = null;
        if (user.getC_BPartner_ID() > 0) {
            bp = MBPartner.get((Properties)Env.getCtx(), (int)user.getC_BPartner_ID());
        }
        if (bp == null || !bp.isEmployee() && !bp.isSalesRep()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorBuilder().status(Response.Status.BAD_REQUEST).title("Invalid user - not Internal").build().toString()).build();
        }
        MWFActivity activity = null;
        try (Trx trx = null;){
            trx = Trx.get((String)Trx.createTrxName((String)"RWFF"), (boolean)true);
            trx.setDisplayName(String.valueOf(this.getClass().getName()) + "_forward");
            activity = (MWFActivity)RestUtils.getPO("AD_WF_Activity", nodeId, true, true);
            if (activity == null) {
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Activity not found").build().toString()).build();
                return response;
            }
            int currentUserId = Env.getAD_User_ID((Properties)Env.getCtx());
            if (!this.isValidActionUser(currentUserId, activity)) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorBuilder().status(Response.Status.BAD_REQUEST).title("The current User cannot action this Activity").build().toString()).build();
                return response;
            }
            activity.set_TrxName(trx.getTrxName());
            String textMsg = null;
            if (!Util.isEmpty((String)jsonText, (boolean)true)) {
                textMsg = this.getMessageProperty(jsonObject);
            }
            if (!activity.forwardTo(user.getAD_User_ID(), textMsg)) {
                trx.rollback();
                Response response = Response.status((Response.Status)Response.Status.NOT_MODIFIED).entity((Object)new ErrorBuilder().status(Response.Status.NOT_MODIFIED).title(Msg.getMsg((Properties)Env.getCtx(), (String)"CannotForward")).build().toString()).build();
                return response;
            }
            try {
                trx.commit();
            }
            catch (Exception ex) {
                if (trx != null) {
                    trx.rollback();
                }
                log.log(Level.SEVERE, ex.getMessage(), (Throwable)ex);
                Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorBuilder().status(Response.Status.INTERNAL_SERVER_ERROR).title("Forward error").append("Forward error with exception: ").append(ex.getMessage()).build().toString()).build();
                return response;
            }
        }
        JsonObject json = new JsonObject();
        json.addProperty("msg", Msg.getMsg((Properties)Env.getCtx(), (String)"Updated"));
        String summary = activity.getSummary();
        if (!Util.isEmpty((String)summary, (boolean)true)) {
            json.addProperty("summary", summary);
        }
        if (!Util.isEmpty((String)(history = activity.getHistoryHTML()), (boolean)true)) {
            json.addProperty("history-records", history);
        }
        return Response.ok((Object)json.toString()).build();
    }

    private MUser getForwardToUser(JsonObject jsonObject) {
        JsonElement jsonElement = jsonObject.get("userTo");
        if (jsonElement == null || !jsonElement.isJsonPrimitive() || Util.isEmpty((String)jsonElement.getAsString(), (boolean)true)) {
            return null;
        }
        String userId = jsonElement.getAsString();
        return (MUser)RestUtils.getPO("AD_User", userId, true, false);
    }

    private String getValueProperty(JsonObject jsonObject) {
        return this.getStringProperty(jsonObject, "value");
    }

    private String getMessageProperty(JsonObject jsonObject) {
        return this.getStringProperty(jsonObject, "message");
    }

    private String getStringProperty(JsonObject jsonObject, String memberName) {
        JsonElement jsonElement = jsonObject.get(memberName);
        if (jsonElement == null || !jsonElement.isJsonPrimitive() || Util.isEmpty((String)jsonElement.getAsString(), (boolean)true)) {
            return "";
        }
        return jsonElement.getAsString();
    }

    private boolean isValidActionUser(int AD_User_ID, MWFActivity activity) {
        String whereClause = WorkflowResourceImpl.getWhereUserPendingActivities();
        whereClause = String.valueOf(whereClause) + " AND AD_WF_Activity.AD_WF_Activity_ID=?";
        int cnt = new Query(Env.getCtx(), "AD_WF_Activity", whereClause, null).setParameters(new Object[]{AD_User_ID, AD_User_ID, AD_User_ID, AD_User_ID, AD_User_ID, Env.getAD_Client_ID((Properties)Env.getCtx()), activity.getAD_WF_Activity_ID()}).setClient_ID().setOnlyActiveRecords(true).count();
        return cnt == 1;
    }

    private static String getWhereUserPendingActivities() {
        return "AD_WF_Activity.Processed='N' AND AD_WF_Activity.WFState='OS' AND ( AD_WF_Activity.AD_User_ID=? OR EXISTS (SELECT * FROM AD_WF_Responsible r WHERE AD_WF_Activity.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND r.ResponsibleType='H' AND COALESCE(r.AD_User_ID,0)=0 AND COALESCE(r.AD_Role_ID,0)=0 AND (AD_WF_Activity.AD_User_ID=? OR AD_WF_Activity.AD_User_ID IS NULL)) OR EXISTS (SELECT * FROM AD_WF_Responsible r WHERE AD_WF_Activity.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND r.ResponsibleType='H' AND r.AD_User_ID=?) OR EXISTS (SELECT * FROM AD_WF_Responsible r INNER JOIN AD_User_Roles ur ON (r.AD_Role_ID=ur.AD_Role_ID) WHERE AD_WF_Activity.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND r.ResponsibleType='R' AND ur.AD_User_ID=? AND ur.isActive = 'Y') OR EXISTS (SELECT * FROM AD_WF_ActivityApprover r  WHERE AD_WF_Activity.AD_WF_Activity_ID=r.AD_WF_Activity_ID AND r.AD_User_ID=? AND r.isActive = 'Y')) AND AD_WF_Activity.AD_Client_ID=?";
    }
}

