/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.copyobject.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.glassfish.pfl.dynamic.copyobject.impl.CachingClassCopierFactory;
import org.glassfish.pfl.dynamic.copyobject.impl.ClassCopier;
import org.glassfish.pfl.dynamic.copyobject.impl.ClassCopierFactory;
import org.glassfish.pfl.dynamic.copyobject.impl.DefaultClassCopierFactories;
import org.glassfish.pfl.dynamic.copyobject.impl.DefaultClassCopiers;
import org.glassfish.pfl.dynamic.copyobject.impl.Exceptions;
import org.glassfish.pfl.dynamic.copyobject.impl.PipelineClassCopierFactory;
import org.glassfish.pfl.dynamic.copyobject.spi.ReflectiveCopyException;

public class ClassCopierFactoryPipelineImpl
implements PipelineClassCopierFactory {
    private static final Class<?>[] notCopyable = new Class[]{Thread.class, ThreadGroup.class, ProcessBuilder.class};
    private static final Class<?>[] immutable = new Class[]{Process.class, Class.class, ClassLoader.class, SecurityManager.class, Runtime.class, System.class, Package.class, Field.class, Method.class, Constructor.class, AccessControlContext.class, Object.class, String.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Double.class, Float.class, Boolean.class, Logger.class, LogManager.class};
    private static final Class<?>[] mapClasses = new Class[]{IdentityHashMap.class, LinkedHashMap.class};
    private CachingClassCopierFactory factoryCache;
    private ClassCopierFactory specialFactory;
    private ClassCopierFactory arrayFactory;
    private ClassCopierFactory ordinaryFactory;
    private ClassCopier errorCopier;
    private ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock();

    public ClassCopierFactoryPipelineImpl() {
        this.factoryCache = DefaultClassCopierFactories.makeCachingClassCopierFactory();
        this.specialFactory = DefaultClassCopierFactories.getNullClassCopierFactory();
        this.arrayFactory = DefaultClassCopierFactories.makeArrayClassCopierFactory(this);
        this.ordinaryFactory = DefaultClassCopierFactories.makeOrdinaryClassCopierFactory(this);
        this.errorCopier = DefaultClassCopiers.getErrorClassCopier();
        for (Class<?> cls : immutable) {
            this.registerImmutable(cls);
        }
        ClassCopier mapCopier = DefaultClassCopiers.makeMapClassCopier(this);
        for (Class<?> cls : mapClasses) {
            this.factoryCache.put(cls, mapCopier);
        }
        for (Class<?> cls : notCopyable) {
            this.factoryCache.put(cls, this.errorCopier);
        }
    }

    @Override
    public boolean reflectivelyCopyable(Class<?> cls) {
        for (Class<?> cl : notCopyable) {
            if (cls != cl) continue;
            return false;
        }
        return true;
    }

    @Override
    public ClassCopier lookupInCache(Class<?> cls) {
        try {
            return this.factoryCache.getClassCopier(cls);
        }
        catch (ReflectiveCopyException exc) {
            return null;
        }
    }

    @Override
    public final synchronized void registerImmutable(Class<?> cls) {
        this.factoryCache.put(cls, DefaultClassCopiers.getIdentityClassCopier());
    }

    @Override
    public void setSpecialClassCopierFactory(ClassCopierFactory ccf) {
        this.specialFactory = ccf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassCopier getClassCopier(Class<?> cls) throws ReflectiveCopyException {
        if (cls.isInterface()) {
            throw Exceptions.self.cannotCopyInterface(cls);
        }
        this.rwlock.readLock().lock();
        boolean readLocked = true;
        try {
            ClassCopier result = this.factoryCache.getClassCopier(cls);
            if (result == null) {
                if (Enum.class.isAssignableFrom(cls)) {
                    result = DefaultClassCopiers.getIdentityClassCopier();
                }
                if (result == null) {
                    result = this.specialFactory.getClassCopier(cls);
                }
                if (result == null) {
                    result = this.arrayFactory.getClassCopier(cls);
                }
                if (result == null) {
                    result = this.ordinaryFactory.getClassCopier(cls);
                }
                if (result == null) {
                    throw Exceptions.self.couldNotFindClassCopier(cls);
                }
                this.rwlock.readLock().unlock();
                readLocked = false;
                this.rwlock.writeLock().lock();
                try {
                    if (this.factoryCache.getClassCopier(cls) == null) {
                        this.factoryCache.put(cls, result);
                    }
                }
                finally {
                    this.rwlock.writeLock().unlock();
                }
            }
            if (result == this.errorCopier) {
                throw Exceptions.self.cannotCopyClass(cls);
            }
            ClassCopier classCopier = result;
            return classCopier;
        }
        finally {
            if (readLocked) {
                this.rwlock.readLock().unlock();
            }
        }
    }
}

