/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.jwt;

import com.trekglobal.idempiere.rest.api.v1.jwt.DefaultTokenSecretProvider;
import com.trekglobal.idempiere.rest.api.v1.jwt.ITokenSecretProvider;
import com.trekglobal.idempiere.rest.api.v1.jwt.SysConfigTokenSecretProvider;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.base.Service;
import org.compiere.model.MSysConfig;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class TokenUtils {
    private TokenUtils() {
    }

    public static String getTokenSecret() {
        ITokenSecretProvider provider = (ITokenSecretProvider)Service.locator().locate(ITokenSecretProvider.class).getService();
        if (provider != null) {
            return provider.getSecret();
        }
        if (MSysConfig.getBooleanValue((String)"REST_USE_SYSCONFIG_SECRET", (boolean)true)) {
            return SysConfigTokenSecretProvider.instance.getSecret();
        }
        return DefaultTokenSecretProvider.instance.getSecret();
    }

    public static String getTokenKeyId() {
        ITokenSecretProvider provider = (ITokenSecretProvider)Service.locator().locate(ITokenSecretProvider.class).getService();
        if (provider != null) {
            return provider.getKeyId();
        }
        return DefaultTokenSecretProvider.instance.getKeyId();
    }

    public static String getTokenIssuer() {
        ITokenSecretProvider provider = (ITokenSecretProvider)Service.locator().locate(ITokenSecretProvider.class).getService();
        if (provider != null) {
            return provider.getIssuer();
        }
        return DefaultTokenSecretProvider.instance.getIssuer();
    }

    public static Timestamp getTokenExpiresAt() {
        int expMinutes = MSysConfig.getIntValue((String)"REST_TOKEN_EXPIRE_IN_MINUTES", (int)60, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        if (expMinutes == 0) {
            return null;
        }
        return TimeUtil.addMinutess((Timestamp)new Timestamp(System.currentTimeMillis()), (int)expMinutes);
    }

    public static Timestamp getTokenAbsoluteExpiresAt() {
        int expMinutes = MSysConfig.getIntValue((String)"REST_TOKEN_ABSOLUTE_EXPIRE_IN_MINUTES", (int)10080, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        if (expMinutes == 0) {
            return null;
        }
        return TimeUtil.addMinutess((Timestamp)new Timestamp(System.currentTimeMillis()), (int)expMinutes);
    }

    public static Timestamp getRefreshTokenExpiresAt() {
        int expMinutes = MSysConfig.getIntValue((String)"REST_REFRESH_TOKEN_EXPIRE_IN_MINUTES", (int)1440, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        if (expMinutes == 0) {
            return null;
        }
        return TimeUtil.addMinutess((Timestamp)new Timestamp(System.currentTimeMillis()), (int)expMinutes);
    }
}

