/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource.info;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.json.RestUtils;
import com.trekglobal.idempiere.rest.api.json.TypeConverterUtils;
import com.trekglobal.idempiere.rest.api.v1.resource.info.QueryResponse;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.model.IInfoColumn;
import org.adempiere.model.MInfoProcess;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.UUIDColumn;
import org.compiere.model.AccessSqlParser;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.MColumn;
import org.compiere.model.MInfoColumn;
import org.compiere.model.MInfoWindow;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public class InfoWindow {
    private static final CLogger log = CLogger.getCLogger(InfoWindow.class);
    private MInfoWindow infoWindowModel;
    private AccessSqlParser.TableInfo[] tableInfos;
    private String p_whereClause;
    private String p_orderBy;
    private MInfoColumn[] infoColumns;
    private ArrayList<GridField> gridFields;
    private MInfoColumn keyColumnOfView;
    private List<ColumnInfo> columnInfos;
    private String p_keyColumn;
    private String m_sqlMain;
    private String m_sqlOrder;
    private MInfoProcess[] infoProcessList;
    private String tableName;
    private Map<String, JsonElement> queryParameters;
    private boolean useAnd;
    private List<Object> statementParameters = null;
    private List<MInfoColumn> statementParameterColumns = null;

    public InfoWindow(MInfoWindow iw, String whereClause, String orderBy, boolean and) {
        this.infoWindowModel = iw;
        this.p_whereClause = whereClause;
        this.p_orderBy = orderBy;
        this.useAnd = and;
        this.loadInfoDefinition();
        this.prepareQuery();
    }

    private void loadInfoDefinition() {
        this.tableName = MTable.getTableName((Properties)Env.getCtx(), (int)this.infoWindowModel.getAD_Table_ID());
        this.p_keyColumn = RestUtils.getKeyColumnName(this.tableName);
        AccessSqlParser sqlParser = new AccessSqlParser("SELECT * FROM " + this.infoWindowModel.getFromClause());
        this.tableInfos = sqlParser.getTableInfo(0);
        if (this.tableInfos[0].getSynonym() != null && this.tableInfos[0].getSynonym().trim().length() > 0) {
            String alias = this.tableInfos[0].getSynonym().trim();
            if (this.p_whereClause != null && this.p_whereClause.trim().length() > 0) {
                this.p_whereClause = this.p_whereClause.replace(String.valueOf(this.tableName) + ".", String.valueOf(alias) + ".");
            }
        }
        this.infoColumns = this.infoWindowModel.getInfoColumns(this.tableInfos);
        this.gridFields = new ArrayList();
        MInfoColumn[] mInfoColumnArray = this.infoColumns;
        int n = this.infoColumns.length;
        int n2 = 0;
        while (n2 < n) {
            MInfoColumn infoColumn = mInfoColumnArray[n2];
            if (infoColumn.isKey()) {
                this.keyColumnOfView = infoColumn;
            }
            GridField gridField = this.toGridField(infoColumn);
            this.gridFields.add(gridField);
            ++n2;
        }
        StringBuilder builder = new StringBuilder(this.p_whereClause != null ? this.p_whereClause.trim() : "");
        String infoWhereClause = this.infoWindowModel.getWhereClause();
        if (infoWhereClause != null && infoWhereClause.indexOf("@") >= 0 && (infoWhereClause = Env.parseContext((Properties)Env.getCtx(), (int)0, (String)infoWhereClause, (boolean)true, (boolean)false)).length() == 0) {
            log.log(Level.SEVERE, "Cannot parse context= " + this.infoWindowModel.getWhereClause());
        }
        if (infoWhereClause != null && infoWhereClause.trim().length() > 0) {
            if (builder.length() > 0) {
                builder.append(" AND ");
            }
            builder.append(infoWhereClause);
            this.p_whereClause = builder.toString();
        }
        this.infoProcessList = this.infoWindowModel.getInfoProcess(false);
    }

    private GridField toGridField(MInfoColumn infoColumn) {
        String desc;
        String columnName = infoColumn.getColumnName();
        boolean isMandatory = infoColumn.isMandatory() && infoColumn.isQueryCriteria();
        GridFieldVO vo = GridFieldVO.createParameter((Properties)Env.getCtx(), (int)0, (int)0, (int)this.infoWindowModel.getAD_InfoWindow_ID(), (int)0, (String)columnName, (String)infoColumn.get_Translation("Name"), (int)infoColumn.getAD_Reference_ID(), (int)infoColumn.getAD_Reference_Value_ID(), (boolean)isMandatory, (boolean)false, (String)infoColumn.get_Translation("Placeholder"));
        if (infoColumn.getAD_Val_Rule_ID() > 0) {
            vo.ValidationCode = infoColumn.getAD_Val_Rule().getCode();
            if (vo.lookupInfo != null) {
                vo.lookupInfo.ValidationCode = vo.ValidationCode;
                vo.lookupInfo.IsValidated = false;
            }
        }
        if (infoColumn.getDisplayLogic() != null) {
            vo.DisplayLogic = infoColumn.getDisplayLogic();
        }
        if (infoColumn.isQueryCriteria() && infoColumn.getDefaultValue() != null) {
            vo.DefaultValue = infoColumn.getDefaultValue();
        }
        vo.Description = (desc = infoColumn.get_Translation("Description")) != null ? desc : "";
        String help = infoColumn.get_Translation("Help");
        vo.Help = help != null ? help : "";
        vo.AD_FieldStyle_ID = infoColumn.getAD_FieldStyle_ID();
        GridField gridField = new GridField(vo);
        return gridField;
    }

    private void prepareQuery() {
        ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
        String keyTableAlias = this.tableInfos[0].getSynonym() != null && this.tableInfos[0].getSynonym().trim().length() > 0 ? this.tableInfos[0].getSynonym() : this.tableInfos[0].getTableName();
        String keySelectClause = String.valueOf(keyTableAlias) + "." + this.p_keyColumn;
        ColumnInfo columnInfo = new ColumnInfo(" ", keySelectClause, IDColumn.class, true, false, null, this.p_keyColumn);
        columnInfo = this.p_keyColumn.endsWith("_UU") ? new ColumnInfo(" ", keySelectClause, UUIDColumn.class, true, false, null, this.p_keyColumn) : new ColumnInfo(" ", keySelectClause, IDColumn.class, true, false, null, this.p_keyColumn);
        columnInfo.setGridField(this.findGridField(this.p_keyColumn));
        list.add(columnInfo);
        int i = 0;
        MInfoColumn[] mInfoColumnArray = this.infoColumns;
        int n = this.infoColumns.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                block3: {
                    MInfoColumn infoColumn = mInfoColumnArray[n2];
                    if (!infoColumn.isDisplayed(Env.getCtx(), 0)) break block3;
                    if (infoColumn.getAD_Reference_ID() == 13 && infoColumn.getSelectClause().equalsIgnoreCase(keySelectClause)) break block4;
                    GridField gridField = this.gridFields.get(i);
                    columnInfo = this.toColumnInfo(infoColumn, gridField);
                    list.add(columnInfo);
                }
                ++i;
            }
            ++n2;
        }
        this.columnInfos = list;
        this.prepareQuery(list.toArray(new ColumnInfo[0]), this.infoWindowModel.getFromClause(), this.p_whereClause, this.p_orderBy != null ? this.p_orderBy : this.infoWindowModel.getOrderByClause());
    }

    private ColumnInfo toColumnInfo(MInfoColumn infoColumn, GridField gridField) {
        ColumnInfo columnInfo = null;
        String colSQL = infoColumn.getSelectClause();
        if (!colSQL.toUpperCase().contains(" AS ")) {
            colSQL = String.valueOf(colSQL) + " AS " + infoColumn.getColumnName();
        }
        columnInfo = infoColumn.getAD_Reference_ID() == 13 ? new ColumnInfo(infoColumn.get_Translation("Name"), colSQL, DisplayType.getClass((int)infoColumn.getAD_Reference_ID(), (boolean)true), infoColumn.isReadOnly()) : (DisplayType.isLookup((int)infoColumn.getAD_Reference_ID()) ? (DisplayType.isList((int)infoColumn.getAD_Reference_ID()) ? new ColumnInfo(infoColumn.get_Translation("Name"), colSQL, ValueNamePair.class, null, infoColumn.isReadOnly()) : this.createLookupColumnInfo(this.tableInfos, gridField, infoColumn)) : new ColumnInfo(infoColumn.get_Translation("Name"), colSQL, DisplayType.getClass((int)infoColumn.getAD_Reference_ID(), (boolean)true), infoColumn.isReadOnly()));
        columnInfo.setColDescription(infoColumn.get_Translation("Description"));
        columnInfo.setAD_Reference_ID(infoColumn.getAD_Reference_ID());
        columnInfo.setGridField(gridField);
        columnInfo.setColumnName(infoColumn.getColumnName());
        return columnInfo;
    }

    private ColumnInfo createLookupColumnInfo(AccessSqlParser.TableInfo[] tableInfos, GridField gridField, MInfoColumn infoColumn) {
        String colSQL;
        String columnName = gridField.getColumnName();
        String validationCode = "";
        MLookupInfo lookupInfo = MLookupFactory.getLookupInfo((Properties)Env.getCtx(), (int)0, (int)0, (int)infoColumn.getAD_Reference_ID(), (Language)Env.getLanguage((Properties)Env.getCtx()), (String)columnName, (int)infoColumn.getAD_Reference_Value_ID(), (boolean)false, (String)validationCode);
        String displayColumn = lookupInfo.DisplayColumn;
        int index = infoColumn.getSelectClause().indexOf(".");
        if (index == infoColumn.getSelectClause().lastIndexOf(".")) {
            String synonym = infoColumn.getSelectClause().substring(0, index);
            AccessSqlParser.TableInfo[] tableInfoArray = tableInfos;
            int n = tableInfos.length;
            int n2 = 0;
            while (n2 < n) {
                AccessSqlParser.TableInfo tableInfo = tableInfoArray[n2];
                if (tableInfo.getSynonym() != null && tableInfo.getSynonym().equals(synonym)) {
                    if (!tableInfo.getTableName().equalsIgnoreCase(lookupInfo.TableName)) break;
                    displayColumn = displayColumn.replace(String.valueOf(lookupInfo.TableName) + ".", String.valueOf(tableInfo.getSynonym()) + ".");
                    ColumnInfo columnInfo = new ColumnInfo(infoColumn.get_Translation("Name"), displayColumn, KeyNamePair.class, infoColumn.getSelectClause(), infoColumn.isReadOnly());
                    return columnInfo;
                }
                ++n2;
            }
        }
        if (!(colSQL = infoColumn.getSelectClause()).toUpperCase().contains(" AS ")) {
            colSQL = String.valueOf(colSQL) + " AS " + infoColumn.getColumnName();
        }
        Class colClass = columnName.endsWith("_ID") ? KeyNamePair.class : String.class;
        ColumnInfo columnInfo = new ColumnInfo(infoColumn.get_Translation("Name"), colSQL, colClass, null, infoColumn.isReadOnly());
        return columnInfo;
    }

    private void prepareQuery(ColumnInfo[] layout, String from, String where, String orderBy) {
        String sql;
        StringBuilder builder = new StringBuilder("SELECT ");
        int columnIndex = 0;
        while (columnIndex < layout.length) {
            if (columnIndex > 0) {
                builder.append(", ");
            }
            builder.append(layout[columnIndex].getColSQL());
            if (layout[columnIndex].isKeyPairCol()) {
                builder.append(",").append(layout[columnIndex].getKeyPairColSQL());
            }
            ++columnIndex;
        }
        builder.append(" FROM ").append(from);
        builder.append(" WHERE ");
        if (where != null) {
            builder.append(where);
        }
        this.m_sqlMain = sql = builder.toString();
        this.m_sqlOrder = "";
        if (orderBy != null && orderBy.trim().length() > 0) {
            this.m_sqlOrder = " ORDER BY " + orderBy;
        }
        if (this.m_sqlMain.indexOf("@") >= 0) {
            sql = Env.parseContext((Properties)Env.getCtx(), (int)0, (String)this.m_sqlMain, (boolean)true);
            if (sql == null || sql.length() == 0) {
                log.severe("Failed to parsed sql. sql=" + this.m_sqlMain);
            } else {
                this.m_sqlMain = sql;
            }
        }
        this.addViewIDToQuery();
        this.addKeyViewToQuery();
        if (this.m_sqlMain.length() > 0 && this.infoWindowModel.isDistinct()) {
            this.m_sqlMain = this.m_sqlMain.substring("SELECT ".length());
            this.m_sqlMain = "SELECT DISTINCT " + this.m_sqlMain;
        }
        if (this.m_sqlOrder != null && this.m_sqlOrder.indexOf("@") >= 0) {
            sql = Env.parseContext((Properties)Env.getCtx(), (int)0, (String)this.m_sqlOrder, (boolean)true, (boolean)false);
            if (sql == null || sql.length() == 0) {
                log.severe("Failed to parsed sql. sql=" + this.m_sqlOrder);
            } else {
                this.m_sqlOrder = sql;
            }
        }
    }

    private void addViewIDToQuery() {
        this.m_sqlMain = this.addMoreColumnToQuery(this.m_sqlMain, (IInfoColumn[])this.infoProcessList);
    }

    private void addKeyViewToQuery() {
        if (this.isNeedAppendKeyViewData()) {
            this.m_sqlMain = this.addMoreColumnToQuery(this.m_sqlMain, new IInfoColumn[]{this.keyColumnOfView});
        }
    }

    private boolean isNeedAppendKeyViewData() {
        return this.keyColumnOfView != null && !this.keyColumnOfView.isDisplayed(Env.getCtx(), 0);
    }

    private String addMoreColumnToQuery(String sqlMain, IInfoColumn[] listInfoColumn) {
        if (sqlMain == null || sqlMain.length() == 0 || listInfoColumn == null || listInfoColumn.length == 0) {
            return sqlMain;
        }
        int fromIndex = sqlMain.indexOf("FROM");
        String selectClause = sqlMain.substring(0, fromIndex);
        String fromClause = sqlMain.substring(fromIndex);
        StringBuilder sqlBuilder = new StringBuilder(selectClause);
        StringBuilder sqlColumn = new StringBuilder();
        IInfoColumn[] iInfoColumnArray = listInfoColumn;
        int n = listInfoColumn.length;
        int n2 = 0;
        while (n2 < n) {
            MInfoColumn infocol;
            IInfoColumn infoProcess = iInfoColumnArray[n2];
            if (infoProcess.getInfoColumnID() > 0 && !(infocol = infoProcess.getAD_InfoColumn()).isDisplayed()) {
                sqlColumn.append(", ").append(infocol.getSelectClause()).append(" AS ").append(infocol.getColumnName()).append(" ");
                if (!sqlBuilder.toString().contains(sqlColumn)) {
                    sqlBuilder.append((CharSequence)sqlColumn);
                    GridField gridField = this.findGridField(infocol.getColumnName());
                    if (gridField == null) {
                        gridField = this.toGridField(infocol);
                    }
                    ColumnInfo columnInfo = this.toColumnInfo(infocol, gridField);
                    this.columnInfos.add(columnInfo);
                }
                sqlColumn.delete(0, sqlColumn.length());
            }
            ++n2;
        }
        sqlBuilder.append(fromClause);
        return sqlBuilder.toString();
    }

    private String buildQuerySQL(int start, int end) {
        String dynWhere = this.getSQLWhere();
        StringBuilder sql = new StringBuilder(this.m_sqlMain);
        if (dynWhere.length() > 0) {
            sql.append(dynWhere);
        }
        if (sql.toString().trim().endsWith("WHERE")) {
            int index = sql.lastIndexOf(" WHERE");
            sql.delete(index, sql.length());
        }
        String dataSql = Msg.parseTranslation((Properties)Env.getCtx(), (String)sql.toString());
        String alias = this.tableName;
        if (this.tableInfos[0].getSynonym() != null && this.tableInfos[0].getSynonym().trim().length() > 0) {
            alias = this.tableInfos[0].getSynonym().trim();
        }
        dataSql = MRole.getDefault().addAccessSQL(dataSql, alias, true, false);
        if (end > start && DB.getDatabase().isPagingSupported()) {
            dataSql = DB.getDatabase().addPagingSQL(dataSql, start, end);
        }
        return dataSql;
    }

    private String getSQLWhere() {
        String sql;
        StringBuilder builder = new StringBuilder();
        MTable table = MTable.get((Properties)Env.getCtx(), (String)this.tableName);
        if (table.getColumnIndex("IsActive") >= 0) {
            if (this.p_whereClause != null && this.p_whereClause.trim().length() > 0) {
                builder.append(" AND ");
            }
            builder.append(this.tableInfos[0].getSynonym()).append(".IsActive='Y'");
        }
        int count = 0;
        this.statementParameters = new ArrayList<Object>();
        this.statementParameterColumns = new ArrayList<MInfoColumn>();
        block0: for (Map.Entry<String, JsonElement> entries : this.queryParameters.entrySet()) {
            String name = entries.getKey();
            for (GridField gridField : this.gridFields) {
                String pString;
                if (!gridField.getColumnName().equalsIgnoreCase(name)) continue;
                Object value = TypeConverterUtils.fromJsonValue(gridField, entries.getValue());
                MInfoColumn mInfoColumn = this.findInfoColumn(gridField);
                if (mInfoColumn == null || mInfoColumn.getSelectClause().equals("0")) continue block0;
                String columnName = mInfoColumn.getSelectClause();
                int asIndex = columnName.toUpperCase().lastIndexOf(" AS ");
                if (asIndex > 0) {
                    columnName = columnName.substring(0, asIndex);
                }
                if (++count == 1) {
                    if (builder.length() > 0) {
                        builder.append(" AND ");
                        if (!this.useAnd) {
                            builder.append(" ( ");
                        }
                    } else if (this.p_whereClause != null && this.p_whereClause.trim().length() > 0) {
                        builder.append(" AND ");
                        if (!this.useAnd) {
                            builder.append(" ( ");
                        }
                    } else if (!this.useAnd) {
                        builder.append(" ( ");
                    }
                } else {
                    builder.append(this.useAnd ? " AND " : " OR ");
                }
                if (mInfoColumn.getAD_Reference_ID() == 200161) {
                    int cnt;
                    pString = value.toString();
                    String column = columnName;
                    if (column.indexOf(".") > 0) {
                        column = column.substring(column.indexOf(".") + 1);
                    }
                    if ((cnt = DB.getSQLValueEx(null, (String)"SELECT Count(*) From AD_Column WHERE IsActive='Y' AND AD_Client_ID=0 AND Upper(ColumnName)=? AND AD_Reference_ID=?", (Object[])new Object[]{column.toUpperCase(), 200161})) > 0) {
                        builder.append(DB.intersectClauseForCSV((String)columnName, (String)pString));
                        continue block0;
                    }
                    builder.append(DB.inClauseForCSV((String)columnName, (String)pString));
                    continue block0;
                }
                if (mInfoColumn.getAD_Reference_ID() == 200162 || mInfoColumn.getAD_Reference_ID() == 200163) {
                    pString = value.toString();
                    if (columnName.endsWith("_ID")) {
                        builder.append(DB.inClauseForCSV((String)columnName, (String)pString));
                        continue block0;
                    }
                    builder.append(DB.intersectClauseForCSV((String)columnName, (String)pString));
                    continue block0;
                }
                String columnClause = null;
                if (mInfoColumn.getQueryFunction() != null && mInfoColumn.getQueryFunction().trim().length() > 0) {
                    String function = mInfoColumn.getQueryFunction();
                    if (function.indexOf("@") >= 0) {
                        String s = Env.parseContext((Properties)Env.getCtx(), (int)0, (String)function, (boolean)true, (boolean)false);
                        if (s.length() == 0) {
                            log.log(Level.SEVERE, "Failed to parse query function. " + function);
                        } else {
                            function = s;
                        }
                    }
                    columnClause = function.indexOf("?") >= 0 ? function.replaceFirst("[?]", columnName) : String.valueOf(function) + "(" + columnName + ")";
                } else {
                    columnClause = columnName;
                }
                builder.append(columnClause).append(" ").append(mInfoColumn.getQueryOperator());
                if (columnClause.toUpperCase().startsWith("UPPER(")) {
                    builder.append(" UPPER(?)");
                } else {
                    builder.append(" ?");
                }
                this.statementParameters.add(value);
                this.statementParameterColumns.add(mInfoColumn);
                continue block0;
            }
        }
        if (count > 0 && !this.useAnd) {
            builder.append(" ) ");
        }
        if ((sql = builder.toString()).indexOf("@") >= 0) {
            sql = Env.parseContext((Properties)Env.getCtx(), (int)0, (String)sql, (boolean)true, (boolean)true);
        }
        return sql;
    }

    private MInfoColumn findInfoColumn(GridField gridField) {
        int i = 0;
        while (i < this.gridFields.size()) {
            if (this.gridFields.get(i) == gridField) {
                return this.infoColumns[i];
            }
            ++i;
        }
        return null;
    }

    private GridField findGridField(String columnName) {
        int i = 0;
        while (i < this.gridFields.size()) {
            if (this.gridFields.get(i).getColumnName().equalsIgnoreCase(columnName)) {
                return this.gridFields.get(i);
            }
            ++i;
        }
        return null;
    }

    public void setQueryParameters(Map<String, JsonElement> paraMap) {
        this.queryParameters = paraMap;
    }

    public QueryResponse executeQuery(int pageSize, int pageNo, int defaultQueryTimeout) {
        QueryResponse response = new QueryResponse();
        if (pageNo <= 0) {
            pageNo = 1;
        }
        int pagesToSkip = pageNo - 1;
        int start = pageSize * pagesToSkip + 1;
        int end = pageSize * (pagesToSkip + 1) + 1;
        String sql = this.buildQuerySQL(start, end);
        JsonArray array = new JsonArray();
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            try (CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);){
                int i = 0;
                while (i < this.statementParameters.size()) {
                    Object value = this.statementParameters.get(i);
                    MInfoColumn infoColumn = this.statementParameterColumns.get(i);
                    this.setParameter((PreparedStatement)pstmt, i + 1, value, infoColumn.getQueryOperator());
                    ++i;
                }
                pstmt.setQueryTimeout(defaultQueryTimeout);
                ResultSet rs = pstmt.executeQuery();
                int count = 0;
                while (rs.next()) {
                    if (++count > pageSize) {
                        response.setHasNextPage(true);
                        break;
                    }
                    JsonObject json = new JsonObject();
                    for (ColumnInfo columnInfo : this.columnInfos) {
                        Object jsonValue;
                        Object value;
                        MTable table;
                        MColumn column = null;
                        GridField field = columnInfo.getGridField();
                        if (field == null && ((table = MTable.get((Properties)Env.getCtx(), (String)this.tableName)) == null || (column = table.getColumn(columnInfo.getColumnName())) == null) || (value = rs.getObject(columnInfo.getColumnName())) == null) continue;
                        String propertyName = columnInfo.getColumnName();
                        Object object = jsonValue = field != null ? TypeConverterUtils.toJsonValue(field, value) : TypeConverterUtils.toJsonValue(column, value);
                        if (jsonValue == null) continue;
                        if (jsonValue instanceof Number) {
                            json.addProperty(propertyName, (Number)jsonValue);
                            continue;
                        }
                        if (jsonValue instanceof Boolean) {
                            json.addProperty(propertyName, (Boolean)jsonValue);
                            continue;
                        }
                        if (jsonValue instanceof String) {
                            json.addProperty(propertyName, (String)jsonValue);
                            continue;
                        }
                        if (jsonValue instanceof JsonElement) {
                            json.add(propertyName, (JsonElement)jsonValue);
                            continue;
                        }
                        json.addProperty(propertyName, jsonValue.toString());
                    }
                    array.add((JsonElement)json);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        response.setRecords(array);
        return response;
    }

    private void setParameter(PreparedStatement pstmt, int parameterIndex, Object value, String queryOperator) throws SQLException {
        if (value instanceof Boolean) {
            pstmt.setString(parameterIndex, (Boolean)value != false ? "Y" : "N");
        } else if (value instanceof String) {
            StringBuilder valueStr = new StringBuilder(value.toString());
            if (queryOperator.equals("Like")) {
                if (!valueStr.toString().endsWith("%")) {
                    valueStr.append("%");
                }
            } else if (queryOperator.equals("LIKE")) {
                if (!valueStr.toString().startsWith("%")) {
                    valueStr.insert(0, "%");
                }
                if (!valueStr.toString().endsWith("%")) {
                    valueStr.append("%");
                }
            }
            pstmt.setString(parameterIndex, valueStr.toString());
        } else {
            pstmt.setObject(parameterIndex, value);
        }
    }
}

