/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.util.ErrorBuilder;
import com.trekglobal.idempiere.rest.api.v1.resource.CacheResource;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.core.Response;
import org.compiere.model.MRole;
import org.compiere.model.MUser;
import org.compiere.util.CacheInfo;
import org.compiere.util.CacheMgt;
import org.compiere.util.Env;

public class CacheResourceImpl
implements CacheResource {
    public static final int PROCESS_CACHE_RESET = 205;

    @Override
    public Response getCaches(String tableName, String name) {
        MUser user = MUser.get((Properties)Env.getCtx());
        if (!user.isAdministrator()) {
            return this.forbidden("Access denied", "Access denied for get caches request");
        }
        List cacheInfos = CacheInfo.getCacheInfos((boolean)true);
        JsonArray caches = new JsonArray();
        for (CacheInfo cacheInfo : cacheInfos) {
            if (cacheInfo.getName().endsWith("|CCacheListener") || tableName != null && !tableName.equals(cacheInfo.getTableName()) || name != null && !name.equals(cacheInfo.getName())) continue;
            JsonObject cache = new JsonObject();
            cache.addProperty("name", cacheInfo.getName());
            cache.addProperty("tableName", cacheInfo.getTableName());
            cache.addProperty("size", (Number)cacheInfo.getSize());
            cache.addProperty("expireMinutes", (Number)cacheInfo.getExpireMinutes());
            cache.addProperty("maxSize", (Number)cacheInfo.getMaxSize());
            cache.addProperty("distributed", Boolean.valueOf(cacheInfo.isDistributed()));
            if (cacheInfo.getNodeId() != null) {
                cache.addProperty("nodeId", cacheInfo.getNodeId());
            }
            caches.add((JsonElement)cache);
        }
        JsonObject json = new JsonObject();
        json.add("caches", (JsonElement)caches);
        return Response.ok((Object)json.toString()).build();
    }

    @Override
    public Response resetCache(String tableName, int recordId) {
        Boolean hasAccess = MRole.getDefault().getProcessAccess(205);
        if (hasAccess == null || !hasAccess.booleanValue()) {
            return this.forbidden("Access denied", "Access denied for cache reset request");
        }
        int count = 0;
        count = tableName == null ? CacheMgt.get().reset() : (recordId > 0 ? CacheMgt.get().reset(tableName, recordId) : CacheMgt.get().reset(tableName));
        return Response.ok((Object)("{\"entriesReset\": " + count + "}")).build();
    }

    private Response forbidden(String title, String detail) {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title(title).append(detail).build().toString()).build();
    }
}

