/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.model;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import com.trekglobal.idempiere.rest.api.model.X_REST_AuthToken;
import com.trekglobal.idempiere.rest.api.v1.jwt.LoginClaims;
import com.trekglobal.idempiere.rest.api.v1.jwt.TokenUtils;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MSession;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Login;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.idempiere.cache.ImmutablePOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MAuthToken
extends X_REST_AuthToken
implements ImmutablePOSupport {
    private static final long serialVersionUID = -3420277395055535123L;
    private static ImmutablePOCache<String, MAuthToken> s_authtoken_cache = new ImmutablePOCache("REST_AuthToken", 40);

    public MAuthToken(Properties ctx, int REST_AuthToken_ID, String trxName) {
        super(ctx, REST_AuthToken_ID, trxName);
    }

    public MAuthToken(Properties ctx, String REST_AuthToken_UUID, String trxName) {
        super(ctx, REST_AuthToken_UUID, trxName);
    }

    public MAuthToken(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAuthToken(MAuthToken copy) {
        this(Env.getCtx(), copy);
    }

    public MAuthToken(Properties ctx, MAuthToken copy) {
        this(ctx, copy, null);
    }

    public MAuthToken(Properties ctx, MAuthToken copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    protected boolean beforeSave(boolean newRecord) {
        Properties tempCtx = new Properties();
        Env.setContext((Properties)tempCtx, (String)"#AD_Client_ID", (int)this.getAD_Client_ID());
        Login login = new Login(tempCtx);
        KeyNamePair knpr = new KeyNamePair(this.getAD_Role_ID(), "dummy");
        KeyNamePair[] orgs = login.getOrgs(knpr);
        boolean validOrg = false;
        KeyNamePair[] keyNamePairArray = orgs;
        int n = orgs.length;
        int n2 = 0;
        while (n2 < n) {
            KeyNamePair org = keyNamePairArray[n2];
            if (this.getAD_Org_ID() == org.getKey()) {
                validOrg = true;
                break;
            }
            ++n2;
        }
        if (!validOrg) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"RoleInconsistent"));
            return false;
        }
        if (this.getM_Warehouse_ID() > 0) {
            KeyNamePair knpo = new KeyNamePair(this.getAD_Org_ID(), "dummy");
            KeyNamePair[] whs = login.getWarehouses(knpo);
            boolean validWh = false;
            KeyNamePair[] keyNamePairArray2 = whs;
            int n3 = whs.length;
            int n4 = 0;
            while (n4 < n3) {
                KeyNamePair wh = keyNamePairArray2[n4];
                if (this.getM_Warehouse_ID() == wh.getKey()) {
                    validWh = true;
                    break;
                }
                ++n4;
            }
            if (!validWh) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"WarehouseOrgConflict"));
                return false;
            }
        }
        if (newRecord) {
            MUser u = MUser.get((int)this.getAD_User_ID());
            JWTCreator.Builder builder = JWT.create().withSubject(u.getName());
            int clientId = this.getAD_Client_ID();
            builder.withClaim(LoginClaims.AD_Client_ID.name(), Integer.valueOf(clientId));
            builder.withClaim(LoginClaims.AD_User_ID.name(), Integer.valueOf(u.getAD_User_ID()));
            builder.withClaim(LoginClaims.AD_Role_ID.name(), Integer.valueOf(this.getAD_Role_ID()));
            builder.withClaim(LoginClaims.AD_Org_ID.name(), Integer.valueOf(this.getAD_Org_ID()));
            if (this.getAD_Org_ID() > 0 && this.getM_Warehouse_ID() > 0) {
                builder.withClaim(LoginClaims.M_Warehouse_ID.name(), Integer.valueOf(this.getM_Warehouse_ID()));
            }
            builder.withClaim(LoginClaims.AD_Language.name(), this.getAD_Language());
            Env.setContext((Properties)tempCtx, (String)"#AD_Client_ID", (int)this.getAD_Client_ID());
            Env.setContext((Properties)tempCtx, (String)"#AD_Language", (String)this.getAD_Language());
            Env.setContext((Properties)tempCtx, (String)"#AD_Org_ID", (int)this.getAD_Org_ID());
            Env.setContext((Properties)tempCtx, (String)"#M_Warehouse_ID", (int)this.getM_Warehouse_ID());
            Env.setContext((Properties)tempCtx, (String)"#AD_User_ID", (int)this.getAD_User_ID());
            Env.setContext((Properties)tempCtx, (String)"#SalesRep_ID", (int)this.getAD_User_ID());
            Env.setContext((Properties)tempCtx, (String)"#AD_Role_ID", (int)this.getAD_Role_ID());
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            SimpleDateFormat dateFormat4Timestamp = new SimpleDateFormat("yyyy-MM-dd");
            Env.setContext((Properties)tempCtx, (String)"#Date", (String)(String.valueOf(dateFormat4Timestamp.format(ts)) + " 00:00:00"));
            MSession session = MSession.get((Properties)tempCtx);
            if (session == null) {
                this.log.fine("No Session found");
                session = MSession.create((Properties)tempCtx);
            }
            this.setAD_Session_ID(session.getAD_Session_ID());
            session.setWebSession("idempiere-rest");
            session.saveEx();
            builder.withClaim(LoginClaims.AD_Session_ID.name(), Integer.valueOf(session.getAD_Session_ID()));
            builder = builder.withIssuer(TokenUtils.getTokenIssuer());
            if (this.getExpireInMinutes() > 0) {
                Timestamp expiresAt = new Timestamp(System.currentTimeMillis());
                expiresAt = TimeUtil.addMinutess((Timestamp)expiresAt, (int)this.getExpireInMinutes());
                builder = builder.withExpiresAt((Date)expiresAt);
                this.setExpiresAt(expiresAt);
            }
            builder = builder.withKeyId(TokenUtils.getTokenKeyId());
            try {
                String token = builder.sign(Algorithm.HMAC512((String)TokenUtils.getTokenSecret()));
                this.setToken(token);
                this.setProcessed(true);
            }
            catch (Exception e) {
                throw new AdempiereException(e.getMessage());
            }
        }
        return super.beforeSave(newRecord);
    }

    public static MAuthToken get(Properties ctx, String token) {
        MAuthToken retValue = null;
        if (s_authtoken_cache.containsKey((Object)token)) {
            retValue = (MAuthToken)s_authtoken_cache.get(ctx, (Object)token.toString(), e -> new MAuthToken(ctx, (MAuthToken)e));
            return retValue;
        }
        retValue = (MAuthToken)new Query(ctx, "REST_AuthToken", "Token=?", null).setParameters(new Object[]{token}).first();
        s_authtoken_cache.put((Object)token, (PO)retValue, e -> new MAuthToken(ctx, (MAuthToken)e));
        return retValue;
    }

    public static boolean isBlocked(String token) {
        MAuthToken auth = MAuthToken.get(Env.getCtx(), token);
        return auth != null && (auth.isExpired() || !auth.isActive());
    }

    public PO markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        super.makeImmutable();
        return this;
    }
}

