/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.util;

public class Paging {
    private int _pgsz = 20;
    private int _ttsz = 0;
    private int _npg = 1;
    private int _actpg = 0;

    public Paging() {
    }

    public Paging(int totalsz, int pagesz) {
        this();
        this.setTotalSize(totalsz);
        this.setPageSize(pagesz);
    }

    public int getPageSize() {
        return this._pgsz;
    }

    public void setPageSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("positive only");
        }
        if (this._pgsz != size) {
            this._pgsz = size;
            this.updatePageNum();
        }
    }

    public int getTotalSize() {
        return this._ttsz;
    }

    public void setTotalSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("non-negative only");
        }
        if (this._ttsz != size) {
            this._ttsz = size;
            this.updatePageNum();
        }
    }

    private void updatePageNum() {
        int v = (this._ttsz - 1) / this._pgsz + 1;
        if (v == 0) {
            v = 1;
        }
        if (v != this._npg) {
            this._npg = v;
            if (this._actpg >= this._npg) {
                this._actpg = this._npg - 1;
            }
        }
    }

    public int getPageCount() {
        return this._npg;
    }

    public int getActivePage() {
        return this._actpg;
    }

    public void setActivePage(int pg) throws IllegalArgumentException {
        if (pg >= this._npg || pg < 0) {
            throw new IllegalArgumentException("Unable to set active page to " + pg + " since only " + this._npg + " pages");
        }
        if (this._actpg != pg) {
            this._actpg = pg;
        }
    }
}

