/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.json;

import com.google.gson.JsonElement;
import com.trekglobal.idempiere.rest.api.json.IDempiereRestException;
import com.trekglobal.idempiere.rest.api.json.ITypeConverter;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.ws.rs.core.Response;
import org.compiere.model.GridField;
import org.compiere.model.MColumn;
import org.compiere.util.DisplayType;

public class DateTypeConverter
implements ITypeConverter<Date> {
    public static final String ISO8601_DATE_PATTERN = "yyyy-MM-dd";
    public static final String ISO8601_TIME_PATTERN = "HH:mm:ss'Z'";
    public static final String ISO8601_DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    public Object toJsonValue(int displayType, Date value) {
        String pattern = this.getPattern(displayType);
        if (DisplayType.isDate((int)displayType) && pattern != null && value != null) {
            String formatted = new SimpleDateFormat(pattern).format(value);
            return formatted;
        }
        return null;
    }

    @Override
    public Object toJsonValue(MColumn column, Date value) {
        return this.toJsonValue(column.getAD_Reference_ID(), value);
    }

    @Override
    public Object toJsonValue(GridField field, Date value) {
        return this.toJsonValue(field.getDisplayType(), value);
    }

    private Timestamp fromJsonValue(int displayType, JsonElement value) {
        String pattern = this.getPattern(displayType);
        if (DisplayType.isDate((int)displayType) && pattern != null && value != null) {
            Date parsed = null;
            try {
                parsed = new SimpleDateFormat(pattern).parse(value.getAsString());
            }
            catch (ParseException e) {
                throw new IDempiereRestException("Invalid date", "The " + DisplayType.getDescription((int)displayType) + " pattern should be: " + pattern + ". Exception: " + e.getLocalizedMessage(), Response.Status.BAD_REQUEST);
            }
            return new Timestamp(parsed.getTime());
        }
        return null;
    }

    @Override
    public Object fromJsonValue(MColumn column, JsonElement value) {
        return this.fromJsonValue(column.getAD_Reference_ID(), value);
    }

    @Override
    public Object fromJsonValue(GridField field, JsonElement value) {
        return this.fromJsonValue(field.getDisplayType(), value);
    }

    private String getPattern(int displayType) {
        if (displayType == 15) {
            return ISO8601_DATE_PATTERN;
        }
        if (displayType == 24) {
            return ISO8601_TIME_PATTERN;
        }
        if (displayType == 16) {
            return ISO8601_DATETIME_PATTERN;
        }
        return null;
    }
}

