/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MCountry;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_Region;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.idempiere.cache.ImmutablePOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MRegion
extends X_C_Region
implements Comparator<Object>,
Serializable,
ImmutablePOSupport {
    private static final long serialVersionUID = 6956706379305907673L;
    private static ImmutablePOCache<Integer, MRegion> s_regions = new ImmutablePOCache("C_Region", "C_Region", 100, 0, false, 0);
    private static MRegion s_default = null;
    private static CLogger s_log = CLogger.getCLogger(MRegion.class);

    private static void loadAllRegions() {
        List regions;
        s_regions.clear();
        try {
            PO.setCrossTenantSafe();
            regions = new Query(Env.getCtx(), "C_Region", "", null).setOnlyActiveRecords(true).list();
        }
        finally {
            PO.clearCrossTenantSafe();
        }
        for (MRegion r : regions) {
            r.markImmutable();
            s_regions.put(r.getC_Region_ID(), r);
            if (!r.isDefault()) continue;
            s_default = r;
        }
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine(s_regions.size() + " - default=" + String.valueOf(s_default));
        }
    }

    public static synchronized MRegion get(int C_Region_ID) {
        return MRegion.get(Env.getCtx(), C_Region_ID);
    }

    public static synchronized MRegion get(Properties ctx, int C_Region_ID) {
        MRegion r;
        if (s_regions.size() == 0) {
            MRegion.loadAllRegions();
        }
        if ((r = s_regions.get(ctx, C_Region_ID, e -> new MRegion(ctx, (MRegion)e))) != null) {
            return r;
        }
        r = new MRegion(ctx, C_Region_ID, null);
        if (r.getC_Region_ID() == C_Region_ID) {
            s_regions.put(C_Region_ID, r, e -> new MRegion(Env.getCtx(), (MRegion)e));
            return r;
        }
        return null;
    }

    @Deprecated
    public static synchronized MRegion getDefault(Properties ctx) {
        return MRegion.getDefault();
    }

    public static synchronized MRegion getDefault() {
        if (s_regions.size() == 0) {
            MRegion.loadAllRegions();
        }
        return s_default;
    }

    @Deprecated
    public static synchronized MRegion[] getRegions(Properties ctx) {
        return MRegion.getRegions();
    }

    public static synchronized MRegion[] getRegions() {
        if (s_regions.size() == 0) {
            MRegion.loadAllRegions();
        }
        MRegion[] retValue = (MRegion[])s_regions.values().stream().toArray(MRegion[]::new);
        Arrays.sort(retValue, new MRegion(Env.getCtx(), 0, null));
        return retValue;
    }

    @Deprecated
    public static synchronized MRegion[] getRegions(Properties ctx, int C_Country_ID) {
        return MRegion.getRegions(C_Country_ID);
    }

    public static synchronized MRegion[] getRegions(int C_Country_ID) {
        if (s_regions.size() == 0) {
            MRegion.loadAllRegions();
        }
        MRegion[] retValue = (MRegion[])s_regions.values().stream().filter(e -> e.getC_Country_ID() == C_Country_ID).toArray(MRegion[]::new);
        Arrays.sort(retValue, new MRegion(Env.getCtx(), 0, null));
        return retValue;
    }

    public MRegion(Properties ctx, String C_Region_UU, String trxName) {
        super(ctx, C_Region_UU, trxName);
    }

    public MRegion(Properties ctx, int C_Region_ID, String trxName) {
        super(ctx, C_Region_ID, trxName);
    }

    public MRegion(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRegion(MCountry country, String regionName) {
        super(country.getCtx(), 0, country.get_TrxName());
        this.setC_Country_ID(country.getC_Country_ID());
        this.setName(regionName);
    }

    public MRegion(MRegion copy) {
        this(Env.getCtx(), copy);
    }

    public MRegion(Properties ctx, MRegion copy) {
        this(ctx, copy, null);
    }

    public MRegion(Properties ctx, MRegion copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    @Override
    public String toString() {
        return this.getTrlName();
    }

    public String getTrlName() {
        return this.getTrlName(Env.getAD_Language(Env.getCtx()));
    }

    public String getTrlName(String language) {
        return this.get_Translation("Name", language);
    }

    @Override
    public int compare(Object o1, Object o2) {
        String s2;
        String s1 = o1.toString();
        if (s1 == null) {
            s1 = "";
        }
        if ((s2 = o2.toString()) == null) {
            s2 = "";
        }
        Collator collator = Collator.getInstance();
        return collator.compare(s1, s2);
    }

    @Override
    public MRegion markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

