/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInOutLineConfirm;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MRefList;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Query;
import org.compiere.model.X_M_InOut;
import org.compiere.model.X_M_InOutConfirm;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MInOutConfirm
extends X_M_InOutConfirm
implements DocAction {
    private static final long serialVersionUID = -1998947558580855224L;
    private static CLogger s_log = CLogger.getCLogger(MInOutConfirm.class);
    private MInOutLineConfirm[] m_lines = null;
    private MInvoice m_creditMemo = null;
    private MInventory m_inventory = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public static MInOutConfirm create(MInOut ship, String confirmType, boolean checkExisting) {
        if (checkExisting) {
            MInOutConfirm[] confirmations = ship.getConfirmations(false);
            int i = 0;
            while (i < confirmations.length) {
                MInOutConfirm confirm = confirmations[i];
                if (confirm.getConfirmType().equals(confirmType)) {
                    if (s_log.isLoggable(Level.INFO)) {
                        s_log.info("create - existing: " + String.valueOf(confirm));
                    }
                    return confirm;
                }
                ++i;
            }
        }
        MInOutConfirm confirm = new MInOutConfirm(ship, confirmType);
        confirm.saveEx();
        MInOutLine[] shipLines = ship.getLines(false);
        int i = 0;
        while (i < shipLines.length) {
            MInOutLine sLine = shipLines[i];
            MInOutLineConfirm cLine = new MInOutLineConfirm(confirm);
            cLine.setInOutLine(sLine);
            cLine.saveEx();
            ++i;
        }
        if (s_log.isLoggable(Level.INFO)) {
            s_log.info("New: " + String.valueOf(confirm));
        }
        return confirm;
    }

    public MInOutConfirm(Properties ctx, String M_InOutConfirm_UU, String trxName) {
        super(ctx, M_InOutConfirm_UU, trxName);
        if (Util.isEmpty(M_InOutConfirm_UU)) {
            this.setInitialDefaults();
        }
    }

    public MInOutConfirm(Properties ctx, int M_InOutConfirm_ID, String trxName) {
        super(ctx, M_InOutConfirm_ID, trxName);
        if (M_InOutConfirm_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setDocAction("CO");
        this.setDocStatus("DR");
        this.setIsApproved(false);
        this.setIsCancelled(false);
        this.setIsInDispute(false);
        super.setProcessed(false);
    }

    public MInOutConfirm(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInOutConfirm(MInOut ship, String confirmType) {
        this(ship.getCtx(), 0, ship.get_TrxName());
        this.setClientOrg(ship);
        this.setM_InOut_ID(ship.getM_InOut_ID());
        this.setConfirmType(confirmType);
    }

    public MInOutLineConfirm[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            MInOutConfirm.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        List<MInOutLineConfirm> list = new Query(this.getCtx(), "M_InOutLineConfirm", "M_InOutConfirm_ID=?", this.get_TrxName()).setParameters(this.getM_InOutConfirm_ID()).list();
        this.m_lines = new MInOutLineConfirm[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            StringBuilder msgd = new StringBuilder(desc).append(" | ").append(description);
            this.setDescription(msgd.toString());
        }
    }

    public String getConfirmTypeName() {
        return MRefList.getListName(this.getCtx(), 320, this.getConfirmType());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MInOutConfirm[");
        sb.append(this.get_ID()).append("-").append(this.getSummary()).append("]");
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        StringBuilder msgreturn = new StringBuilder().append(Msg.getElement(this.getCtx(), "M_InOutConfirm_ID")).append(" ").append(this.getDocumentNo());
        return msgreturn.toString();
    }

    @Override
    public File createPDF() {
        try {
            StringBuilder msgfile = new StringBuilder().append(this.get_TableName()).append(this.get_ID()).append("_");
            File temp = File.createTempFile(msgfile.toString(), ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public void setIsApproved(boolean IsApproved) {
        if (IsApproved && !this.isApproved()) {
            int AD_User_ID = Env.getAD_User_ID(this.getCtx());
            MUser user = MUser.get(this.getCtx(), AD_User_ID);
            StringBuilder info = new StringBuilder().append(user.getName()).append(": ").append(Msg.translate(this.getCtx(), "IsApproved")).append(" - ").append(new Timestamp(System.currentTimeMillis()));
            this.addDescription(info.toString());
        }
        super.setIsApproved(IsApproved);
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MInOutLineConfirm[] lines = this.getLines(true);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        boolean difference = false;
        int i = 0;
        while (i < lines.length) {
            if (!lines[i].isFullyConfirmed()) {
                difference = true;
                break;
            }
            ++i;
        }
        this.setIsInDispute(difference);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String valid;
        MDocType dt;
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        MInOut inout = new MInOut(this.getCtx(), this.getM_InOut_ID(), this.get_TrxName());
        MInOutLineConfirm[] lines = this.getLines(false);
        if (this.isInDispute() && (dt = MDocType.get(this.getCtx(), inout.getC_DocType_ID())).isSplitWhenDifference()) {
            if (dt.getC_DocTypeDifference_ID() == 0) {
                this.m_processMsg = "No Split Document Type defined for: " + dt.getName();
                return "IN";
            }
            this.splitInOut(inout, dt.getC_DocTypeDifference_ID(), lines);
            this.m_lines = null;
        }
        int i = 0;
        while (i < lines.length) {
            MInOutLineConfirm confirmLine = lines[i];
            confirmLine.set_TrxName(this.get_TrxName());
            if (!confirmLine.processLine(inout.isSOTrx(), this.getConfirmType())) {
                this.m_processMsg = "ShipLine not saved - " + String.valueOf(confirmLine);
                return "IN";
            }
            if (confirmLine.isFullyConfirmed()) {
                confirmLine.setProcessed(true);
                confirmLine.saveEx();
            } else if (this.createDifferenceDoc(inout, confirmLine)) {
                confirmLine.setProcessed(true);
                confirmLine.saveEx();
            } else {
                this.log.log(Level.SEVERE, "Scrapped=" + String.valueOf(confirmLine.getScrappedQty()) + " - Difference=" + String.valueOf(confirmLine.getDifferenceQty()));
                return "IN";
            }
            ++i;
        }
        if (this.m_creditMemo != null) {
            this.m_processMsg = String.valueOf(this.m_processMsg) + " @C_Invoice_ID@=" + this.m_creditMemo.getDocumentNo();
        }
        if (this.m_inventory != null) {
            this.m_processMsg = String.valueOf(this.m_processMsg) + " @M_Inventory_ID@=" + this.m_inventory.getDocumentNo();
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate(this, 9)) != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void splitInOut(MInOut original, int C_DocType_ID, MInOutLineConfirm[] confirmLines) {
        X_M_InOut split = null;
        int i = 0;
        while (i < confirmLines.length) {
            MInOutLineConfirm confirmLine = confirmLines[i];
            BigDecimal differenceQty = confirmLine.getDifferenceQty();
            if (differenceQty.compareTo(Env.ZERO) != 0) {
                MInOutLine oldLine = confirmLine.getLine();
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Qty=" + String.valueOf(differenceQty) + ", Old=" + String.valueOf(oldLine));
                }
                if (split == null) {
                    split = new MInOut(original, C_DocType_ID, original.getMovementDate());
                    StringBuilder msgd = new StringBuilder("Splitted from ").append(original.getDocumentNo());
                    ((MInOut)split).addDescription(msgd.toString());
                    split.setIsInDispute(true);
                    split.saveEx();
                    msgd = new StringBuilder("Split: ").append(split.getDocumentNo());
                    original.addDescription(msgd.toString());
                    original.saveEx();
                }
                MInOutLine splitLine = new MInOutLine((MInOut)split);
                splitLine.setC_OrderLine_ID(oldLine.getC_OrderLine_ID());
                splitLine.setC_UOM_ID(oldLine.getC_UOM_ID());
                splitLine.setDescription(oldLine.getDescription());
                splitLine.setIsDescription(oldLine.isDescription());
                splitLine.setLine(oldLine.getLine());
                splitLine.setM_AttributeSetInstance_ID(oldLine.getM_AttributeSetInstance_ID());
                splitLine.setM_Locator_ID(oldLine.getM_Locator_ID());
                splitLine.setM_Product_ID(oldLine.getM_Product_ID());
                splitLine.setM_Warehouse_ID(oldLine.getM_Warehouse_ID());
                splitLine.setRef_InOutLine_ID(oldLine.getRef_InOutLine_ID());
                StringBuilder msgd = new StringBuilder("Split: from ").append(oldLine.getMovementQty());
                splitLine.addDescription(msgd.toString());
                splitLine.setQty(differenceQty);
                splitLine.saveEx();
                msgd = new StringBuilder("Splitted: from ").append(oldLine.getMovementQty());
                oldLine.addDescription(msgd.toString());
                oldLine.setQty(oldLine.getMovementQty().subtract(differenceQty));
                oldLine.saveEx();
                confirmLine.setTargetQty(confirmLine.getTargetQty().subtract(differenceQty));
                confirmLine.setDifferenceQty(Env.ZERO);
                confirmLine.saveEx();
            }
            ++i;
        }
        if (split == null) {
            return;
        }
        this.m_processMsg = "Split @M_InOut_ID@=" + split.getDocumentNo() + " - @M_InOutConfirm_ID@=";
        MDocType dt = MDocType.get(this.getCtx(), original.getC_DocType_ID());
        if (!dt.isPrepareSplitDocument()) {
            return;
        }
        if (!((MInOut)split).processIt("PR")) {
            throw new AdempiereException(((MInOut)split).getProcessMsg());
        }
        split.saveEx();
        MInOutConfirm[] splitConfirms = ((MInOut)split).getConfirmations(true);
        if (splitConfirms.length > 0) {
            int index = 0;
            if (splitConfirms[index].isProcessed()) {
                if (splitConfirms.length > 1) {
                    ++index;
                }
                if (splitConfirms[index].isProcessed()) {
                    this.m_processMsg = String.valueOf(this.m_processMsg) + splitConfirms[index].getDocumentNo() + " processed??";
                    return;
                }
            }
            splitConfirms[index].setIsInDispute(true);
            splitConfirms[index].saveEx();
            this.m_processMsg = String.valueOf(this.m_processMsg) + splitConfirms[index].getDocumentNo();
            MInOutLineConfirm[] splitConfirmLines = splitConfirms[index].getLines(false);
            int i2 = 0;
            while (i2 < splitConfirmLines.length) {
                MInOutLineConfirm splitConfirmLine = splitConfirmLines[i2];
                splitConfirmLine.setScrappedQty(Env.ZERO);
                splitConfirmLine.setConfirmedQty(Env.ZERO);
                splitConfirmLine.saveEx();
                ++i2;
            }
        } else {
            this.m_processMsg = String.valueOf(this.m_processMsg) + "??";
        }
    }

    private boolean createDifferenceDoc(MInOut inout, MInOutLineConfirm confirm) {
        if (this.m_processMsg == null) {
            this.m_processMsg = "";
        } else if (this.m_processMsg.length() > 0) {
            this.m_processMsg = String.valueOf(this.m_processMsg) + "; ";
        }
        if (confirm.getDifferenceQty().signum() != 0 && !inout.isSOTrx() && inout.getRef_InOut_ID() != 0) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Difference=" + String.valueOf(confirm.getDifferenceQty()));
            }
            if (this.m_creditMemo == null) {
                this.m_creditMemo = new MInvoice(inout, null);
                StringBuilder msgd = new StringBuilder().append(Msg.translate(this.getCtx(), "M_InOutConfirm_ID")).append(" ").append(this.getDocumentNo());
                this.m_creditMemo.setDescription(msgd.toString());
                this.m_creditMemo.setC_DocTypeTarget_ID("APC");
                this.m_creditMemo.saveEx();
                this.setC_Invoice_ID(this.m_creditMemo.getC_Invoice_ID());
            }
            MInvoiceLine line = new MInvoiceLine(this.m_creditMemo);
            line.setShipLine(confirm.getLine());
            if (confirm.getLine().getProduct() != null) {
                line.setC_UOM_ID(confirm.getLine().getProduct().getC_UOM_ID());
            }
            line.setQty(confirm.getDifferenceQty());
            line.saveEx();
            confirm.setC_InvoiceLine_ID(line.getC_InvoiceLine_ID());
        }
        if (confirm.getScrappedQty().signum() != 0) {
            MInOutLine ioLine;
            MInventoryLine line;
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Scrapped=" + String.valueOf(confirm.getScrappedQty()));
            }
            if (this.m_inventory == null) {
                MWarehouse wh = MWarehouse.get(this.getCtx(), inout.getM_Warehouse_ID());
                this.m_inventory = new MInventory(wh, this.get_TrxName());
                StringBuilder msgd = new StringBuilder().append(Msg.translate(this.getCtx(), "M_InOutConfirm_ID")).append(" ").append(this.getDocumentNo());
                this.m_inventory.setDescription(msgd.toString());
                this.setInventoryDocType(this.m_inventory);
                this.m_inventory.saveEx();
                this.setM_Inventory_ID(this.m_inventory.getM_Inventory_ID());
            }
            if (!(line = new MInventoryLine(this.m_inventory, (ioLine = confirm.getLine()).getM_Locator_ID(), ioLine.getM_Product_ID(), ioLine.getM_AttributeSetInstance_ID(), confirm.getScrappedQty(), Env.ZERO)).save(this.get_TrxName())) {
                this.m_processMsg = String.valueOf(this.m_processMsg) + "Inventory Line not created";
                return false;
            }
            confirm.setM_InventoryLine_ID(line.getM_InventoryLine_ID());
        }
        if (!confirm.save(this.get_TrxName())) {
            this.m_processMsg = String.valueOf(this.m_processMsg) + "Confirmation Line not saved";
            return false;
        }
        return true;
    }

    private void setInventoryDocType(MInventory inventory) {
        MDocType[] doctypes;
        MDocType[] mDocTypeArray = doctypes = MDocType.getOfDocBaseType(Env.getCtx(), "MMI");
        int n = doctypes.length;
        int n2 = 0;
        while (n2 < n) {
            MDocType doctype = mDocTypeArray[n2];
            if ("PI".equals(doctype.getDocSubTypeInv())) {
                inventory.setC_DocType_ID(doctype.getC_DocType_ID());
                break;
            }
            ++n2;
        }
    }

    @Override
    public boolean voidIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            MInOut inout = (MInOut)this.getM_InOut();
            if (!"VO".equals(inout.getDocStatus()) && !"RE".equals(inout.getDocStatus())) {
                throw new AdempiereException("@M_InOut_ID@ @DocStatus@<>VO");
            }
            MInOutLineConfirm[] mInOutLineConfirmArray = this.getLines(true);
            int n = mInOutLineConfirmArray.length;
            int n2 = 0;
            while (n2 < n) {
                MInOutLineConfirm confirmLine = mInOutLineConfirmArray[n2];
                confirmLine.setTargetQty(Env.ZERO);
                confirmLine.setConfirmedQty(Env.ZERO);
                confirmLine.setScrappedQty(Env.ZERO);
                confirmLine.setDifferenceQty(Env.ZERO);
                confirmLine.setProcessed(true);
                confirmLine.saveEx();
                ++n2;
            }
        } else {
            return this.reverseCorrectIt();
        }
        this.setIsCancelled(true);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "ApprovalAmt")).append("=").append(this.getApprovalAmt()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getUpdatedBy();
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }
}

