/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.X_C_Charge;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MCharge
extends X_C_Charge
implements ImmutablePOSupport {
    private static final long serialVersionUID = 1978008783808254164L;
    private static ImmutableIntPOCache<Integer, MCharge> s_cache = new ImmutableIntPOCache("C_Charge", 10);
    private static CLogger s_log = CLogger.getCLogger(MCharge.class);

    @Deprecated(forRemoval=true, since="11")
    public static MAccount getAccount(int C_Charge_ID, MAcctSchema as, BigDecimal amount) {
        return MCharge.getAccount(C_Charge_ID, as);
    }

    public static MAccount getAccount(int C_Charge_ID, MAcctSchema as) {
        if (C_Charge_ID == 0 || as == null) {
            return null;
        }
        String sql = "SELECT Ch_Expense_Acct FROM C_Charge_Acct WHERE C_Charge_ID=? AND C_AcctSchema_ID=?";
        int Account_ID = DB.getSQLValueEx(null, sql, C_Charge_ID, as.get_ID());
        if (Account_ID <= 0) {
            s_log.severe("NO account for C_Charge_ID=" + C_Charge_ID);
            return null;
        }
        MAccount acct = MAccount.get(as.getCtx(), Account_ID);
        return acct;
    }

    public static MCharge get(int C_Charge_ID) {
        return MCharge.get(Env.getCtx(), C_Charge_ID);
    }

    public static MCharge get(Properties ctx, int C_Charge_ID) {
        Integer key = C_Charge_ID;
        MCharge retValue = s_cache.get(ctx, key, e -> new MCharge(ctx, (MCharge)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MCharge(ctx, C_Charge_ID, null);
        if (retValue.get_ID() == C_Charge_ID) {
            s_cache.put(key, retValue, e -> new MCharge(Env.getCtx(), (MCharge)e));
            return retValue;
        }
        return null;
    }

    public static MCharge getCopy(Properties ctx, int C_Charge_ID, String trxName) {
        MCharge charge = MCharge.get(C_Charge_ID);
        if (charge != null) {
            charge = new MCharge(ctx, charge, trxName);
        }
        return charge;
    }

    public MCharge(Properties ctx, String C_Charge_UU, String trxName) {
        super(ctx, C_Charge_UU, trxName);
        if (Util.isEmpty(C_Charge_UU)) {
            this.setInitialDefaults();
        }
    }

    public MCharge(Properties ctx, int C_Charge_ID, String trxName) {
        super(ctx, C_Charge_ID, trxName);
        if (C_Charge_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setChargeAmt(Env.ZERO);
        this.setIsSameCurrency(false);
        this.setIsSameTax(false);
        this.setIsTaxIncluded(false);
    }

    public MCharge(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCharge(MCharge copy) {
        this(Env.getCtx(), copy);
    }

    public MCharge(Properties ctx, MCharge copy) {
        this(ctx, copy, null);
    }

    public MCharge(Properties ctx, MCharge copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && success) {
            this.insert_Accounting("C_Charge_Acct", "C_AcctSchema_Default", null);
        }
        return success;
    }

    @Override
    public MCharge markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

