/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.sql.Timestamp;
import java.util.StringTokenizer;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MLocation;
import org.compiere.model.MProcessPara;
import org.compiere.model.MSysConfig;
import org.compiere.process.ProcessInfoLog;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;

@Process
public class ValidateAddressProcess
extends SvrProcess {
    private int p_C_AddressValidation_ID;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i2 = 0;
        while (i2 < para.length) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() != null) {
                if (name.equals("C_AddressValidation_ID")) {
                    this.p_C_AddressValidation_ID = para[i2].getParameterAsInt();
                } else {
                    MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para[i2]);
                }
            }
            ++i2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_C_AddressValidation_ID == 0) {
            throw new AdempiereException(Msg.getMsg(Env.getCtx(), "FillMandatory") + Msg.getElement(Env.getCtx(), "C_AddressValidation_ID"));
        }
        MLocation m_location = new MLocation(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        String addressValidation = MSysConfig.getValue("ADDRESS_VALIDATION", null, m_location.getAD_Client_ID());
        boolean isEnabled = false;
        if (addressValidation != null && addressValidation.trim().length() > 0 && m_location.getCountry() != null) {
            StringTokenizer st = new StringTokenizer(addressValidation, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (!token.equals(m_location.getCountry().getCountryCode().trim())) continue;
                isEnabled = true;
                break;
            }
        }
        if (!isEnabled) {
            throw new AdempiereException(Msg.getMsg(Env.getCtx(), "AddressValidationNotEnabledForCountry"));
        }
        boolean ok = m_location.processOnline(this.p_C_AddressValidation_ID);
        m_location.saveEx();
        if (!ok) {
            this.getProcessInfo().setError(true);
            this.getProcessInfo().addLog(new ProcessInfoLog(this.getProcessInfo().getAD_Process_ID(), new Timestamp(System.currentTimeMillis()), null, m_location.getErrorMessage()));
            return m_location.getErrorMessage();
        }
        this.getProcessInfo().addLog(new ProcessInfoLog(this.getProcessInfo().getAD_Process_ID(), new Timestamp(System.currentTimeMillis()), null, m_location.getResult()));
        return m_location.getResult();
    }
}

