/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

@Process
public class Fill1099Extract
extends SvrProcess {
    private Timestamp p_Cut_Date = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i2 = 0;
        while (i2 < para.length) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() != null) {
                if (name.equals("Cut_Date")) {
                    this.p_Cut_Date = (Timestamp)para[i2].getParameter();
                } else {
                    MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para[i2]);
                }
            }
            ++i2;
        }
        if (this.p_Cut_Date == null) {
            this.p_Cut_Date = new Timestamp(System.currentTimeMillis());
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("CUT_DATE=" + String.valueOf(this.p_Cut_Date));
        }
        int AD_PInstance_ID = this.getAD_PInstance_ID();
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO T_1099EXTRACT ");
        sql.append("(ad_pinstance_id, ad_client_id, ad_org_id, isactive, created, ");
        sql.append("createdby, updated, updatedby, c_bpartner_id, value, name, taxid, ");
        sql.append("c_location_id, cut_year, cut_date, amtbucket01, amtbucket02, ");
        sql.append("amtbucket03, amtbucket04, amtbucket05, amtbucket06, amtbucket07, ");
        sql.append("amtbucket08, amtbucket09, amtbucket10, amtbucket11, amtbucket12, ");
        sql.append("amtbucket13, amtbucket14, amtbucket15, amtbucket16) ");
        sql.append("SELECT ?, bp.ad_client_id, bp.ad_org_id, bp.isactive, bp.created, bp.createdby, ");
        sql.append("bp.updated, bp.updatedby, bp.c_bpartner_id, bp.value, bp.name, bp.taxid, ");
        sql.append("bpl.c_location_id, ");
        if (DB.isPostgreSQL()) {
            sql.append("date_part('year', ?::timestamp), trunc(?::timestamp),");
        } else {
            sql.append("EXTRACT(year from ?), TRUNC (?), ");
        }
        sql.append("get1099bucket (bp.c_bpartner_id, ?, 1), ");
        sql.append("get1099bucket (bp.c_bpartner_id, ?, 2), ");
        sql.append("get1099bucket (bp.c_bpartner_id, ?, 3), ");
        sql.append("get1099bucket (bp.c_bpartner_id, ?, 4), ");
        sql.append("get1099bucket (bp.c_bpartner_id, ?, 5), ");
        sql.append("get1099bucket (bp.c_bpartner_id, ?, 6), ");
        sql.append("get1099bucket (bp.c_bpartner_id, ?, 7), ");
        sql.append("get1099bucket (bp.c_bpartner_id, ?, 8), ");
        sql.append("get1099bucket (bp.c_bpartner_id, ?, 9), ");
        sql.append("get1099bucket (bp.c_bpartner_id, ?, 10), ");
        sql.append("get1099bucket (bp.c_bpartner_id, ?, 11), ");
        sql.append("get1099bucket (bp.c_bpartner_id, ?, 12), ");
        sql.append("get1099bucket (bp.c_bpartner_id, ?, 13), ");
        sql.append("get1099bucket (bp.c_bpartner_id, ?, 14), ");
        sql.append("get1099bucket (bp.c_bpartner_id, ?, 15), ");
        sql.append("get1099bucket (bp.c_bpartner_id, ?, 16) ");
        sql.append("FROM c_bpartner bp, c_bpartner_location bpl ");
        sql.append("WHERE bp.c_bpartner_id = bpl.c_bpartner_id ");
        sql.append("AND bp.isactive = 'Y' ");
        sql.append("AND bp.ad_client_id = ? ");
        sql.append("AND bp.isvendor = 'Y' ");
        sql.append("AND bp.is1099vendor = 'Y' ");
        sql.append("AND bpl.c_bpartner_location_id IN ( ");
        sql.append(" SELECT i.c_bpartner_location_id ");
        sql.append(" FROM c_invoice i, c_invoiceline il ");
        sql.append(" WHERE i.c_invoice_id = il.c_invoice_id ");
        sql.append(" AND i.issotrx = 'N' ");
        sql.append(" AND i.docstatus IN ('CO', 'CL') ");
        sql.append(" AND i.ad_client_id = ? ");
        sql.append(" AND i.ispaid = 'Y' ");
        sql.append(" AND il.c_1099box_id IS NOT NULL ");
        sql.append(" AND i.dateacct BETWEEN ");
        if (DB.isPostgreSQL()) {
            sql.append("date_trunc('year', ?::timestamp) ");
        } else {
            sql.append("TRUNC (?, 'YEAR') ");
        }
        sql.append("AND ?) ");
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(sql.toString());
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            pstmt.setInt(1, AD_PInstance_ID);
            pstmt.setTimestamp(2, this.p_Cut_Date);
            pstmt.setTimestamp(3, this.p_Cut_Date);
            pstmt.setTimestamp(4, this.p_Cut_Date);
            pstmt.setTimestamp(5, this.p_Cut_Date);
            pstmt.setTimestamp(6, this.p_Cut_Date);
            pstmt.setTimestamp(7, this.p_Cut_Date);
            pstmt.setTimestamp(8, this.p_Cut_Date);
            pstmt.setTimestamp(9, this.p_Cut_Date);
            pstmt.setTimestamp(10, this.p_Cut_Date);
            pstmt.setTimestamp(11, this.p_Cut_Date);
            pstmt.setTimestamp(12, this.p_Cut_Date);
            pstmt.setTimestamp(13, this.p_Cut_Date);
            pstmt.setTimestamp(14, this.p_Cut_Date);
            pstmt.setTimestamp(15, this.p_Cut_Date);
            pstmt.setTimestamp(16, this.p_Cut_Date);
            pstmt.setTimestamp(17, this.p_Cut_Date);
            pstmt.setTimestamp(18, this.p_Cut_Date);
            pstmt.setTimestamp(19, this.p_Cut_Date);
            pstmt.setInt(20, this.getAD_Client_ID());
            pstmt.setInt(21, this.getAD_Client_ID());
            pstmt.setTimestamp(22, this.p_Cut_Date);
            pstmt.setTimestamp(23, this.p_Cut_Date);
            int rows = pstmt.executeUpdate();
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("inserted rows=" + rows);
            }
        }
        catch (Throwable throwable) {
            DB.close(pstmt);
            pstmt = null;
            throw throwable;
        }
        DB.close(pstmt);
        pstmt = null;
        return "";
    }
}

