/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import org.compiere.model.MShipper;
import org.compiere.model.MShippingProcessor;
import org.compiere.util.DB;

public class MShipperFacade {
    private MShipper m_shipper;
    private MShippingProcessor m_processor;

    public MShipperFacade(MShipper shipper) {
        this.m_shipper = shipper;
        this.m_processor = this.getShippingProcessor();
    }

    public MShipper getMShipper() {
        return this.m_shipper;
    }

    private MShippingProcessor getShippingProcessor() {
        if (this.m_shipper.getM_ShippingProcessor_ID() > 0) {
            return new MShippingProcessor(this.m_shipper.getCtx(), this.m_shipper.getM_ShippingProcessor_ID(), this.m_shipper.get_TrxName());
        }
        return null;
    }

    public String getShippingProcessorClass() {
        return this.m_processor == null ? null : this.m_processor.getShippingProcessorClass();
    }

    public String getConnectionKey() {
        return this.m_processor == null ? null : this.m_processor.getConnectionKey();
    }

    public String getConnectionPassword() {
        return this.m_processor == null ? null : this.m_processor.getConnectionPassword();
    }

    public String getUserID() {
        return this.m_processor == null ? null : this.m_processor.getUserID();
    }

    public String getHostAddress() {
        return this.m_processor == null ? null : this.m_processor.getHostAddress();
    }

    public String getProxyAddress() {
        return this.m_processor == null ? null : this.m_processor.getProxyAddress();
    }

    public int getHostPort() {
        return this.m_processor == null ? null : Integer.valueOf(this.m_processor.getHostPort());
    }

    public String getProxyLogon() {
        return this.m_processor == null ? null : this.m_processor.getProxyLogon();
    }

    public String getProxyPassword() {
        return this.m_processor == null ? null : this.m_processor.getProxyPassword();
    }

    public int getProxyPort() {
        return this.m_processor == null ? null : Integer.valueOf(this.m_processor.getProxyPort());
    }

    public String getServicePath() {
        return this.m_processor == null ? null : this.m_processor.getServicePath();
    }

    public String getShippingServiceCode() {
        return this.m_shipper.getShippingServiceCode();
    }

    public String getShipperAccount(int AD_Org_ID) {
        StringBuilder sql = new StringBuilder();
        sql.append("Select ShipperAccount From C_BP_ShippingAcct ").append("Where C_BPartner_ID = ? ").append(" AND AD_Org_ID In (0, ").append(AD_Org_ID).append(") ").append(" Order By AD_Org_ID Desc ");
        String ac = DB.getSQLValueString(null, sql.toString(), this.m_shipper.getC_BPartner_ID());
        if (ac != null) {
            ac = ac.replaceAll("[-]", "");
            ac = ac.replaceAll(" ", "");
        }
        return ac;
    }

    public String getDutiesShipperAccount(int AD_Org_ID) {
        StringBuilder sql = new StringBuilder();
        sql.append("Select DutiesShipperAccount From C_BP_ShippingAcct ").append("Where C_BPartner_ID = ? ").append(" AND AD_Org_ID In (0, ").append(AD_Org_ID).append(") ").append(" Order By AD_Org_ID Desc ");
        String ac = DB.getSQLValueString(null, sql.toString(), this.m_shipper.getC_BPartner_ID());
        if (ac != null) {
            ac = ac.replaceAll("[-]", "");
            ac = ac.replaceAll(" ", "");
        }
        return ac;
    }

    public String getShipperMeter(int AD_Org_ID) {
        StringBuilder sql = new StringBuilder();
        sql.append("Select ShipperMeter From C_BP_ShippingAcct ").append("Where C_BPartner_ID = ? ").append(" AND AD_Org_ID In (0, ").append(AD_Org_ID).append(") ").append(" Order By AD_Org_ID Desc ");
        return DB.getSQLValueString(null, sql.toString(), this.m_shipper.getC_BPartner_ID());
    }

    public boolean isResidential() {
        return this.m_shipper.isResidential();
    }

    public boolean isSaturdayDelivery() {
        return this.m_shipper.isSaturdayDelivery();
    }

    public boolean isInternational() {
        return this.m_shipper.isInternational();
    }
}

