/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base;

import java.util.logging.Level;
import org.adempiere.base.ITaxProviderFactory;
import org.adempiere.base.equinox.EquinoxExtensionLocator;
import org.adempiere.model.ITaxProvider;
import org.compiere.util.CLogger;

public class DefaultTaxProviderFactory
implements ITaxProviderFactory {
    private static final CLogger s_log = CLogger.getCLogger(DefaultTaxProviderFactory.class);

    @Override
    public ITaxProvider newTaxProviderInstance(String className) {
        ITaxProvider myCalculator = EquinoxExtensionLocator.instance().locate(ITaxProvider.class, className, null).getExtension();
        if (myCalculator == null) {
            try {
                Class<?> ppClass = Class.forName(className);
                if (ppClass != null) {
                    myCalculator = (ITaxProvider)ppClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (Error e1) {
                s_log.log(Level.SEVERE, className + " - Error=" + e1.getMessage());
                return null;
            }
            catch (Exception e2) {
                s_log.log(Level.SEVERE, className, e2);
                return null;
            }
        }
        if (myCalculator == null) {
            s_log.log(Level.SEVERE, "Not found in extension registry and classpath");
            return null;
        }
        return myCalculator;
    }
}

