/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.int2of5;

import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.impl.int2of5.ITF14CanvasLogicHandler;
import org.krysalis.barcode4j.impl.int2of5.ITF14LogicImpl;
import org.krysalis.barcode4j.impl.int2of5.Interleaved2Of5Bean;
import org.krysalis.barcode4j.output.Canvas;
import org.krysalis.barcode4j.output.CanvasProvider;

public class ITF14Bean
extends Interleaved2Of5Bean {
    static final double DEFAULT_MODULE_WIDTH = 1.016;
    static final double DEFAULT_WIDE_FACTORY = 2.5;
    static final double DEFAULT_BAR_HEIGHT = 32.0;
    static final double DEFAULT_BEARER_BAR_WIDTH = 4.8;
    static final boolean DEFAULT_BEARER_BOX = true;
    private double bearerBarWidth;
    private boolean bearerBox;

    public ITF14Bean() {
        this.setModuleWidth(1.016);
        this.setQuietZone(10.0 * this.moduleWidth);
        this.doQuietZone(true);
        this.setWideFactor(2.5);
        this.setBarHeight(32.0);
        this.setBearerBarWidth(4.8);
        this.setBearerBox(true);
        this.setFontSize(3.0 * this.getBarWidth(2));
        this.setDisplayChecksum(true);
    }

    public boolean isBearerBox() {
        return this.bearerBox;
    }

    public void setBearerBox(boolean value) {
        this.bearerBox = value;
    }

    public double getBearerBarWidth() {
        return this.bearerBarWidth;
    }

    public void setBearerBarWidth(double width) {
        this.bearerBarWidth = width;
    }

    public void doQuietZone(boolean value) {
        if (!value) {
            throw new IllegalArgumentException("Quiet zone may not be disabled for ITF-14!");
        }
        super.doQuietZone(value);
    }

    protected void validate() {
        if (this.getQuietZone() < 10.0 * this.getModuleWidth()) {
            throw new IllegalStateException("Quiet zone must be at least 10 times the module width!");
        }
    }

    public void generateBarcode(CanvasProvider canvas, String msg) {
        if (msg == null || msg.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        this.validate();
        ITF14CanvasLogicHandler handler = new ITF14CanvasLogicHandler(this, new Canvas(canvas));
        ITF14LogicImpl impl = new ITF14LogicImpl(this.getChecksumMode(), this.isDisplayChecksum());
        impl.generateBarcodeLogic(handler, msg);
    }

    public BarcodeDimension calcDimensions(String msg) {
        int msgLen = msg.length();
        if (this.getChecksumMode() == ChecksumMode.CP_ADD) {
            ++msgLen;
        }
        if (msgLen % 2 != 0) {
            ++msgLen;
        }
        double charwidth = 2.0 * this.getWideFactor() + 3.0;
        double width = ((double)msgLen * charwidth + 6.0 + this.getWideFactor()) * this.getModuleWidth();
        double qz = this.getQuietZone();
        double vBearerBar = this.isBearerBox() ? this.getBearerBarWidth() : 0.0;
        return new BarcodeDimension(width, this.getHeight(), width + 2.0 * qz + 2.0 * vBearerBar, this.getHeight() + 2.0 * this.getBearerBarWidth(), vBearerBar + this.getQuietZone(), this.getBearerBarWidth());
    }
}

