/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.math.BigDecimal;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.GridTabWrapper;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MProduct;
import org.compiere.model.MUOMConversion;
import org.compiere.util.Env;
import org.eevolution.model.I_PP_Order_BOMLine;
import org.eevolution.model.I_PP_Product_BOM;
import org.eevolution.model.I_PP_Product_BOMLine;

public class CalloutBOM
extends CalloutEngine {
    public String parent(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int M_Product_ID = (Integer)value;
        if (M_Product_ID <= 0) {
            return "";
        }
        I_PP_Product_BOMLine bomLine = GridTabWrapper.create(mTab, I_PP_Product_BOMLine.class);
        I_PP_Product_BOM bom = bomLine.getPP_Product_BOM();
        if (bom.getM_Product_ID() == bomLine.getM_Product_ID()) {
            throw new AdempiereException("@ValidComponent@ - Error Parent not be Component");
        }
        MProduct product = MProduct.get(ctx, M_Product_ID);
        bomLine.setDescription(product.getDescription());
        bomLine.setHelp(product.getHelp());
        bomLine.setC_UOM_ID(product.getC_UOM_ID());
        return "";
    }

    public String qtyLine(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        I_PP_Order_BOMLine bomLine = GridTabWrapper.create(mTab, I_PP_Order_BOMLine.class);
        int M_Product_ID = bomLine.getM_Product_ID();
        String columnName = mField.getColumnName();
        if (M_Product_ID <= 0) {
            BigDecimal QtyEntered = bomLine.getQtyEntered();
            bomLine.setQtyRequiered(QtyEntered);
        } else if ("C_UOM_ID".equals(columnName) || "QtyEntered".equals(columnName)) {
            BigDecimal QtyEntered = bomLine.getQtyEntered();
            BigDecimal QtyRequiered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, bomLine.getC_UOM_ID(), QtyEntered);
            if (QtyRequiered == null) {
                QtyRequiered = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(QtyRequiered) != 0;
            Env.setContext(ctx, WindowNo, "UOMConversion", conversion);
            bomLine.setQtyRequiered(QtyRequiered);
        } else if ("QtyRequiered".equals(columnName)) {
            BigDecimal QtyRequiered = bomLine.getQtyRequiered();
            BigDecimal QtyEntered = MUOMConversion.convertProductTo(ctx, M_Product_ID, bomLine.getC_UOM_ID(), QtyRequiered);
            if (QtyEntered == null) {
                QtyEntered = QtyRequiered;
            }
            boolean conversion = QtyRequiered.compareTo(QtyEntered) != 0;
            Env.setContext(ctx, WindowNo, "UOMConversion", conversion);
            bomLine.setQtyEntered(QtyEntered);
        }
        return "";
    }

    public String getdefaults(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int M_Product_ID = (Integer)value;
        if (M_Product_ID <= 0) {
            return "";
        }
        MProduct product = MProduct.get(ctx, M_Product_ID);
        I_PP_Product_BOM bom = GridTabWrapper.create(mTab, I_PP_Product_BOM.class);
        bom.setValue(product.getValue());
        bom.setName(product.getName());
        bom.setDescription(product.getDescription());
        bom.setHelp(product.getHelp());
        bom.setC_UOM_ID(product.getC_UOM_ID());
        return "";
    }
}

