/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model.credit;

import java.math.BigDecimal;
import org.adempiere.base.CreditStatus;
import org.adempiere.base.ICreditManager;
import org.compiere.model.I_C_Order;
import org.compiere.model.MBPartner;
import org.compiere.model.MInOut;
import org.compiere.model.MSysConfig;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class CreditManagerInOut
implements ICreditManager {
    private MInOut mInOut;

    public CreditManagerInOut(MInOut po) {
        this.mInOut = po;
    }

    @Override
    public CreditStatus checkCreditStatus(String docAction) {
        I_C_Order order;
        String errorMsg = null;
        if ("PR".equals(docAction) && this.mInOut.isSOTrx() && !this.mInOut.isReversal() && !this.mInOut.isCustomerReturn() && ((order = this.mInOut.getC_Order()) == null || !"PR".equals(order.getC_DocType().getDocSubTypeSO()) || MSysConfig.getBooleanValue("CHECK_CREDIT_ON_PREPAY_ORDER", true, this.mInOut.getAD_Client_ID(), this.mInOut.getAD_Org_ID()))) {
            BigDecimal notInvoicedAmt;
            MBPartner bp = new MBPartner(this.mInOut.getCtx(), this.mInOut.getC_BPartner_ID(), this.mInOut.get_TrxName());
            if ("S".equals(bp.getSOCreditStatus())) {
                errorMsg = "@BPartnerCreditStop@ - @TotalOpenBalance@=" + String.valueOf(bp.getTotalOpenBalance()) + ", @SO_CreditLimit@=" + String.valueOf(bp.getSO_CreditLimit());
            }
            if ("H".equals(bp.getSOCreditStatus())) {
                errorMsg = "@BPartnerCreditHold@ - @TotalOpenBalance@=" + String.valueOf(bp.getTotalOpenBalance()) + ", @SO_CreditLimit@=" + String.valueOf(bp.getSO_CreditLimit());
            }
            if (!"X".equals(bp.getSOCreditStatus()) && Env.ZERO.compareTo(bp.getSO_CreditLimit()) != 0 && "H".equals(bp.getSOCreditStatus(notInvoicedAmt = MBPartner.getNotInvoicedAmt(this.mInOut.getC_BPartner_ID())))) {
                errorMsg = "@BPartnerOverSCreditHold@ - @TotalOpenBalance@=" + String.valueOf(bp.getTotalOpenBalance()) + ", @NotInvoicedAmt@=" + String.valueOf(notInvoicedAmt) + ", @SO_CreditLimit@=" + String.valueOf(bp.getSO_CreditLimit());
            }
        }
        return new CreditStatus(errorMsg, !Util.isEmpty(errorMsg));
    }
}

