/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

public class Obscure {
    public static final String OBSCURETYPE_ObscureDigitsButLast4 = "904";
    public static final String OBSCURETYPE_ObscureDigitsButFirstLast4 = "944";
    public static final String OBSCURETYPE_ObscureAlphaNumericButFirstLast4 = "A44";
    public static final String OBSCURETYPE_ObscureAlphaNumericButLast4 = "A04";
    public static final String OBSCURETYPE_ObscureMaskMax10Asterisk = "AA";
    private String m_type = "904";
    private String m_clearValue;
    private String m_obscuredValue;

    public static String obscure(String clearValue) {
        if (clearValue == null || clearValue.length() == 0) {
            return "-";
        }
        Obscure ob = new Obscure(clearValue);
        return ob.getObscuredValue();
    }

    public static String obscure(String clearValue, String obscureType) {
        Obscure ob = new Obscure(clearValue, obscureType);
        return ob.getObscuredValue();
    }

    public Obscure() {
    }

    public Obscure(String clearValue) {
        this.setClearValue(clearValue);
    }

    public Obscure(String clearValue, String obscureType) {
        this.setClearValue(clearValue);
        this.setType(obscureType);
    }

    public void setType(String obscureType) {
        if (obscureType == null || OBSCURETYPE_ObscureDigitsButLast4.equals(obscureType) || OBSCURETYPE_ObscureDigitsButFirstLast4.equals(obscureType) || OBSCURETYPE_ObscureAlphaNumericButFirstLast4.equals(obscureType) || OBSCURETYPE_ObscureAlphaNumericButLast4.equals(obscureType) || OBSCURETYPE_ObscureMaskMax10Asterisk.equals(obscureType)) {
            this.m_type = obscureType;
            this.m_obscuredValue = null;
            return;
        }
        throw new IllegalArgumentException("ObscureType Invalid value - Reference_ID=291 - 904 - 944 - A44 - A04 - AA");
    }

    public String getType() {
        return this.m_type;
    }

    public String getClearValue() {
        return this.m_clearValue;
    }

    public void setClearValue(String clearValue) {
        this.m_clearValue = clearValue;
        this.m_obscuredValue = null;
    }

    public String getObscuredValue(String clearValue, int maxlength) {
        this.setClearValue(clearValue);
        return this.getObscuredValue(maxlength);
    }

    public String getObscuredValue(String clearValue) {
        this.setClearValue(clearValue);
        return this.getObscuredValue();
    }

    public String getObscuredValue(int maxlength) {
        String obs = this.getObscuredValue();
        if (maxlength > 0 && obs.length() > maxlength) {
            obs = obs.substring(0, maxlength);
        }
        return obs;
    }

    public String getObscuredValue() {
        if (this.m_obscuredValue != null) {
            return this.m_obscuredValue;
        }
        if (this.m_clearValue == null || this.m_clearValue.length() == 0) {
            return this.m_clearValue;
        }
        if (OBSCURETYPE_ObscureMaskMax10Asterisk.equals(this.m_type)) {
            return "**********";
        }
        boolean alpha = this.m_type.charAt(0) == 'A';
        int clearStart = Integer.parseInt(this.m_type.substring(1, 2));
        int clearEnd = Integer.parseInt(this.m_type.substring(2));
        char[] chars = this.m_clearValue.toCharArray();
        int length = chars.length;
        StringBuilder sb = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            char c = chars[i];
            if (i < clearStart) {
                sb.append(c);
            } else if (i >= length - clearEnd) {
                sb.append(c);
            } else if (!alpha && !Character.isDigit(c)) {
                sb.append(c);
            } else {
                sb.append('*');
            }
            ++i;
        }
        this.m_obscuredValue = sb.toString();
        return this.m_obscuredValue;
    }

    public static void main(String[] args) {
        System.out.println(Obscure.obscure("1a2b3c4d5e6f7g8h9"));
    }
}

