/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.base.IServiceReferenceHolder;
import org.adempiere.base.Service;
import org.adempiere.base.ServiceQuery;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.IMFAMechanism;
import org.compiere.model.X_MFA_Method;
import org.compiere.util.CCache;

public class MMFAMethod
extends X_MFA_Method {
    private static final long serialVersionUID = -7954271872310037840L;
    private static CCache<ServiceQuery, IServiceReferenceHolder<IMFAMechanism>> s_MFAMechanismReference = new CCache(null, "IMFAMechanism", 3, false);

    public MMFAMethod(Properties ctx, String MFA_Method_UU, String trxName) {
        super(ctx, MFA_Method_UU, trxName);
    }

    public MMFAMethod(Properties ctx, int MFA_Method_ID, String trxName) {
        super(ctx, MFA_Method_ID, trxName);
    }

    public MMFAMethod(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public IMFAMechanism getMFAMechanism() {
        ServiceQuery query = new ServiceQuery();
        String method = this.getMethod();
        if (method == null) {
            throw new AdempiereException("No method");
        }
        query.put("method", method);
        IMFAMechanism mechanism = MMFAMethod.getMFAMechanismService(query);
        if (mechanism == null) {
            throw new AdempiereException("No MFA mechanism provider found");
        }
        return mechanism;
    }

    public static IMFAMechanism getMFAMechanismService(ServiceQuery query) {
        IServiceReferenceHolder<IMFAMechanism> serviceReference;
        IMFAMechanism mechanism = null;
        IServiceReferenceHolder<IMFAMechanism> cache = s_MFAMechanismReference.get(query);
        if (cache != null) {
            mechanism = cache.getService();
            if (mechanism != null) {
                return mechanism;
            }
            s_MFAMechanismReference.remove(query);
        }
        if ((serviceReference = Service.locator().locate(IMFAMechanism.class, query).getServiceReference()) != null && (mechanism = serviceReference.getService()) != null) {
            s_MFAMechanismReference.put(query, serviceReference);
        }
        return mechanism;
    }
}

