/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.Query;
import org.compiere.model.X_C_Currency;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MCurrency
extends X_C_Currency
implements ImmutablePOSupport {
    private static final long serialVersionUID = 4325153934518648373L;
    private static ImmutableIntPOCache<Integer, MCurrency> s_currencies = new ImmutableIntPOCache("C_Currency", 50);
    private static ImmutablePOCache<String, MCurrency> s_currenciesISO = new ImmutablePOCache("C_Currency", "C_CurrencyISO", 50);

    public MCurrency(Properties ctx, String C_Currency_UU, String trxName) {
        super(ctx, C_Currency_UU, trxName);
        if (Util.isEmpty(C_Currency_UU)) {
            this.setInitialDefaults();
        }
    }

    public MCurrency(Properties ctx, int C_Currency_ID, String trxName) {
        super(ctx, C_Currency_ID, trxName);
        if (C_Currency_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setIsEMUMember(false);
        this.setIsEuro(false);
        this.setStdPrecision(2);
        this.setCostingPrecision(4);
    }

    public MCurrency(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCurrency(Properties ctx, String ISO_Code, String Description, String CurSymbol, int StdPrecision, int CostingPrecision, String trxName) {
        super(ctx, 0, trxName);
        this.setISO_Code(ISO_Code);
        this.setDescription(Description);
        this.setCurSymbol(CurSymbol);
        this.setStdPrecision(StdPrecision);
        this.setCostingPrecision(CostingPrecision);
        this.setIsEMUMember(false);
        this.setIsEuro(false);
    }

    public MCurrency(MCurrency copy) {
        this(Env.getCtx(), copy);
    }

    public MCurrency(Properties ctx, MCurrency copy) {
        this(ctx, copy, null);
    }

    public MCurrency(Properties ctx, MCurrency copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public static MCurrency get(String ISOcode) {
        return MCurrency.get(Env.getCtx(), ISOcode);
    }

    public static MCurrency get(Properties ctx, String ISOcode) {
        MCurrency retValue = s_currenciesISO.get(ctx, ISOcode, e -> new MCurrency(ctx, (MCurrency)e));
        if (retValue != null) {
            return retValue;
        }
        Query query = new Query(ctx, "C_Currency", "ISO_Code=?", null);
        query.setParameters(ISOcode);
        retValue = (MCurrency)query.firstOnly();
        if (retValue != null) {
            s_currenciesISO.put(ISOcode, retValue, e -> new MCurrency(Env.getCtx(), (MCurrency)e));
        }
        return retValue;
    }

    public static MCurrency get(int C_Currency_ID) {
        return MCurrency.get(Env.getCtx(), C_Currency_ID);
    }

    public static MCurrency get(Properties ctx, int C_Currency_ID) {
        Integer key = C_Currency_ID;
        MCurrency retValue = s_currencies.get(ctx, key, e -> new MCurrency(ctx, (MCurrency)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MCurrency(ctx, C_Currency_ID, null);
        if (retValue.get_ID() == C_Currency_ID) {
            if (retValue.getAD_Client_ID() == 0) {
                s_currencies.put(key, retValue, e -> new MCurrency(Env.getCtx(), (MCurrency)e));
            }
            return retValue.markImmutable();
        }
        return null;
    }

    public static String getISO_Code(Properties ctx, int C_Currency_ID) {
        StringBuilder contextKey = new StringBuilder("C_Currency_").append(C_Currency_ID);
        String retValue = ctx.getProperty(contextKey.toString());
        if (retValue != null) {
            return retValue;
        }
        MCurrency c = MCurrency.get(ctx, C_Currency_ID);
        retValue = c.getISO_Code();
        ctx.setProperty(contextKey.toString(), retValue);
        return retValue;
    }

    public static int getStdPrecision(Properties ctx, int C_Currency_ID) {
        MCurrency c = MCurrency.get(ctx, C_Currency_ID);
        return c.getStdPrecision();
    }

    @Override
    public String toString() {
        StringBuilder msgreturn = new StringBuilder("MCurrency[").append(this.getC_Currency_ID()).append("-").append(this.getISO_Code()).append("-").append(this.getCurSymbol()).append(",").append(this.getDescription()).append(",Precision=").append(this.getStdPrecision()).append("/").append(this.getCostingPrecision());
        return msgreturn.toString();
    }

    public static int getCostingPrecision(Properties ctx, int C_Currency_ID) {
        MCurrency c = MCurrency.get(ctx, C_Currency_ID);
        return c.getCostingPrecision();
    }

    @Override
    public MCurrency markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

