/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAsset;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.X_A_Asset_Reval;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class MAssetReval
extends X_A_Asset_Reval
implements DocAction {
    private static final long serialVersionUID = -3937514008250840440L;
    private boolean m_justPrepared = false;
    private String m_processMsg = null;

    public MAssetReval(Properties ctx, String A_Asset_Reval_UU, String trxName) {
        super(ctx, A_Asset_Reval_UU, trxName);
        if (Util.isEmpty(A_Asset_Reval_UU)) {
            this.setInitialDefaults();
        }
    }

    public MAssetReval(Properties ctx, int X_A_Asset_Reval_ID, String trxName) {
        super(ctx, X_A_Asset_Reval_ID, trxName);
        if (X_A_Asset_Reval_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setDocStatus("DR");
        this.setDocAction("CO");
        this.setProcessed(false);
    }

    public MAssetReval(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public boolean approveIt() {
        return false;
    }

    @Override
    public boolean closeIt() {
        this.setDocAction("--");
        return true;
    }

    @Override
    public String prepareIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), "GLJ", this.getAD_Org_ID());
        MDepreciationWorkfile assetwk = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType());
        if (!assetwk.isDepreciated(this.getDateAcct())) {
            throw new AdempiereException("Asset is not depreciated at this moment");
        }
        if (assetwk.getA_Asset_Cost().equals(this.getA_Asset_Cost_Change()) && assetwk.getA_Accumulated_Depr().equals(this.getA_Change_Acumulated_Depr())) {
            throw new AdempiereException("Nothing has changed");
        }
        if (assetwk.getA_Asset_Cost().equals(this.getA_Asset_Cost_Change()) && !assetwk.getA_Accumulated_Depr().equals(this.getA_Change_Acumulated_Depr())) {
            throw new AdempiereException("It has changed the cost of Asset");
        }
        if (!assetwk.getA_Asset_Cost().equals(this.getA_Asset_Cost_Change()) && assetwk.getA_Accumulated_Depr().equals(this.getA_Change_Acumulated_Depr())) {
            throw new AdempiereException("It has changed the cumulative depreciation");
        }
        if (!this.isLastDepreciated(this.getDateAcct())) {
            throw new AdempiereException("It can only review the last month processed");
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean isLastDepreciated(Timestamp date) {
        MDepreciationWorkfile assetwk = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType());
        Timestamp lastActionDate = assetwk.getLastActionDate();
        boolean isLastDepr = TimeUtil.getMonthLastDay(date).equals(lastActionDate);
        return isLastDepr;
    }

    @Override
    public String completeIt() {
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDepreciationWorkfile assetwk = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        assetwk.setA_Asset_Cost(this.getA_Asset_Cost_Change());
        assetwk.setA_Accumulated_Depr(this.getA_Change_Acumulated_Depr());
        assetwk.saveEx();
        MAsset asset = MAsset.get(this.getCtx(), this.getA_Asset_ID(), this.get_TrxName());
        asset.setA_Asset_RevalDate(this.getDateDoc());
        asset.saveEx();
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public File createPDF() {
        return null;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return Env.ZERO;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public String getDocumentInfo() {
        return this.getDocumentNo() + "/" + String.valueOf(this.getDateAcct());
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("@DocumentNo@ #").append(this.getDocumentNo());
        return sb.toString();
    }

    @Override
    public boolean invalidateIt() {
        return false;
    }

    @Override
    public boolean processIt(String action) throws Exception {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(action, this.getDocAction());
    }

    @Override
    public boolean reActivateIt() {
        return false;
    }

    @Override
    public boolean rejectIt() {
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        return false;
    }

    @Override
    public boolean reverseCorrectIt() {
        return false;
    }

    @Override
    public boolean unlockIt() {
        return false;
    }

    @Override
    public boolean voidIt() {
        return false;
    }

    @Override
    public String getDocumentNo() {
        return null;
    }
}

