/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.event;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.event.RequestEventHandler;
import org.compiere.util.CLogger;
import org.compiere.util.Ini;
import org.compiere.util.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class RequestPropertyService {
    private static final String REQUESTEVENTHANDLER_PROPERTIES = "requesteventhandler.properties";
    private static final CLogger logger = CLogger.getCLogger(RequestPropertyService.class);

    public void bindConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.readProperties(configurationAdmin);
    }

    public void unbindConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readProperties(ConfigurationAdmin service) {
        File file = new File(Ini.getAdempiereHome(), REQUESTEVENTHANDLER_PROPERTIES);
        if (!file.exists()) return;
        Properties p2 = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            p2.load(is);
            String ignoreRequesTypes = p2.getProperty("ignoreRequestTypes");
            if (!Util.isEmpty(ignoreRequesTypes)) {
                Configuration configuration = service.getConfiguration(RequestEventHandler.class.getName());
                if (configuration.getProperties() == null) {
                    Hashtable<String, String> map = new Hashtable<String, String>();
                    ((Dictionary)map).put("ignoreRequestTypes", ignoreRequesTypes);
                    configuration.update(map);
                } else {
                    String configLocation;
                    Bundle bundle = FrameworkUtil.getBundle(RequestEventHandler.class);
                    String bundleLocation = bundle.getLocation();
                    if (!bundleLocation.equals(configLocation = configuration.getBundleLocation())) {
                        configuration.setBundleLocation(bundleLocation);
                        configuration.update();
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.log(Level.WARNING, "requesteventhandler.properties not found.", e);
            if (is == null) return;
            try {
                is.close();
                return;
            }
            catch (Exception exception) {}
            return;
        }
        catch (IOException e) {
            try {
                logger.log(Level.SEVERE, "Error reading requesteventhandler.properties", e);
                if (is == null) return;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                is.close();
                return;
            }
            catch (Exception exception) {}
            return;
        }
        if (is == null) return;
        try {
            is.close();
            return;
        }
        catch (Exception exception) {}
    }
}

