/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.ds;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.adempiere.base.IServiceHolder;
import org.adempiere.base.IServiceReferenceHolder;
import org.adempiere.base.IServicesHolder;
import org.adempiere.base.ds.DynamicServiceReference;
import org.adempiere.base.ds.ServiceRankingComparator;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class DynamicServiceHolder<T>
implements IServiceHolder<T>,
IServicesHolder<T> {
    private ServiceTracker<T, T> serviceTracker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicServiceHolder(ServiceTracker<T, T> tracker) {
        ServiceTracker<T, T> serviceTracker = this.serviceTracker = tracker;
        synchronized (serviceTracker) {
            if (this.serviceTracker.getTrackingCount() == -1) {
                this.serviceTracker.open();
            }
        }
    }

    @Override
    public T getService() {
        Object service = this.serviceTracker.getService();
        return (T)service;
    }

    @Override
    public List<T> getServices() {
        ArrayList<Object> services = new ArrayList<Object>();
        ServiceReference[] objects = this.serviceTracker.getServiceReferences();
        List<Object> references = new ArrayList();
        if (objects != null && objects.length > 0) {
            references = Arrays.asList(objects);
        }
        if (references.size() > 1) {
            Collections.sort(references, ServiceRankingComparator.INSTANCE);
        }
        for (ServiceReference reference : references) {
            services.add(this.serviceTracker.getService(reference));
        }
        return services;
    }

    @Override
    public IServiceReferenceHolder<T> getServiceReference() {
        ServiceReference v = this.serviceTracker.getServiceReference();
        if (v != null) {
            return new DynamicServiceReference<T>(this.serviceTracker, v);
        }
        return null;
    }

    @Override
    public List<IServiceReferenceHolder<T>> getServiceReferences() {
        ArrayList<IServiceReferenceHolder<T>> services = new ArrayList<IServiceReferenceHolder<T>>();
        ServiceReference[] objects = this.serviceTracker.getServiceReferences();
        List<Object> references = new ArrayList();
        if (objects != null && objects.length > 0) {
            references = Arrays.asList(objects);
        }
        if (references.size() > 1) {
            Collections.sort(references, ServiceRankingComparator.INSTANCE);
        }
        for (ServiceReference reference : references) {
            services.add(new DynamicServiceReference<T>(this.serviceTracker, reference));
        }
        return services;
    }
}

