/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.json.filter;

import com.trekglobal.idempiere.rest.api.json.IDempiereRestException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.Response;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MColumn;
import org.compiere.util.DisplayType;

public class ConvertedQuery {
    private StringBuilder whereClause = new StringBuilder("");
    private List<Object> parameters = new ArrayList<Object>();

    public String getWhereClause() {
        return this.whereClause.toString();
    }

    public void appendWhereClause(String append) {
        this.whereClause.append(append);
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public void addParameter(Object parameter) {
        this.parameters.add(parameter);
    }

    public void addParameter(int pos, Object parameter) {
        this.parameters.add(pos, parameter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addParameter(MColumn column, String parameter) {
        if (column == null) {
            return;
        }
        if (column.isSecure() || column.isEncrypted()) {
            throw new AdempiereException("Cannot query the column: " + column);
        }
        int displayType = column.getAD_Reference_ID();
        try {
            if (DisplayType.isID((int)displayType) && !column.getColumnName().equals("EntityType") && !column.getColumnName().equals("AD_Language")) {
                this.addParameter(Integer.valueOf(parameter));
                return;
            }
            if (displayType == 11 || displayType == 28 && column.getColumnName().endsWith("_ID")) {
                this.addParameter(Integer.valueOf(parameter));
                return;
            }
            if (DisplayType.isNumeric((int)displayType)) {
                this.addParameter(new BigDecimal(parameter));
                return;
            }
            if (DisplayType.isDate((int)displayType)) {
                Date date = null;
                SimpleDateFormat dateTimeFormat = DisplayType.getTimestampFormat_Default();
                SimpleDateFormat dateFormat = DisplayType.getDateFormat_JDBC();
                if (parameter.contains("'")) {
                    parameter = ConvertedQuery.extractFromStringValue(parameter);
                }
                try {
                    date = displayType == 15 ? dateFormat.parse(parameter) : dateTimeFormat.parse(parameter);
                }
                catch (ParseException parseException) {
                    date = dateFormat.parse(parameter);
                }
                this.addParameter(new Timestamp(date.getTime()));
                return;
            }
            if (displayType == 20) {
                this.addParameter("Y".equals(parameter) || "true".equals(parameter));
                return;
            } else if (displayType == 10 || DisplayType.isList((int)displayType) || parameter.startsWith("'") && parameter.endsWith("'")) {
                if (!parameter.startsWith("'") || !parameter.endsWith("'")) throw new IDempiereRestException("String values must be put between single quotes. ColumnName: " + column.getName(), Response.Status.BAD_REQUEST);
                this.addParameter(ConvertedQuery.extractFromStringValue(parameter));
                return;
            } else {
                this.addParameter(parameter);
            }
            return;
        }
        catch (Exception e) {
            throw new IDempiereRestException("Error convertig parameter with value: " + parameter + " - " + e.getMessage(), Response.Status.BAD_REQUEST);
        }
    }

    public static String extractFromStringValue(String value) {
        return value.substring(1, value.length() - 1);
    }
}

