/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.json.IDempiereRestException;
import com.trekglobal.idempiere.rest.api.json.IGridTabSerializer;
import com.trekglobal.idempiere.rest.api.json.IPOSerializer;
import com.trekglobal.idempiere.rest.api.json.Process;
import com.trekglobal.idempiere.rest.api.json.ResponseUtils;
import com.trekglobal.idempiere.rest.api.json.RestUtils;
import com.trekglobal.idempiere.rest.api.json.TypeConverterUtils;
import com.trekglobal.idempiere.rest.api.json.filter.ConvertedQuery;
import com.trekglobal.idempiere.rest.api.json.filter.IQueryConverter;
import com.trekglobal.idempiere.rest.api.util.ErrorBuilder;
import com.trekglobal.idempiere.rest.api.util.GridTabPaging;
import com.trekglobal.idempiere.rest.api.util.Paging;
import com.trekglobal.idempiere.rest.api.v1.resource.WindowResource;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.ws.rs.core.Response;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindow;
import org.compiere.model.MField;
import org.compiere.model.MPInstance;
import org.compiere.model.MProcess;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MTab;
import org.compiere.model.MTable;
import org.compiere.model.MWindow;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.wf.MWorkflow;

public class WindowResourceImpl
implements WindowResource {
    private static final int DEFAULT_PAGE_SIZE = 100;
    private static final CLogger log = CLogger.getCLogger(WindowResourceImpl.class);
    private static final String[] WINDOW_SELECT_COLUMNS = new String[]{"AD_Window_ID", "AD_Window_UU", "Name", "Description", "Help", "WindowType", "EntityType"};
    private static final String[] TAB_SELECT_COLUMNS = new String[]{"AD_Tab_ID", "AD_Tab_UU", "Name", "Description", "Help", "EntityType", "SeqNo", "TabLevel"};
    private static final String[] FIELD_SELECT_COLUMNS = new String[]{"AD_Field_ID", "AD_Field_UU", "Name", "Description", "Help", "EntityType", "AD_Reference_ID", "AD_Column_ID", "MandatoryLogic"};

    @Override
    public Response getWindows(String filter, String details, String select) {
        IQueryConverter converter = IQueryConverter.getQueryConverter("DEFAULT");
        try {
            JsonArray windowArray = new JsonArray();
            ConvertedQuery convertedStatement = converter.convertStatement("AD_Window", filter);
            if (log.isLoggable(Level.INFO)) {
                log.info("Where Clause: " + convertedStatement.getWhereClause());
            }
            Query query = new Query(Env.getCtx(), "AD_Window", convertedStatement.getWhereClause(), null);
            query.setApplyAccessFilter(true).setOnlyActiveRecords(true).setOrderBy("Name");
            query.setParameters(convertedStatement.getParameters());
            List windows = query.list();
            MRole role = MRole.getDefault();
            IPOSerializer serializer = IPOSerializer.getPOSerializer("AD_Window", MTable.getClass((String)"AD_Window"));
            HashMap<String, ArrayList<String>> includes = RestUtils.getIncludes("AD_Window", select, details);
            String[] mainSelect = includes != null && includes.get("AD_Window") != null ? includes.get("AD_Window").toArray(new String[includes.get("AD_Window").size()]) : WINDOW_SELECT_COLUMNS;
            for (MWindow window : windows) {
                if (role.getWindowAccess(window.getAD_Window_ID()) == null) continue;
                JsonObject jsonObject = serializer.toJson((PO)window, mainSelect, null);
                jsonObject.addProperty("slug", TypeConverterUtils.slugify(window.getName()));
                if (!Util.isEmpty((String)details, (boolean)true)) {
                    boolean addTabs = details.contains("AD_Tab");
                    boolean addFields = details.contains("AD_Field");
                    if (addTabs) {
                        jsonObject.add("tabs", (JsonElement)this.getWindowTabs(window, includes, addFields));
                    }
                }
                windowArray.add((JsonElement)jsonObject);
            }
            JsonObject json = new JsonObject();
            json.add("windows", (JsonElement)windowArray);
            return Response.ok((Object)json.toString()).build();
        }
        catch (Exception ex) {
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            if (ex instanceof IDempiereRestException) {
                status = ((IDempiereRestException)((Object)ex)).getErrorResponseStatus();
            }
            log.log(Level.SEVERE, ex.getMessage(), (Throwable)ex);
            return Response.status((Response.Status)status).entity((Object)new ErrorBuilder().status(status).title("GET Error").append("Get windows with exception: ").append(ex.getMessage()).build().toString()).build();
        }
    }

    @Override
    public Response getTabs(String windowSlug) {
        MRole role = MRole.getDefault();
        Query query = new Query(Env.getCtx(), "AD_Window", "slugify(name)=?", null);
        query.setApplyAccessFilter(true).setOnlyActiveRecords(true);
        query.setParameters(new Object[]{windowSlug});
        MWindow window = (MWindow)query.first();
        if (window == null) {
            query.setApplyAccessFilter(false);
            window = (MWindow)query.first();
            if (window != null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for window: ").append(windowSlug).build().toString()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid window name").append("No match found for window name: ").append(windowSlug).build().toString()).build();
        }
        if (role.getWindowAccess(window.getAD_Window_ID()) == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for window: ").append(windowSlug).build().toString()).build();
        }
        IPOSerializer serializer = IPOSerializer.getPOSerializer("AD_Window", MTable.getClass((String)"AD_Window"));
        JsonObject windowJsonObject = serializer.toJson((PO)window, WINDOW_SELECT_COLUMNS, null);
        windowJsonObject.addProperty("slug", TypeConverterUtils.slugify(window.getName()));
        windowJsonObject.add("tabs", (JsonElement)this.getWindowTabs(window, null, false));
        return Response.ok((Object)windowJsonObject.toString()).build();
    }

    private JsonArray getWindowTabs(MWindow window, HashMap<String, ArrayList<String>> includes, boolean includeFields) {
        MTab[] tabs = window.getTabs(false, null);
        JsonArray tabArray = new JsonArray();
        IPOSerializer tabSerializer = IPOSerializer.getPOSerializer("AD_Tab", MTable.getClass((String)"AD_Tab"));
        String[] tabSelect = TAB_SELECT_COLUMNS;
        String[] fieldSelect = FIELD_SELECT_COLUMNS;
        if (includes != null) {
            if (includes.get("AD_Tab") != null) {
                tabSelect = includes.get("AD_Tab").toArray(new String[includes.get("AD_Tab").size()]);
            }
            if (includeFields && includes.get("AD_Field") != null) {
                fieldSelect = includes.get("AD_Field").toArray(new String[includes.get("AD_Field").size()]);
            }
        }
        MTab[] mTabArray = tabs;
        int n = tabs.length;
        int n2 = 0;
        while (n2 < n) {
            MTab tab = mTabArray[n2];
            JsonObject tabJsonObject = tabSerializer.toJson((PO)tab, tabSelect, null);
            tabJsonObject.addProperty("slug", TypeConverterUtils.slugify(tab.getName()));
            if (includeFields) {
                MField[] fields = tab.getFields(false, null);
                JsonArray fieldArray = new JsonArray();
                IPOSerializer serializer = IPOSerializer.getPOSerializer("AD_Field", MTable.getClass((String)"AD_Field"));
                MField[] mFieldArray = fields;
                int n3 = fields.length;
                int n4 = 0;
                while (n4 < n3) {
                    MField field = mFieldArray[n4];
                    if (field.isDisplayed()) {
                        JsonObject jsonObject = serializer.toJson((PO)field, fieldSelect, null);
                        fieldArray.add((JsonElement)jsonObject);
                    }
                    ++n4;
                }
                tabJsonObject.add("fields", (JsonElement)fieldArray);
            }
            tabArray.add((JsonElement)tabJsonObject);
            ++n2;
        }
        return tabArray;
    }

    @Override
    public Response getTabFields(String windowSlug, String tabSlug, String filter) {
        MRole role = MRole.getDefault();
        Query query = new Query(Env.getCtx(), "AD_Window", "slugify(name)=?", null);
        query.setApplyAccessFilter(true).setOnlyActiveRecords(true);
        query.setParameters(new Object[]{windowSlug});
        MWindow window = (MWindow)query.first();
        if (window == null) {
            query.setApplyAccessFilter(false);
            window = (MWindow)query.first();
            if (window != null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for window: ").append(windowSlug).build().toString()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid window name").append("No match found for window name: ").append(windowSlug).build().toString()).build();
        }
        if (role.getWindowAccess(window.getAD_Window_ID()) == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for window: ").append(windowSlug).build().toString()).build();
        }
        MTab[] tabs = window.getTabs(false, null);
        int tabId = 0;
        MTab[] mTabArray = tabs;
        int n = tabs.length;
        int n2 = 0;
        while (n2 < n) {
            MTab tab = mTabArray[n2];
            if (TypeConverterUtils.slugify(tab.getName()).equals(tabSlug)) {
                tabId = tab.getAD_Tab_ID();
                break;
            }
            ++n2;
        }
        if (tabId == 0) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid tab name").append("No match found for tab name: ").append(tabSlug).build().toString()).build();
        }
        IQueryConverter converter = IQueryConverter.getQueryConverter("DEFAULT");
        try {
            StringBuilder whereClause = new StringBuilder("AD_Tab_ID=?");
            ConvertedQuery convertedStatement = converter.convertStatement("AD_Field", filter);
            if (log.isLoggable(Level.INFO)) {
                log.info("Where Clause: " + convertedStatement.getWhereClause());
            }
            if (!Util.isEmpty((String)filter, (boolean)true)) {
                whereClause.append(" AND (").append(convertedStatement.getWhereClause()).append(")");
            }
            query = new Query(Env.getCtx(), "AD_Field", whereClause.toString(), null);
            ArrayList<Object> prmCopy = new ArrayList<Object>(convertedStatement.getParameters());
            prmCopy.add(0, tabId);
            List fields = query.setParameters(prmCopy).list();
            JsonArray fieldArray = new JsonArray();
            IPOSerializer serializer = IPOSerializer.getPOSerializer("AD_Field", MTable.getClass((String)"AD_Field"));
            for (MField field : fields) {
                JsonObject jsonObject = serializer.toJson((PO)field, FIELD_SELECT_COLUMNS, null);
                fieldArray.add((JsonElement)jsonObject);
            }
            JsonObject json = new JsonObject();
            json.add("fields", (JsonElement)fieldArray);
            return Response.ok((Object)json.toString()).build();
        }
        catch (Exception ex) {
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            if (ex instanceof IDempiereRestException) {
                status = ((IDempiereRestException)((Object)ex)).getErrorResponseStatus();
            }
            log.log(Level.SEVERE, ex.getMessage(), (Throwable)ex);
            return Response.status((Response.Status)status).entity((Object)new ErrorBuilder().status(status).title("GET Error").append("Get TabFields with exception: ").append(ex.getMessage()).build().toString()).build();
        }
    }

    @Override
    public Response getWindowRecords(String windowSlug, String filter, String sortColumn, int pageNo) {
        MRole role = MRole.getDefault();
        Query query = new Query(Env.getCtx(), "AD_Window", "slugify(name)=?", null);
        query.setApplyAccessFilter(true).setOnlyActiveRecords(true);
        query.setParameters(new Object[]{windowSlug});
        MWindow window = (MWindow)query.first();
        if (window == null) {
            query.setApplyAccessFilter(false);
            window = (MWindow)query.first();
            if (window != null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for window: ").append(windowSlug).build().toString()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid window name").append("No match found for window name: ").append(windowSlug).build().toString()).build();
        }
        if (role.getWindowAccess(window.getAD_Window_ID()) == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for window: ").append(windowSlug).build().toString()).build();
        }
        GridWindow gridWindow = GridWindow.get((Properties)Env.getCtx(), (int)1, (int)window.getAD_Window_ID());
        int i = 0;
        while (i < gridWindow.getTabCount()) {
            GridTab gridTab = gridWindow.getTab(i);
            if (gridTab.getTabLevel() == 0) {
                QueryResult queryResult = this.query(gridTab, filter, sortColumn, pageNo);
                JsonObject json = new JsonObject();
                json.addProperty("page-count", (Number)queryResult.pageCount);
                json.addProperty("page-size", (Number)queryResult.pageSize);
                json.addProperty("page-number", (Number)queryResult.pageNo);
                json.addProperty("row-count", (Number)queryResult.rowCount);
                json.add("window-records", (JsonElement)queryResult.jsonArray);
                return Response.ok((Object)json.toString()).header("X-Page-Count", (Object)queryResult.pageCount).header("X-Page-Size", (Object)queryResult.pageSize).header("X-Page-Number", (Object)queryResult.pageNo).header("X-Row-Count", (Object)queryResult.rowCount).build();
            }
            ++i;
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid window name").append("No match found for window name: ").append(windowSlug).build().toString()).build();
    }

    @Override
    public Response getWindowRecord(String windowSlug, int recordId, String details) {
        return this.getTabRecord(windowSlug, null, recordId, details);
    }

    @Override
    public Response getChildTabRecords(String windowSlug, String tabSlug, int recordId, String childTabSlug, String filter, String sortColumn, int pageNo) {
        GridTab gridTab;
        MRole role = MRole.getDefault();
        Query query = new Query(Env.getCtx(), "AD_Window", "slugify(name)=?", null);
        query.setApplyAccessFilter(true).setOnlyActiveRecords(true);
        query.setParameters(new Object[]{windowSlug});
        MWindow window = (MWindow)query.first();
        if (window == null) {
            query.setApplyAccessFilter(false);
            window = (MWindow)query.first();
            if (window != null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for window: ").append(windowSlug).build().toString()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid window name").append("No match found for window name: ").append(windowSlug).build().toString()).build();
        }
        if (role.getWindowAccess(window.getAD_Window_ID()) == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for window: ").append(windowSlug).build().toString()).build();
        }
        GridTab parentTab = null;
        GridWindow gridWindow = GridWindow.get((Properties)Env.getCtx(), (int)1, (int)window.getAD_Window_ID());
        int i = 0;
        while (i < gridWindow.getTabCount()) {
            gridTab = gridWindow.getTab(i);
            if (TypeConverterUtils.slugify(gridTab.getName()).equals(tabSlug)) {
                parentTab = gridTab;
                this.load(gridWindow, gridTab, recordId);
                break;
            }
            ++i;
        }
        if (parentTab == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid tab name").append("No match found for tab name: ").append(tabSlug).build().toString()).build();
        }
        if (parentTab.getRowCount() == 0) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Record not found").append("No record found matching id ").append(recordId).build().toString()).build();
        }
        i = 0;
        while (i < gridWindow.getTabCount()) {
            gridTab = gridWindow.getTab(i);
            if (TypeConverterUtils.slugify(gridTab.getName()).equals(childTabSlug)) {
                if (gridTab.getTabLevel() != parentTab.getTabLevel() + 1) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)(String.valueOf(childTabSlug) + " is not child tab of " + tabSlug)).build();
                }
                if (!gridWindow.isTabInitialized(i)) {
                    gridWindow.initTab(i);
                }
                QueryResult queryResult = this.query(gridTab, filter, sortColumn, pageNo);
                JsonObject json = new JsonObject();
                json.addProperty("page-count", (Number)queryResult.pageCount);
                json.addProperty("page-size", (Number)queryResult.pageSize);
                json.addProperty("page-number", (Number)queryResult.pageNo);
                json.addProperty("row-count", (Number)queryResult.rowCount);
                json.add("childtab-records", (JsonElement)queryResult.jsonArray);
                return Response.ok((Object)json.toString()).header("X-Page-Count", (Object)queryResult.pageCount).header("X-Page-Size", (Object)queryResult.pageSize).header("X-Page-Number", (Object)queryResult.pageNo).header("X-Row-Count", (Object)queryResult.rowCount).build();
            }
            ++i;
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid tab name").append("No match found for tab name: ").append(childTabSlug).build().toString()).build();
    }

    @Override
    public Response getTabRecord(String windowSlug, String tabSlug, int recordId, String details) {
        MRole role = MRole.getDefault();
        Query query = new Query(Env.getCtx(), "AD_Window", "slugify(name)=?", null);
        query.setApplyAccessFilter(true).setOnlyActiveRecords(true);
        query.setParameters(new Object[]{windowSlug});
        MWindow window = (MWindow)query.first();
        if (window == null) {
            query.setApplyAccessFilter(false);
            window = (MWindow)query.first();
            if (window != null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for window: ").append(windowSlug).build().toString()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid window name").append("No match found for window name: ").append(windowSlug).build().toString()).build();
        }
        if (role.getWindowAccess(window.getAD_Window_ID()) == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for window: ").append(windowSlug).build().toString()).build();
        }
        JsonObject jsonObject = this.loadTabRecord(window, tabSlug, recordId, details);
        if (jsonObject != null) {
            return Response.ok((Object)jsonObject.toString()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Record not found").append("No record found matching id ").append(recordId).build().toString()).build();
    }

    @Override
    public Response updateWindowRecord(String windowSlug, int recordId, String jsonText) {
        return this.updateTabRecord(windowSlug, null, recordId, jsonText);
    }

    @Override
    public Response createWindowRecord(String windowSlug, String jsonText) {
        MRole role = MRole.getDefault();
        Query query = new Query(Env.getCtx(), "AD_Window", "slugify(name)=?", null);
        query.setApplyAccessFilter(true).setOnlyActiveRecords(true);
        query.setParameters(new Object[]{windowSlug});
        MWindow window = (MWindow)query.first();
        if (window == null) {
            query.setApplyAccessFilter(false);
            window = (MWindow)query.first();
            if (window != null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for window: ").append(windowSlug).build().toString()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid window name").append("No match found for window name: ").append(windowSlug).build().toString()).build();
        }
        Boolean windowAccess = role.getWindowAccess(window.getAD_Window_ID());
        if (windowAccess == null || !windowAccess.booleanValue()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for window: ").append(windowSlug).build().toString()).build();
        }
        Env.setContext((Properties)Env.getCtx(), (int)1, (String)"IsSOTrx", (boolean)window.isSOTrx());
        Gson gson = new GsonBuilder().create();
        JsonObject jsonObject = (JsonObject)gson.fromJson(jsonText, JsonObject.class);
        GridWindow gridWindow = GridWindow.get((Properties)Env.getCtx(), (int)1, (int)window.getAD_Window_ID());
        try (Trx trx = Trx.get((String)Trx.createTrxName(), (boolean)true);){
            trx.start();
            Response response = this.createTabRecord(gridWindow, null, null, jsonObject, trx);
            return response;
        }
    }

    @Override
    public Response deleteWindowRecord(String windowSlug, int recordId) {
        return this.deleteTabRecord(windowSlug, null, recordId);
    }

    @Override
    public Response updateTabRecord(String windowSlug, String tabSlug, int recordId, String jsonText) {
        MRole role = MRole.getDefault();
        Query query = new Query(Env.getCtx(), "AD_Window", "slugify(name)=?", null);
        query.setApplyAccessFilter(true).setOnlyActiveRecords(true);
        query.setParameters(new Object[]{windowSlug});
        MWindow window = (MWindow)query.first();
        if (window == null) {
            query.setApplyAccessFilter(false);
            window = (MWindow)query.first();
            if (window != null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for window: ").append(windowSlug).build().toString()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid window name").append("No match found for window name: ").append(windowSlug).build().toString()).build();
        }
        Boolean windowAccess = role.getWindowAccess(window.getAD_Window_ID());
        if (windowAccess == null || !windowAccess.booleanValue()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for window: ").append(windowSlug).build().toString()).build();
        }
        Env.setContext((Properties)Env.getCtx(), (int)1, (String)"IsSOTrx", (boolean)window.isSOTrx());
        Gson gson = new GsonBuilder().create();
        JsonObject jsonObject = (JsonObject)gson.fromJson(jsonText, JsonObject.class);
        GridWindow gridWindow = GridWindow.get((Properties)Env.getCtx(), (int)1, (int)window.getAD_Window_ID());
        try (Trx trx = Trx.get((String)Trx.createTrxName(), (boolean)true);){
            trx.start();
            Response response = this.updateTabRecord(gridWindow, tabSlug, recordId, jsonObject, trx);
            return response;
        }
    }

    @Override
    public Response createChildTabRecord(String windowSlug, String tabSlug, int recordId, String childTabSlug, String jsonText) {
        MRole role = MRole.getDefault();
        Query query = new Query(Env.getCtx(), "AD_Window", "slugify(name)=?", null);
        query.setApplyAccessFilter(true).setOnlyActiveRecords(true);
        query.setParameters(new Object[]{windowSlug});
        MWindow window = (MWindow)query.first();
        if (window == null) {
            query.setApplyAccessFilter(false);
            window = (MWindow)query.first();
            if (window != null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for window: ").append(windowSlug).build().toString()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid window name").append("No match found for window name: ").append(windowSlug).build().toString()).build();
        }
        Boolean windowAccess = role.getWindowAccess(window.getAD_Window_ID());
        if (windowAccess == null || !windowAccess.booleanValue()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for window: ").append(windowSlug).build().toString()).build();
        }
        Env.setContext((Properties)Env.getCtx(), (int)1, (String)"IsSOTrx", (boolean)window.isSOTrx());
        Gson gson = new GsonBuilder().create();
        JsonObject jsonObject = (JsonObject)gson.fromJson(jsonText, JsonObject.class);
        GridTab parentTab = null;
        GridWindow gridWindow = GridWindow.get((Properties)Env.getCtx(), (int)1, (int)window.getAD_Window_ID());
        int i = 0;
        while (i < gridWindow.getTabCount()) {
            GridTab gridTab = gridWindow.getTab(i);
            if (TypeConverterUtils.slugify(gridTab.getName()).equals(tabSlug)) {
                parentTab = gridTab;
                this.load(gridWindow, gridTab, recordId);
                break;
            }
            ++i;
        }
        if (parentTab == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid tab name").append("No match found for tab name: ").append(tabSlug).build().toString()).build();
        }
        if (parentTab.getRowCount() == 0) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Record not found").append("No record found matching id ").append(recordId).build().toString()).build();
        }
        try (Trx trx = Trx.get((String)Trx.createTrxName(), (boolean)true);){
            trx.start();
            Response response = this.createTabRecord(gridWindow, parentTab, childTabSlug, jsonObject, trx);
            return response;
        }
    }

    @Override
    public Response deleteTabRecord(String windowSlug, String tabSlug, int recordId) {
        MRole role = MRole.getDefault();
        Query query = new Query(Env.getCtx(), "AD_Window", "slugify(name)=?", null);
        query.setApplyAccessFilter(true).setOnlyActiveRecords(true);
        query.setParameters(new Object[]{windowSlug});
        MWindow window = (MWindow)query.first();
        if (window == null) {
            query.setApplyAccessFilter(false);
            window = (MWindow)query.first();
            if (window != null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for window: ").append(windowSlug).build().toString()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid window name").append("No match found for window name: ").append(windowSlug).build().toString()).build();
        }
        Boolean windowAccess = role.getWindowAccess(window.getAD_Window_ID());
        if (windowAccess == null || !windowAccess.booleanValue()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for window: ").append(windowSlug).build().toString()).build();
        }
        GridWindow gridWindow = GridWindow.get((Properties)Env.getCtx(), (int)1, (int)window.getAD_Window_ID());
        int i = 0;
        while (i < gridWindow.getTabCount()) {
            GridTab gridTab = gridWindow.getTab(i);
            if (gridTab.getTabLevel() == 0 && Util.isEmpty((String)tabSlug, (boolean)true) || TypeConverterUtils.slugify(gridTab.getName()).equals(tabSlug)) {
                if (gridTab.isReadOnly() || !gridTab.isDeleteRecord()) {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Delete not allow").append("Delete not allow for tab: ").append(TypeConverterUtils.slugify(gridTab.getName())).build().toString()).build();
                }
                this.load(gridWindow, gridTab, recordId);
                if (gridTab.getRowCount() < 1) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Record not found").append("No record found matching id: ").append(recordId).build().toString()).build();
                }
                if (gridTab.getRowCount() > 1) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("More than 1 match").append("More than 1 matching record for id: ").append(recordId).build().toString()).build();
                }
                ErrorDataStatusListener edsl = new ErrorDataStatusListener();
                gridTab.getTableModel().addDataStatusListener((DataStatusListener)edsl);
                try {
                    if (gridTab.dataDelete()) {
                        Response response = Response.status((Response.Status)Response.Status.OK).build();
                        return response;
                    }
                    String error = edsl.getError();
                    Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorBuilder().status(Response.Status.INTERNAL_SERVER_ERROR).title("Delete error").append(!Util.isEmpty((String)error) ? "Server error with exception: " : "").append(!Util.isEmpty((String)error) ? error : "").build().toString()).build();
                    return response;
                }
                finally {
                    gridTab.getTableModel().removeDataStatusListener((DataStatusListener)edsl);
                }
            }
            ++i;
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid tab name").append("No match found for tab name: ").append(tabSlug).build().toString()).build();
    }

    private QueryResult query(GridTab gridTab, String filter, String sortColumn, int pageNo) {
        IGridTabSerializer serializer = IGridTabSerializer.getGridTabSerializer(gridTab.getAD_Tab_UU());
        if (!Util.isEmpty((String)filter, (boolean)true)) {
            MQuery gridTabQuery = new MQuery(gridTab.getTableName());
            gridTabQuery.addRestriction(filter);
            gridTab.setQuery(gridTabQuery);
            gridTab.query(false);
        } else {
            gridTab.query(false);
        }
        if (!Util.isEmpty((String)sortColumn, (boolean)true)) {
            boolean ascending = true;
            if (sortColumn.startsWith("!")) {
                sortColumn = sortColumn.substring(1);
                ascending = false;
            }
            GridField[] fields = gridTab.getTableModel().getFields();
            int i = 0;
            while (i < fields.length) {
                if (fields[i].getColumnName().equals(sortColumn)) {
                    gridTab.getTableModel().sort(i, ascending);
                    break;
                }
                ++i;
            }
        }
        JsonArray jsonArray = new JsonArray();
        Paging paging = new Paging(gridTab.getRowCount(), 100);
        GridTabPaging gridTabPaging = new GridTabPaging(gridTab, paging);
        if (pageNo > 0) {
            paging.setActivePage(pageNo);
        }
        int pageRowCount = gridTabPaging.getSize();
        int j = 0;
        while (j < pageRowCount) {
            gridTabPaging.setCurrentRow(j);
            JsonObject jsonObject = serializer.toJson(gridTab);
            jsonObject.addProperty("slug", TypeConverterUtils.slugify(gridTab.getName()));
            jsonArray.add((JsonElement)jsonObject);
            ++j;
        }
        QueryResult queryResult = new QueryResult();
        queryResult.jsonArray = jsonArray;
        queryResult.rowCount = gridTab.getRowCount();
        queryResult.pageNo = paging.getActivePage();
        queryResult.pageCount = paging.getPageCount();
        queryResult.pageSize = paging.getPageSize();
        return queryResult;
    }

    private JsonObject loadTabRecord(MWindow window, String tabSlug, int recordId, String details) {
        JsonObject jsonObject = null;
        List<Object> detailList = new ArrayList();
        if (!Util.isEmpty((String)details, (boolean)true)) {
            String[] detailArray = details.split("[,]");
            detailList = Arrays.asList(detailArray);
        }
        GridWindow gridWindow = GridWindow.get((Properties)Env.getCtx(), (int)1, (int)window.getAD_Window_ID());
        GridTab headerTab = null;
        int i = 0;
        while (i < gridWindow.getTabCount()) {
            GridTab gridTab = gridWindow.getTab(i);
            if (gridTab.getTabLevel() == 0 && Util.isEmpty((String)tabSlug, (boolean)true)) {
                if (!gridWindow.isTabInitialized(i)) {
                    gridWindow.initTab(i);
                }
                IGridTabSerializer serializer = this.load(gridWindow, gridTab, recordId);
                if (gridTab.getRowCount() != 1) break;
                jsonObject = serializer.toJson(gridTab);
                headerTab = gridTab;
            } else if (!Util.isEmpty((String)tabSlug, (boolean)true) && headerTab == null) {
                slug = TypeConverterUtils.slugify(gridTab.getName());
                if (slug.equals(tabSlug)) {
                    if (!gridWindow.isTabInitialized(i)) {
                        gridWindow.initTab(i);
                    }
                    IGridTabSerializer serializer = this.load(gridWindow, gridTab, recordId);
                    if (gridTab.getRowCount() != 1) break;
                    jsonObject = serializer.toJson(gridTab);
                    headerTab = gridTab;
                }
            } else if (headerTab != null && gridTab.getTabLevel() == headerTab.getTabLevel() + 1) {
                slug = TypeConverterUtils.slugify(gridTab.getName());
                if (detailList.contains(slug)) {
                    if (!gridWindow.isTabInitialized(i)) {
                        gridWindow.initTab(i);
                    }
                    JsonArray jsonArray = new JsonArray();
                    gridTab.query(false);
                    if (gridTab.getRowCount() > 0) {
                        IGridTabSerializer serializer = IGridTabSerializer.getGridTabSerializer(gridTab.getAD_Tab_UU());
                        int j = 0;
                        while (j < gridTab.getRowCount()) {
                            if (j > 0) {
                                gridTab.setCurrentRow(j);
                            }
                            JsonObject childJsonObject = serializer.toJson(gridTab);
                            jsonArray.add((JsonElement)childJsonObject);
                            ++j;
                        }
                    }
                    jsonObject.add(slug, (JsonElement)jsonArray);
                }
            } else if (headerTab != null && gridTab.getTabLevel() < headerTab.getTabLevel() || headerTab != null && gridTab.getTabLevel() == headerTab.getTabLevel() && headerTab.getTabLevel() > 0) break;
            ++i;
        }
        return jsonObject;
    }

    private IGridTabSerializer load(GridWindow gridWindow, GridTab gridTab, int recordId) {
        IGridTabSerializer serializer = IGridTabSerializer.getGridTabSerializer(gridTab.getAD_Tab_UU());
        if (gridTab.getTabLevel() == 0) {
            MQuery gridTabQuery = new MQuery(gridTab.getTableName());
            gridTabQuery.addRestriction(gridTab.getTableModel().getKeyColumnName(), "=", recordId);
            gridTab.setQuery(gridTabQuery);
            gridTab.query(false);
        } else {
            int index;
            ArrayList<GridTab> parents = new ArrayList<GridTab>();
            GridTab parent = gridTab.getParentTab();
            while (parent != null) {
                parents.add(parent);
                parent = parent.getParentTab();
            }
            ArrayList<Integer> parentIds = new ArrayList<Integer>();
            GridTab currentChild = gridTab;
            int currentChildId = recordId;
            for (GridTab p : parents) {
                index = gridWindow.getTabIndex(currentChild);
                if (!gridWindow.isTabInitialized(index)) {
                    gridWindow.initTab(index);
                }
                String linkColumn = currentChild.getLinkColumnName();
                String keyColumn = currentChild.getTableModel().getKeyColumnName();
                int parentId = DB.getSQLValueEx(null, (String)("SELECT " + linkColumn + " FROM " + currentChild.getTableName() + " WHERE " + keyColumn + "=?"), (Object[])new Object[]{currentChildId});
                parentIds.add(parentId);
                currentChild = p;
                currentChildId = parentId;
            }
            int i = parents.size() - 1;
            while (i >= 0) {
                GridTab p = (GridTab)parents.get(i);
                index = gridWindow.getTabIndex(p);
                if (!gridWindow.isTabInitialized(index)) {
                    gridWindow.initTab(index);
                }
                int id = (Integer)parentIds.get(i);
                MQuery query = new MQuery();
                query.addRestriction(p.getTableModel().getKeyColumnName(), "=", id);
                p.setQuery(query);
                p.query(false);
                --i;
            }
            if (!gridTab.isCurrent()) {
                gridTab.query(false);
            }
            MQuery gridTabQuery = new MQuery(gridTab.getTableName());
            gridTabQuery.addRestriction(gridTab.getTableModel().getKeyColumnName(), "=", recordId);
            gridTab.setQuery(gridTabQuery);
            gridTab.query(false);
        }
        return serializer;
    }

    private Response updateTabRecord(GridWindow gridWindow, String tabSlug, int recordId, JsonObject jsonObject, Trx trx) throws SQLException {
        IGridTabSerializer serializer;
        Response errorResponse = null;
        GridTab headerTab = null;
        LinkedHashMap<String, JsonArray> childMap = new LinkedHashMap<String, JsonArray>();
        int i = 0;
        while (i < gridWindow.getTabCount()) {
            GridTab gridTab = gridWindow.getTab(i);
            if (headerTab == null && (gridTab.getTabLevel() == 0 && Util.isEmpty((String)tabSlug, (boolean)true) || TypeConverterUtils.slugify(gridTab.getName()).equals(tabSlug))) {
                if (gridTab.isReadOnly()) {
                    errorResponse = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Tab is readonly").append("Tab is readonly: ").append(tabSlug).build().toString()).build();
                    break;
                }
                gridTab.getTableModel().setImportingMode(true, trx.getTrxName());
                serializer = this.load(gridWindow, gridTab, recordId);
                if (gridTab.getRowCount() < 1) {
                    errorResponse = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Record not found").append("No record found matching id: ").append(recordId).build().toString()).build();
                    break;
                }
                if (gridTab.getRowCount() > 1) {
                    errorResponse = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("More than 1 match").append("More than 1 matching record for id: ").append(recordId).build().toString()).build();
                    break;
                }
                serializer.fromJson(jsonObject, gridTab);
                if (gridTab.needSave(true, true)) {
                    ErrorDataStatusListener edsl = new ErrorDataStatusListener();
                    gridTab.getTableModel().addDataStatusListener((DataStatusListener)edsl);
                    try {
                        if (!gridTab.dataSave(false)) {
                            String error = edsl.getError();
                            errorResponse = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorBuilder().status(Response.Status.INTERNAL_SERVER_ERROR).title("Save error").append(!Util.isEmpty((String)error) ? "Save error with exception: " : "").append(!Util.isEmpty((String)error) ? error : "").build().toString()).build();
                            break;
                        }
                        gridTab.dataRefresh();
                    }
                    finally {
                        gridTab.getTableModel().removeDataStatusListener((DataStatusListener)edsl);
                    }
                }
                headerTab = gridTab;
            } else if (headerTab != null && gridTab.getTabLevel() == headerTab.getTabLevel() + 1 && !gridTab.isReadOnly()) {
                String slug = TypeConverterUtils.slugify(gridTab.getName());
                JsonElement tabSlugElement = jsonObject.get(slug);
                if (tabSlugElement != null && tabSlugElement.isJsonArray()) {
                    if (!gridWindow.isTabInitialized(i)) {
                        gridWindow.initTab(i);
                    }
                    gridTab.getTableModel().setImportingMode(true, trx.getTrxName());
                    IGridTabSerializer serializer2 = IGridTabSerializer.getGridTabSerializer(gridTab.getAD_Tab_UU());
                    JsonArray childJsonArray = tabSlugElement.getAsJsonArray();
                    JsonArray updatedArray = new JsonArray();
                    Boolean[] error = new Boolean[]{Boolean.FALSE};
                    ErrorDataStatusListener edsl = new ErrorDataStatusListener();
                    gridTab.getTableModel().addDataStatusListener((DataStatusListener)edsl);
                    try {
                        childJsonArray.forEach(e -> {
                            if (e.isJsonObject() && !error[0].booleanValue()) {
                                JsonObject childJsonObject = e.getAsJsonObject();
                                if (!this.optLoad(gridTab, childJsonObject)) {
                                    if (!gridTab.dataNew(false)) {
                                        booleanArray[0] = Boolean.TRUE;
                                        return;
                                    }
                                    gridTab.setValue(gridTab.getLinkColumnName(), (Object)recordId);
                                }
                                serializer2.fromJson(childJsonObject, gridTab);
                                if (gridTab.needSave(true, true)) {
                                    if (!gridTab.dataSave(false)) {
                                        booleanArray[0] = Boolean.TRUE;
                                        return;
                                    }
                                    gridTab.dataRefresh(false);
                                }
                                childJsonObject = serializer2.toJson(gridTab);
                                updatedArray.add((JsonElement)childJsonObject);
                            }
                        });
                    }
                    finally {
                        gridTab.getTableModel().removeDataStatusListener((DataStatusListener)edsl);
                    }
                    if (error[0].booleanValue()) {
                        String saveError = edsl.getError();
                        errorResponse = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorBuilder().status(Response.Status.INTERNAL_SERVER_ERROR).title("Save error").append(!Util.isEmpty((String)saveError) ? "Save error with exception: " : "").append(!Util.isEmpty((String)saveError) ? saveError : "").build().toString()).build();
                        break;
                    }
                    childMap.put(slug, updatedArray);
                }
            } else if (headerTab != null && gridTab.getTabLevel() < headerTab.getTabLevel() || headerTab != null && gridTab.getTabLevel() == headerTab.getTabLevel() && headerTab.getTabLevel() > 0) break;
            ++i;
        }
        if (errorResponse != null) {
            trx.rollback();
            return errorResponse;
        }
        String error = this.runDocAction(headerTab, jsonObject, trx.getTrxName());
        if (!Util.isEmpty((String)error, (boolean)true)) {
            trx.rollback();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorBuilder().status(Response.Status.INTERNAL_SERVER_ERROR).title("Can't perform document action").append("Encounter exception during execution of document action: ").append(error).build().toString()).build();
        }
        trx.commit(true);
        JsonObject updatedJsonObject = null;
        if (headerTab != null) {
            serializer = IGridTabSerializer.getGridTabSerializer(headerTab.getAD_Tab_UU());
            updatedJsonObject = serializer.toJson(headerTab);
            if (childMap.size() > 0) {
                for (String slug : childMap.keySet()) {
                    updatedJsonObject.add(slug, (JsonElement)childMap.get(slug));
                }
            }
        }
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.OK);
        if (updatedJsonObject != null) {
            return responseBuilder.entity((Object)updatedJsonObject.toString()).build();
        }
        return responseBuilder.build();
    }

    private boolean optLoad(GridTab gridTab, JsonObject jsonObject) {
        JsonElement idElement = jsonObject.get("id");
        if (idElement != null && idElement.isJsonPrimitive()) {
            if (!gridTab.isCurrent()) {
                gridTab.query(false);
            }
            MQuery query = new MQuery();
            query.addRestriction(gridTab.getTableModel().getKeyColumnName(), "=", idElement.getAsInt());
            gridTab.setQuery(query);
            gridTab.query(false);
            return gridTab.getRowCount() == 1;
        }
        JsonElement uidElement = jsonObject.get("uid");
        if (uidElement != null && uidElement.isJsonPrimitive()) {
            if (!gridTab.isCurrent()) {
                gridTab.query(false);
            }
            MQuery query = new MQuery();
            String uidColumnName = PO.getUUIDColumnName((String)gridTab.getTableName());
            query.addRestriction(uidColumnName, "=", (Object)uidElement.getAsString());
            gridTab.setQuery(query);
            gridTab.query(false);
            return gridTab.getRowCount() == 1;
        }
        return false;
    }

    private Response createTabRecord(GridWindow gridWindow, GridTab parentTab, String tabSlug, JsonObject jsonObject, Trx trx) throws SQLException {
        String error;
        IGridTabSerializer serializer;
        GridTab headerTab = null;
        LinkedHashMap<String, JsonArray> childMap = new LinkedHashMap<String, JsonArray>();
        int i = 0;
        while (i < gridWindow.getTabCount()) {
            GridTab gridTab = gridWindow.getTab(i);
            if (headerTab == null && (gridTab.getTabLevel() == 0 && Util.isEmpty((String)tabSlug, (boolean)true) || TypeConverterUtils.slugify(gridTab.getName()).equals(tabSlug))) {
                if (gridTab.isReadOnly() || !gridTab.isInsertRecord()) {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Create not allow").append("Create not allow for tab: ").append(TypeConverterUtils.slugify(gridTab.getName())).build().toString()).build();
                }
                if (gridTab.getTabLevel() > 0 && parentTab == null) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorBuilder().status(Response.Status.BAD_REQUEST).title("No parent tab record").append("Can't create child tab record without parent tab record: ").append(tabSlug).build().toString()).build();
                }
                if (gridTab.getTabLevel() > 0 && parentTab != null && gridTab.getTabLevel() != parentTab.getTabLevel() + 1) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorBuilder().status(Response.Status.BAD_REQUEST).title("Wrong parent tab").append(tabSlug).append(" is not child tab of ").append(TypeConverterUtils.slugify(parentTab.getName())).build().toString()).build();
                }
                if (!gridWindow.isTabInitialized(i)) {
                    gridWindow.initTab(i);
                }
                gridTab.getTableModel().setImportingMode(true, trx.getTrxName());
                if (!gridTab.isCurrent()) {
                    if (gridTab.getTabLevel() > 0) {
                        gridTab.query(false);
                    } else {
                        MQuery query = new MQuery("");
                        query.addRestriction("1=2");
                        query.setRecordCount(0);
                        gridTab.setQuery(query);
                        gridTab.query(false);
                    }
                }
                serializer = IGridTabSerializer.getGridTabSerializer(gridTab.getAD_Tab_UU());
                ErrorDataStatusListener edsl = new ErrorDataStatusListener();
                gridTab.getTableModel().addDataStatusListener((DataStatusListener)edsl);
                try {
                    Response response;
                    String error2;
                    if (!gridTab.dataNew(false)) {
                        error2 = edsl.getError();
                        response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorBuilder().status(Response.Status.INTERNAL_SERVER_ERROR).title("Save error").append(!Util.isEmpty((String)error2) ? "Save error with exception: " : "").append(!Util.isEmpty((String)error2) ? error2 : "").build().toString()).build();
                        return response;
                    }
                    serializer.fromJson(jsonObject, gridTab);
                    if (!gridTab.dataSave(false)) {
                        trx.rollback();
                        error2 = edsl.getError();
                        response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorBuilder().status(Response.Status.INTERNAL_SERVER_ERROR).title("Save error").append(!Util.isEmpty((String)error2) ? "Save error with exception: " : "").append(!Util.isEmpty((String)error2) ? error2 : "").build().toString()).build();
                        return response;
                    }
                    gridTab.dataRefresh(false);
                }
                finally {
                    gridTab.removeDataStatusListener((DataStatusListener)edsl);
                }
                headerTab = gridTab;
            } else if (headerTab != null && gridTab.getTabLevel() == headerTab.getTabLevel() + 1 && !gridTab.isReadOnly()) {
                String tSlug = TypeConverterUtils.slugify(gridTab.getName());
                JsonElement tabSlugElement = jsonObject.get(tSlug);
                if (tabSlugElement != null && tabSlugElement.isJsonArray()) {
                    if (!gridWindow.isTabInitialized(i)) {
                        gridWindow.initTab(i);
                    }
                    gridTab.getTableModel().setImportingMode(true, trx.getTrxName());
                    IGridTabSerializer serializer2 = IGridTabSerializer.getGridTabSerializer(gridTab.getAD_Tab_UU());
                    JsonArray childJsonArray = tabSlugElement.getAsJsonArray();
                    JsonArray updatedArray = new JsonArray();
                    Boolean[] error3 = new Boolean[]{Boolean.FALSE};
                    GridTab finalHeaderTab = headerTab;
                    ErrorDataStatusListener edsl = new ErrorDataStatusListener();
                    gridTab.getTableModel().addDataStatusListener((DataStatusListener)edsl);
                    try {
                        childJsonArray.forEach(e -> {
                            if (e.isJsonObject() && !error3[0].booleanValue()) {
                                JsonObject childJsonObject = e.getAsJsonObject();
                                if (!gridTab.isCurrent()) {
                                    gridTab.query(false);
                                }
                                if (!gridTab.dataNew(false)) {
                                    booleanArray[0] = Boolean.TRUE;
                                    return;
                                }
                                gridTab.setValue(gridTab.getLinkColumnName(), (Object)finalHeaderTab.getKeyID(0));
                                serializer2.fromJson(childJsonObject, gridTab);
                                if (!gridTab.dataSave(false)) {
                                    booleanArray[0] = Boolean.TRUE;
                                    return;
                                }
                                gridTab.dataRefresh(false);
                                childJsonObject = serializer2.toJson(gridTab);
                                updatedArray.add((JsonElement)childJsonObject);
                            }
                        });
                        if (error3[0].booleanValue()) {
                            trx.rollback();
                            String msg = edsl.getError();
                            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorBuilder().status(Response.Status.INTERNAL_SERVER_ERROR).title("Save error").append(!Util.isEmpty((String)msg) ? "Save error with exception: " : "").append(!Util.isEmpty((String)msg) ? msg : "").build().toString()).build();
                            return response;
                        }
                        childMap.put(tSlug, updatedArray);
                    }
                    finally {
                        gridTab.removeDataStatusListener((DataStatusListener)edsl);
                    }
                }
            } else if (headerTab != null && gridTab.getTabLevel() < headerTab.getTabLevel() || headerTab != null && gridTab.getTabLevel() == headerTab.getTabLevel() && headerTab.getTabLevel() > 0) break;
            ++i;
        }
        if (!Util.isEmpty((String)(error = this.runDocAction(headerTab, jsonObject, trx.getTrxName())), (boolean)true)) {
            trx.rollback();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorBuilder().status(Response.Status.INTERNAL_SERVER_ERROR).title("Can't perform document action").append("Encounter exception during execution of document action: ").append(error).build().toString()).build();
        }
        trx.commit(true);
        JsonObject updatedJsonObject = null;
        if (headerTab != null) {
            serializer = IGridTabSerializer.getGridTabSerializer(headerTab.getAD_Tab_UU());
            updatedJsonObject = serializer.toJson(headerTab);
            if (childMap.size() > 0) {
                for (String slug : childMap.keySet()) {
                    updatedJsonObject.add(slug, (JsonElement)childMap.get(slug));
                }
            }
        }
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.CREATED);
        if (updatedJsonObject != null) {
            return responseBuilder.entity((Object)updatedJsonObject.toString()).build();
        }
        return responseBuilder.build();
    }

    private String runDocAction(GridTab gridTab, JsonObject jsonObject, String trxName) {
        JsonElement docActionElement;
        if (gridTab == null) {
            return null;
        }
        PO po = gridTab.getTableModel().getPO(gridTab.getCurrentRow());
        if (po instanceof DocAction && (docActionElement = jsonObject.get("doc-action")) != null) {
            JsonObject docActionJsonObject;
            String docAction = null;
            if (docActionElement.isJsonPrimitive()) {
                docAction = docActionElement.getAsString();
            } else if (docActionElement.isJsonObject() && (docActionElement = (docActionJsonObject = docActionElement.getAsJsonObject()).get("id")) != null && docActionElement.isJsonPrimitive()) {
                docAction = docActionElement.getAsString();
            }
            if (!Util.isEmpty((String)docAction, (boolean)true) && !"--".equals(docAction)) {
                po.set_TrxName(trxName);
                ProcessInfo processInfo = MWorkflow.runDocumentActionWorkflow((PO)po, (String)docAction);
                if (processInfo.isError()) {
                    return processInfo.getSummary();
                }
                try {
                    po.saveEx();
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, ex.getMessage(), (Throwable)ex);
                    return ex.getMessage();
                }
                gridTab.dataRefresh();
            }
        }
        return null;
    }

    @Override
    public Response printWindowRecord(String windowSlug, int recordId, String reportType) {
        return this.printTabRecord(windowSlug, null, recordId, reportType);
    }

    @Override
    public Response printTabRecord(String windowSlug, String tabSlug, int recordId, String reportType) {
        MRole role = MRole.getDefault();
        Query query = new Query(Env.getCtx(), "AD_Window", "slugify(name)=?", null);
        query.setApplyAccessFilter(true).setOnlyActiveRecords(true);
        query.setParameters(new Object[]{windowSlug});
        MWindow window = (MWindow)query.first();
        if (window == null) {
            query.setApplyAccessFilter(false);
            window = (MWindow)query.first();
            if (window != null) {
                return ResponseUtils.getResponseError(Response.Status.FORBIDDEN, "Access denied", "Access denied for window: ", windowSlug);
            }
            return ResponseUtils.getResponseError(Response.Status.NOT_FOUND, "Invalid window name", "No match found for window name: ", windowSlug);
        }
        if (role.getWindowAccess(window.getAD_Window_ID()) == null) {
            return ResponseUtils.getResponseError(Response.Status.FORBIDDEN, "Access denied", "Access denied for window: ", windowSlug);
        }
        GridWindow gridWindow = GridWindow.get((Properties)Env.getCtx(), (int)1, (int)window.getAD_Window_ID());
        GridTab headerTab = null;
        int i = 0;
        while (i < gridWindow.getTabCount()) {
            String slug;
            GridTab gridTab = gridWindow.getTab(i);
            if (gridTab.getTabLevel() == 0 && Util.isEmpty((String)tabSlug, (boolean)true)) {
                headerTab = gridTab;
                break;
            }
            if (!Util.isEmpty((String)tabSlug, (boolean)true) && (slug = TypeConverterUtils.slugify(gridTab.getName())).equals(tabSlug)) {
                headerTab = gridTab;
                break;
            }
            ++i;
        }
        if (headerTab == null) {
            return ResponseUtils.getResponseError(Response.Status.NOT_FOUND, "Invalid tab name", "No match found for tab name: ", tabSlug);
        }
        int AD_Process_ID = headerTab.getAD_Process_ID();
        if (AD_Process_ID == 0) {
            return ResponseUtils.getResponseError(Response.Status.NOT_FOUND, "No print process", "No print process have been defined for ", tabSlug == null ? "window" : "tab");
        }
        JsonObject jsonObject = this.loadTabRecord(window, tabSlug, recordId, null);
        if (jsonObject == null) {
            return ResponseUtils.getResponseError(Response.Status.NOT_FOUND, "Record not found", "No record found matching id ", String.valueOf(recordId));
        }
        MProcess process = MProcess.get((Properties)Env.getCtx(), (int)AD_Process_ID);
        MPInstance pinstance = Process.createPInstance(process, new JsonObject(), false);
        JsonObject processConfig = new JsonObject();
        processConfig.addProperty("record-id", (Number)recordId);
        processConfig.addProperty("table-id", (Number)headerTab.getAD_Table_ID());
        if (!Util.isEmpty((String)reportType, (boolean)true)) {
            processConfig.addProperty("report-type", reportType);
        }
        ProcessInfo processInfo = Process.createProcessInfo(process, pinstance, processConfig);
        ServerProcessCtl.process((ProcessInfo)processInfo, null);
        JsonObject processInfoJson = Process.toJsonObject(processInfo, TypeConverterUtils.slugify(process.getValue()));
        return Response.ok((Object)processInfoJson.toString()).build();
    }

    private class ErrorDataStatusListener
    implements DataStatusListener {
        private String error = null;

        private ErrorDataStatusListener() {
        }

        public void dataStatusChanged(DataStatusEvent e) {
            String msg;
            if (e.isError() && !Util.isEmpty((String)(msg = e.getAD_Message()), (boolean)true)) {
                this.error = Msg.getMsg((Properties)Env.getCtx(), (String)msg);
            }
        }

        public String getError() {
            return this.error;
        }
    }

    private class QueryResult {
        JsonArray jsonArray;
        int rowCount;
        int pageNo;
        int pageCount;
        int pageSize;

        private QueryResult() {
        }
    }
}

