/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.util;

import com.trekglobal.idempiere.rest.api.util.Paging;
import org.compiere.model.GridTab;

public class GridTabPaging {
    private Paging paging;
    private GridTab gridTab;

    public GridTabPaging(GridTab gridTab, Paging paging) {
        this.gridTab = gridTab;
        this.paging = paging;
    }

    public int getSize() {
        int total = this.gridTab.getRowCount();
        if (this.paging.getPageSize() <= 0) {
            return total;
        }
        if (total - this.paging.getActivePage() * this.paging.getPageSize() < 0) {
            this.paging.setActivePage(0);
            return this.paging.getPageSize() > total ? total : this.paging.getPageSize();
        }
        int end = (this.paging.getActivePage() + 1) * this.paging.getPageSize();
        if (end > total) {
            return total - this.paging.getActivePage() * this.paging.getPageSize();
        }
        return this.paging.getPageSize();
    }

    public boolean setCurrentRow(int rowIndex) {
        if (this.paging.getPageSize() > 0) {
            rowIndex = this.paging.getActivePage() * this.paging.getPageSize() + rowIndex;
        }
        if (rowIndex < this.gridTab.getRowCount()) {
            this.gridTab.setCurrentRow(rowIndex);
            return true;
        }
        return false;
    }
}

