/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringReader;
import java.util.logging.Level;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.compiere.util.CLogger;

public class HTMLRenderer
extends View
implements Externalizable {
    private static final long serialVersionUID = 7180048200607805705L;
    private static CLogger log = CLogger.getCLogger(HTMLRenderer.class);
    private int m_width;
    private View m_view;
    private ViewFactory m_factory;
    private Container m_container;
    private Element m_element;
    private Rectangle m_allocation;
    private float m_viewWidth;
    private float m_viewHeight;

    public static HTMLRenderer get(String html2) {
        HTMLEditorKit kit = new HTMLEditorKit();
        HTMLDocument doc = (HTMLDocument)kit.createDefaultDocument();
        try {
            doc.remove(0, doc.getLength());
            StringReader r = new StringReader(html2);
            kit.read(r, (Document)doc, 0);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
        Element element = doc.getDefaultRootElement();
        ViewFactory factory = kit.getViewFactory();
        View view = factory.create(element);
        HTMLRenderer renderer = new HTMLRenderer(factory, view);
        renderer.preferenceChanged(null, true, true);
        return renderer;
    }

    public HTMLRenderer() {
        super(null);
    }

    public HTMLRenderer(ViewFactory f, View v) {
        block2: {
            super(null);
            this.m_factory = f;
            this.m_view = v;
            this.m_view.setParent(this);
            this.m_container = new Container();
            this.m_element = this.m_view.getElement();
            try {
                this.setSize(this.m_view.getPreferredSpan(0), this.m_view.getPreferredSpan(1));
            }
            catch (IllegalComponentStateException e) {
                if (!log.isLoggable(Level.INFO)) break block2;
                log.info("Exception ignored: " + e.toString() + " " + e.getLocalizedMessage());
            }
        }
    }

    public float getWidth() {
        return this.getPreferredSpan(0);
    }

    public float getHeight() {
        return this.getPreferredSpan(1);
    }

    public float getHeightOneLine() {
        return 30.0f;
    }

    public void setAllocation(int width, int height) {
        this.setAllocation(new Rectangle(width, height));
    }

    public void setAllocation(Rectangle allocation) {
        this.m_allocation = allocation;
    }

    public Rectangle getAllocation() {
        if (this.m_allocation == null) {
            return new Rectangle((int)this.getWidth(), (int)this.getHeight());
        }
        return this.m_allocation;
    }

    @Override
    public AttributeSet getAttributes() {
        return null;
    }

    @Override
    public float getPreferredSpan(int axis) {
        if (axis == 0) {
            return this.m_width;
        }
        return this.m_view.getPreferredSpan(axis);
    }

    @Override
    public float getMinimumSpan(int axis) {
        return this.m_view.getMinimumSpan(axis);
    }

    @Override
    public float getMaximumSpan(int axis) {
        return 2.1474836E9f;
    }

    @Override
    public float getAlignment(int axis) {
        return this.m_view.getAlignment(axis);
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        Rectangle alloc = allocation.getBounds();
        this.m_view.setSize(alloc.width, alloc.height);
        Shape oldClip = g.getClip();
        g.setClip(alloc);
        this.m_view.paint(g, allocation);
        g.setClip(oldClip);
    }

    @Override
    public void setParent(View parent) {
        throw new Error("Can't set parent on root view");
    }

    @Override
    public int getViewCount() {
        return 1;
    }

    @Override
    public View getView(int n) {
        return this.m_view;
    }

    @Override
    public Shape modelToView(int pos, Shape a2, Position.Bias b2) throws BadLocationException {
        return this.m_view.modelToView(pos, a2, b2);
    }

    @Override
    public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a2) throws BadLocationException {
        return this.m_view.modelToView(p0, b0, p1, b1, a2);
    }

    @Override
    public int viewToModel(float x, float y, Shape a2, Position.Bias[] bias) {
        return this.m_view.viewToModel(x, y, a2, bias);
    }

    @Override
    public Document getDocument() {
        return this.m_view.getDocument();
    }

    @Override
    public int getStartOffset() {
        return this.m_view.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        return this.m_view.getEndOffset();
    }

    @Override
    public Element getElement() {
        return this.m_view.getElement();
    }

    @Override
    public void setSize(float width, float height) {
        this.m_width = (int)width;
        this.m_viewWidth = width;
        this.m_viewHeight = height;
        this.m_view.setSize(width, height);
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.m_factory;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.m_element);
        out.writeObject(this.m_allocation);
        out.writeFloat(this.m_viewWidth);
        out.writeFloat(this.m_viewHeight);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_element = (Element)in.readObject();
        this.m_allocation = (Rectangle)in.readObject();
        HTMLEditorKit kit = new HTMLEditorKit();
        this.m_factory = kit.getViewFactory();
        this.m_view = this.m_factory.create(this.m_element);
        this.m_view.setParent(this);
        float width = in.readFloat();
        float height = in.readFloat();
        this.setSize(width, height);
    }

    @Override
    public Container getContainer() {
        return this.m_container;
    }
}

