/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.compiere.util.AmtInWords;
import org.compiere.util.Env;

public class AmtInWords_PT
implements AmtInWords {
    private static final String[] centsNames = new String[]{"", "", "", " D\u00e9cimo de", " Cent\u00e9simo de", " Mil\u00e9simo de", " Milion\u00e9simo de", " Bilion\u00e9simo de", " Trilion\u00e9simo de"};
    private static final String[] centsNamesPlural = new String[]{"", "", "", " D\u00e9cimos de", " Cent\u00e9simos de", " Mil\u00e9simos de", " Milion\u00e9simos de", " Bilion\u00e9simos de", " Trilion\u00e9simos de"};
    private static final String[] majorNames = new String[]{"", " Mil", " Milh\u00e3o", " Bilh\u00e3o", " Trilh\u00e3o", " Quatrilh\u00e3o", " Quinquilh\u00e3o"};
    private static final String[] majorNamesPlural = new String[]{"", " Mil", " Milh\u00f5es", " Bilh\u00f5es", " Trilh\u00f5es", " Quatrilh\u00f5es", " Quinquilh\u00f5es"};
    private static final String[] tensNames = new String[]{"", " Dez", " Vinte", " Trinta", " Quarenta", " Cinq\u00fcenta", " Sessenta", " Setenta", " Oitenta", " Noventa"};
    private static final String[] numNames = new String[]{"", " Um", " Dois", " Tr\u00eas", " Quatro", " Cinco", " Seis", " Sete", " Oito", " Nove", " Dez", " Onze", " Doze", " Treze", " Quatorze", " Quinze", " Dezesseis", " Dezessete", " Dezoito", " Dezenove"};

    private String convertLessThanOneThousand(int number) {
        Object soFar;
        if (number % 100 < 20) {
            soFar = numNames[number % 100];
            number /= 100;
        } else {
            soFar = numNames[number % 10];
            String s = Double.toString(number /= 10);
            soFar = s.endsWith("2") && !((String)soFar).equals("") ? " Vinte e " + ((String)soFar).trim() : (((String)soFar).equals("") ? tensNames[number % 10] + (String)soFar : tensNames[number % 10] + " e" + (String)soFar);
            number /= 10;
        }
        if (number == 0) {
            return tensNames[number % 10] + (String)soFar;
        }
        if (number > 1) {
            soFar = "s e" + (String)soFar;
        }
        if (number == 1 && !((String)soFar).equals("")) {
            number = 0;
        }
        soFar = " e" + (String)soFar;
        return numNames[number] + " Cento" + (String)soFar;
    }

    private String convert(BigDecimal number) {
        if (number.compareTo(Env.ZERO) == 0) {
            return "";
        }
        if (number.compareTo(Env.ONE) == 0) {
            return "Um";
        }
        if (number.compareTo(Env.ONE.negate()) == 0) {
            return "Menos Um";
        }
        String prefix = "";
        if (number.compareTo(Env.ZERO) == -1) {
            number = number.negate();
            prefix = "Menos";
        }
        Object soFar = "";
        int place = 0;
        do {
            int n;
            if ((n = number.divideAndRemainder(new BigDecimal(1000))[1].intValue()) != 0) {
                String s = this.convertLessThanOneThousand(n);
                if (s.startsWith("Um Cento e", 1)) {
                    s = s.replaceFirst("Um Cento e", "Cem");
                }
                if (s.startsWith("Dois Cento es", 1)) {
                    s = s.replaceFirst("Dois Cento es", "Duzentos");
                }
                if (s.startsWith("Tr\u00eas Cento es", 1)) {
                    s = s.replaceFirst("Tr\u00eas Cento es", "Trezentos");
                }
                if (s.startsWith("Quatro Cento es", 1)) {
                    s = s.replaceFirst("Quatro Cento es", "Quatrocentos");
                }
                if (s.startsWith("Cinco Cento es", 1)) {
                    s = s.replaceFirst("Cinco Cento es", "Quinhentos");
                }
                if (s.startsWith("Seis Cento es", 1)) {
                    s = s.replaceFirst("Seis Cento es", "Seiscentos");
                }
                if (s.startsWith("Sete Cento es", 1)) {
                    s = s.replaceFirst("Sete Cento es", "Setecentos");
                }
                if (s.startsWith("Oito Cento es", 1)) {
                    s = s.replaceFirst("Oito Cento es", "Oitocentos");
                }
                if (s.startsWith("Nove Cento es", 1)) {
                    s = s.replaceFirst("Nove Cento es", "Novecentos");
                }
                soFar = s.equals(" Um") ? s + majorNames[place] + (String)(((String)soFar).equals("") ? "" : " e" + (String)soFar) : (n > 1 ? s + majorNamesPlural[place] + (String)(((String)soFar).equals("") ? "" : " e" + (String)soFar) : s + majorNames[place] + (String)(((String)soFar).equals("") ? "" : " e" + (String)soFar));
            }
            ++place;
        } while ((number = number.divideAndRemainder(new BigDecimal(1000))[0]).compareTo(Env.ZERO) == 1);
        return (prefix + (String)soFar).replaceAll(" e Mil", " Mil").trim();
    }

    public String getAmtInWords(BigDecimal amount) throws Exception {
        amount = amount.setScale(2, RoundingMode.HALF_UP);
        String samount = amount.toString();
        samount = samount.replaceAll("\\.", ",");
        return this.getAmtInWords(samount);
    }

    @Override
    public String getAmtInWords(String amount) throws Exception {
        String result;
        if (amount == null) {
            return amount;
        }
        StringBuilder sb = new StringBuilder();
        int pos = amount.lastIndexOf(46);
        int pos2 = amount.lastIndexOf(44);
        if (pos2 > pos) {
            pos = pos2;
        }
        String oldamt = amount;
        amount = amount.replaceAll("\\.", "").replaceAll(",", ".");
        String vlr = amount.replaceAll(",", ".");
        int newpos = amount.lastIndexOf(46);
        if (newpos == -1) {
            newpos = amount.length();
        }
        BigDecimal reais = new BigDecimal(amount.substring(0, newpos));
        double valor = Double.parseDouble(vlr);
        sb.append(this.convert(reais));
        int i2 = 0;
        while (i2 < oldamt.length()) {
            if (pos == i2) {
                String cents = oldamt.substring(i2 + 1);
                do {
                    if (!cents.endsWith("0") || cents.length() <= 2) continue;
                    cents = cents.substring(0, cents.length() - 1);
                } while (cents.endsWith("0") && cents.length() > 2);
                if (valor > 0.0 && valor < 1.0) {
                    if (Integer.parseInt(cents) > 0) {
                        if (Integer.parseInt(cents) > 1) {
                            sb.append(this.convert(new BigDecimal(cents))).append(" Centavos");
                        } else {
                            sb.append(this.convert(new BigDecimal(cents))).append(" Centavo");
                        }
                    }
                } else if (valor > 1.0 && valor < 2.0 || valor > -2.0 && valor < -1.0) {
                    if (Integer.parseInt(cents) > 0) {
                        if (Integer.parseInt(cents) > 1) {
                            sb.append(' ').append("Real e ").append(this.convert(new BigDecimal(cents))).append(" Centavos");
                            break;
                        }
                        sb.append(' ').append("Real e ").append(this.convert(new BigDecimal(cents))).append(" Centavo");
                        break;
                    }
                } else if (valor > -1.0 && valor < 0.0) {
                    if (Integer.parseInt(cents) > 0) {
                        if (Integer.parseInt(cents) > 1) {
                            sb.append("Menos ").append(this.convert(new BigDecimal(cents))).append(centsNamesPlural[cents.length()]).append(centsNamesPlural[cents.length()].equals("") ? " Centavos" : " Centavo");
                            break;
                        }
                        sb.append("Menos ").append(this.convert(new BigDecimal(cents))).append(centsNames[cents.length()]).append(" Centavo");
                        break;
                    }
                } else {
                    if (!cents.equals("") && Integer.parseInt(cents) > 0) {
                        if (Integer.parseInt(cents) > 1) {
                            sb.append(' ').append("Reais e ").append(this.convert(new BigDecimal(cents))).append(centsNamesPlural[cents.length()]).append(centsNamesPlural[cents.length()].equals("") ? " Centavos" : " Centavo");
                            break;
                        }
                        sb.append(' ').append("Reais e ").append(this.convert(new BigDecimal(cents))).append(centsNames[cents.length()]).append(" Centavo");
                        break;
                    }
                    if (reais.abs().compareTo(Env.ONE) == 0) {
                        sb.append(" Real");
                    } else {
                        sb.append(" Reais");
                    }
                }
            }
            ++i2;
        }
        if (pos == -1) {
            if (reais.abs().compareTo(Env.ONE) == 0) {
                sb.append(" Real");
            } else {
                sb.append(" Reais");
            }
        }
        if ((result = sb.toString().replaceAll(" e Quinquilh", " Quinquilh").replaceAll(" e Quatrilh", " Quatrilh").replaceAll(" e Trilh", " Trilh").replaceAll(" e Bilh", " Bilh").replaceAll(" e Milh", " Milh").replaceAll("\u00f5es Reais", "\u00f5es de Reais").replaceAll("\u00e3o Reais", "\u00e3o de Reais").replaceAll(" e Reais", " Reais").replaceAll(", de", " de")).indexOf("Quinquilh") > 0 && result.indexOf("Quatrilh") > 0 && result.indexOf("Quatrilh\u00f5es de Rea") == -1 && result.indexOf("Quatrilh\u00e3o de Rea") == -1) {
            result = result.replaceAll("Quinquilh\u00f5es e", "Quinquilh\u00f5es,").replaceAll("Quinquilh\u00e3o e", "Quinquilh\u00e3o,");
        }
        if (result.indexOf("Quatrilh") > 0 && result.indexOf("Trilh") > 0 && result.indexOf("Trilh\u00f5es de Rea") == -1 && result.indexOf("Trilh\u00e3o de Rea") == -1) {
            result = result.replaceAll("Quatrilh\u00f5es e", "Quatrilh\u00f5es,").replaceAll("Quatrilh\u00e3o e", "Quatrilh\u00e3o,");
        }
        if (result.indexOf("Trilh") > 0 && result.indexOf("Bilh") > 0 && result.indexOf("Bilh\u00f5es de Rea") == -1 && result.indexOf("Bilh\u00e3o de Rea") == -1) {
            result = result.replaceAll("Trilh\u00f5es e", "Trilh\u00f5es,").replaceAll("Trilh\u00e3o e", "Trilh\u00e3o,");
        }
        if (result.indexOf("Bilh") > 0 && result.indexOf("Milh") > 0 && result.indexOf("Milh\u00f5es de Rea") == -1 && result.indexOf("Milh\u00e3o de Rea") == -1) {
            result = result.replaceAll("Bilh\u00f5es e", "Bilh\u00f5es,").replaceAll("Bilh\u00e3o e", "Bilh\u00e3o,");
        }
        if (result.indexOf("Milh") > 0 && result.indexOf(" de Rea") == -1 && result.indexOf("Mil e") > 0) {
            result = result.replaceAll("Milh\u00f5es e", "Milh\u00f5es,").replaceAll("Milh\u00e3o e", "Milh\u00e3o,");
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        AmtInWords_PT aiw = new AmtInWords_PT();
        System.out.println(aiw.getAmtInWords("42"));
        System.out.println(aiw.getAmtInWords("0,42"));
        System.out.println(aiw.getAmtInWords("100"));
        System.out.println(aiw.getAmtInWords("100,00"));
        System.out.println(aiw.getAmtInWords("1003,00"));
        System.out.println(aiw.getAmtInWords("5715,13"));
        System.out.println(aiw.getAmtInWords("5715,11"));
        System.out.println(aiw.getAmtInWords("5715,20"));
        System.out.println(aiw.getAmtInWords("5715,30"));
        System.out.println(aiw.getAmtInWords("5715,44"));
        System.out.println(aiw.getAmtInWords("5715,55"));
        System.out.println(aiw.getAmtInWords("5715,60"));
        System.out.println(aiw.getAmtInWords("5715,79"));
        System.out.println(aiw.getAmtInWords("5715,82"));
        System.out.println(aiw.getAmtInWords("5715,90"));
        System.out.println(aiw.getAmtInWords(new BigDecimal(51.34)));
    }
}

