/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.MChangeLog;
import org.compiere.model.MRole;
import org.compiere.model.X_AD_Session;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.compiere.util.WebUtil;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MSession
extends X_AD_Session
implements ImmutablePOSupport {
    private static final long serialVersionUID = -5836154187760734691L;
    private static ImmutableIntPOCache<Integer, MSession> s_sessions = new ImmutableIntPOCache<Integer, MSession>("AD_Session", "AD_Session", 100, 0, false, 0){
        private static final long serialVersionUID = 8421415709907257867L;

        @Override
        public int reset() {
            return 0;
        }

        @Override
        public int reset(int recordId) {
            return 0;
        }
    };
    private boolean m_webStoreSession = false;

    @Deprecated
    public static MSession get(Properties ctx, boolean createNew) {
        MSession session = MSession.get(ctx);
        if (session == null && createNew) {
            return MSession.create(ctx);
        }
        return session;
    }

    public static MSession get(Properties ctx) {
        int AD_Session_ID = Env.getContextAsInt(ctx, "#AD_Session_ID");
        MSession session = s_sessions.get(ctx, AD_Session_ID, e -> new MSession(ctx, (MSession)e));
        if (session == null && AD_Session_ID > 0) {
            session = new MSession(ctx, AD_Session_ID, null);
            if (session.get_ID() == AD_Session_ID) {
                s_sessions.put(AD_Session_ID, session, e -> new MSession(Env.getCtx(), (MSession)e));
            } else {
                session = null;
            }
        }
        return session;
    }

    public static MSession create(Properties ctx) {
        MSession session = new MSession(ctx, null);
        session.saveEx();
        int AD_Session_ID = session.getAD_Session_ID();
        Env.setContext(ctx, "#AD_Session_ID", AD_Session_ID);
        return session;
    }

    public static MSession get(Properties ctx, String Remote_Addr, String Remote_Host, String WebSession) {
        int AD_Session_ID = Env.getContextAsInt(ctx, "#AD_Session_ID");
        MSession session = MSession.get(ctx);
        if (session == null) {
            session = new MSession(ctx, Remote_Addr, Remote_Host, WebSession, null);
            session.saveEx();
            AD_Session_ID = session.getAD_Session_ID();
            Env.setContext(ctx, "#AD_Session_ID", AD_Session_ID);
        } else {
            session = new MSession(ctx, session.getAD_Session_ID(), null);
        }
        return session;
    }

    public MSession(Properties ctx, String AD_Session_UU, String trxName) {
        super(ctx, AD_Session_UU, trxName);
        if (Util.isEmpty(AD_Session_UU)) {
            this.setInitialDefaults();
        }
    }

    public MSession(Properties ctx, int AD_Session_ID, String trxName) {
        super(ctx, AD_Session_ID, trxName);
        if (AD_Session_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setProcessed(false);
    }

    public MSession(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MSession(Properties ctx, String Remote_Addr, String Remote_Host, String WebSession, String trxName) {
        this(ctx, 0, trxName);
        this.setServerName(WebUtil.getServerName());
        if (Remote_Addr != null) {
            this.setRemote_Addr(Remote_Addr);
        }
        if (Remote_Host != null) {
            this.setRemote_Host(Remote_Host);
        }
        if (WebSession != null) {
            this.setWebSession(WebSession);
        }
        this.setDescription(Adempiere.MAIN_VERSION + "_" + Adempiere.DATE_VERSION + " " + Adempiere.getImplementationVersion());
        this.setAD_Role_ID(Env.getContextAsInt(ctx, "#AD_Role_ID"));
        this.setLoginDate(Env.getContextAsDate(ctx, "#Date"));
    }

    public MSession(Properties ctx, String trxName) {
        this(ctx, 0, trxName);
        try {
            InetAddress lh = InetAddress.getLocalHost();
            this.setServerName(WebUtil.getServerName());
            this.setRemote_Addr(lh.getHostAddress());
            this.setRemote_Host(lh.getHostName());
            this.setDescription(Adempiere.MAIN_VERSION + "_" + Adempiere.DATE_VERSION + " " + Adempiere.getImplementationVersion());
            this.setAD_Role_ID(Env.getContextAsInt(ctx, "#AD_Role_ID"));
            this.setLoginDate(Env.getContextAsDate(ctx, "#Date"));
        }
        catch (UnknownHostException e) {
            this.log.log(Level.SEVERE, "No Local Host", e);
        }
    }

    public MSession(MSession copy) {
        this(Env.getCtx(), copy);
    }

    public MSession(Properties ctx, MSession copy) {
        this(ctx, copy, null);
    }

    public MSession(Properties ctx, MSession copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public boolean isWebStoreSession() {
        return this.m_webStoreSession;
    }

    public void setWebStoreSession(boolean webStoreSession) {
        this.m_webStoreSession = webStoreSession;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MSession[").append(this.getAD_Session_ID()).append(",AD_User_ID=").append(this.getCreatedBy()).append(",").append(this.getCreated()).append(",Remote=").append(this.getRemote_Addr());
        String s = this.getRemote_Host();
        if (s != null && s.length() > 0) {
            sb.append(",").append(s);
        }
        if (this.m_webStoreSession) {
            sb.append(",WebStoreSession");
        }
        sb.append("]");
        return sb.toString();
    }

    public void logout() {
        this.setProcessed(true);
        this.saveEx();
        s_sessions.remove(this.getAD_Session_ID());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(TimeUtil.formatElapsed(this.getCreated(), this.getUpdated()));
        }
    }

    @Deprecated
    public MChangeLog changeLog(String TrxName, int AD_ChangeLog_ID, int AD_Table_ID, int AD_Column_ID, int Record_ID, int AD_Client_ID, int AD_Org_ID, Object OldValue, Object NewValue) {
        return this.changeLog(TrxName, AD_ChangeLog_ID, AD_Table_ID, AD_Column_ID, Record_ID, null, AD_Client_ID, AD_Org_ID, OldValue, NewValue, null);
    }

    public MChangeLog changeLog(String TrxName, int AD_ChangeLog_ID, int AD_Table_ID, int AD_Column_ID, int Record_ID, int AD_Client_ID, int AD_Org_ID, Object OldValue, Object NewValue, String event) {
        return this.changeLog(TrxName, AD_ChangeLog_ID, AD_Table_ID, AD_Column_ID, Record_ID, null, AD_Client_ID, AD_Org_ID, OldValue, NewValue, null);
    }

    public MChangeLog changeLog(String TrxName, int AD_ChangeLog_ID, int AD_Table_ID, int AD_Column_ID, int Record_ID, String Record_UU, int AD_Client_ID, int AD_Org_ID, Object OldValue, Object NewValue, String event) {
        if (AD_Table_ID == 580) {
            return null;
        }
        if (OldValue == null && NewValue == null) {
            return null;
        }
        if (OldValue != null && NewValue != null && OldValue.equals(NewValue)) {
            return null;
        }
        MRole role = MRole.getDefault(this.getCtx(), false);
        if (!(this.m_webStoreSession || MChangeLog.isLogged(AD_Table_ID) || role != null && role.isChangeLog())) {
            return null;
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("AD_ChangeLog_ID=" + AD_ChangeLog_ID + ", AD_Session_ID=" + this.getAD_Session_ID() + ", AD_Table_ID=" + AD_Table_ID + ", AD_Column_ID=" + AD_Column_ID + ": " + String.valueOf(OldValue) + " -> " + String.valueOf(NewValue));
        }
        try {
            MChangeLog cl = new MChangeLog(this.getCtx(), AD_ChangeLog_ID, TrxName, this.getAD_Session_ID(), AD_Table_ID, AD_Column_ID, Record_ID, Record_UU, AD_Client_ID, AD_Org_ID, OldValue, NewValue, event);
            if (cl.saveCrossTenantSafe()) {
                return cl;
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "AD_ChangeLog_ID=" + AD_ChangeLog_ID + ", AD_Session_ID=" + this.getAD_Session_ID() + ", AD_Table_ID=" + AD_Table_ID + ", AD_Column_ID=" + AD_Column_ID, e);
            return null;
        }
        this.log.log(Level.SEVERE, "AD_ChangeLog_ID=" + AD_ChangeLog_ID + ", AD_Session_ID=" + this.getAD_Session_ID() + ", AD_Table_ID=" + AD_Table_ID + ", AD_Column_ID=" + AD_Column_ID);
        return null;
    }

    public static int getCachedSessionCount() {
        return s_sessions.size() - 1;
    }

    @Override
    public MSession markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

