/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.event;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.base.BaseActivator;
import org.adempiere.base.event.EventProperty;
import org.adempiere.base.event.IEventManager;
import org.adempiere.base.event.annotations.BaseEventHandler;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Util;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

public class EventManager
implements IEventManager {
    private EventAdmin eventAdmin;
    private static IEventManager instance = null;
    private static final CLogger log = CLogger.getCLogger(EventManager.class);
    private static final Object mutex = new Object();
    private Map<EventHandler, List<ServiceRegistration<?>>> registrations = new HashMap();
    private List<String> blackListEventHandlers = null;
    private Map<String, List<String>> blackListTopicMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindEventAdmin(EventAdmin eventAdmin) {
        Object object = mutex;
        synchronized (object) {
            if (instance == null) {
                instance = this;
                this.retrieveBlacklistHandlers();
                mutex.notifyAll();
            }
        }
        this.eventAdmin = eventAdmin;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void retrieveBlacklistHandlers() {
        this.blackListEventHandlers = new ArrayList<String>();
        this.blackListTopicMap = new HashMap<String, List<String>>();
        String path = Ini.getAdempiereHome();
        File file = new File(path, "event.handlers.blacklist");
        if (!file.exists()) return;
        BufferedReader br2 = null;
        try {
            FileReader reader = new FileReader(file);
            br2 = new BufferedReader(reader);
            String s = null;
            do {
                String[] topics;
                int topicEnd;
                if (Util.isEmpty(s = br2.readLine())) continue;
                s = s.trim();
                if ((s = s.replaceAll(" ", "")).endsWith("[*]")) {
                    this.blackListEventHandlers.add(s.substring(0, s.length() - 3));
                    continue;
                }
                int topicStart = s.indexOf("[");
                if (topicStart <= 0 || (topicEnd = s.indexOf("]", topicStart)) <= 0) continue;
                String topicValue = s.substring(topicStart + 1, topicEnd);
                String className = s.substring(0, topicStart);
                if (this.blackListEventHandlers.contains(className)) continue;
                List<String> topicList = this.blackListTopicMap.get(className);
                if (topicList == null) {
                    topicList = new ArrayList<String>();
                    this.blackListTopicMap.put(className, topicList);
                }
                String[] stringArray = topics = topicValue.split("[,]");
                int n = topics.length;
                int n2 = 0;
                while (n2 < n) {
                    String topic = stringArray[n2];
                    if (!topicList.contains(topic)) {
                        topicList.add(topic);
                    }
                    ++n2;
                }
            } while (s != null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            if (br2 == null) return;
            try {
                br2.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                if (br2 == null) return;
            }
            catch (Throwable throwable) {
                if (br2 == null) throw throwable;
                try {
                    br2.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                br2.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (br2 == null) return;
        try {
            br2.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public void unbindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IEventManager getInstance() {
        Object object = mutex;
        synchronized (object) {
            while (true) {
                if (instance != null) {
                    return instance;
                }
                try {
                    mutex.wait(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public boolean postEvent(Event event) {
        if (this.eventAdmin != null) {
            if (!event.containsProperty("event.context")) {
                HashMap<String, Object> properties = new HashMap<String, Object>();
                String[] stringArray = event.getPropertyNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    properties.put(key, event.getProperty(key));
                    ++n2;
                }
                properties.put("event.context", EventManager.getCurrentSessionContext());
                event = EventManager.newEvent(event.getTopic(), properties, true);
            }
            this.eventAdmin.postEvent(event);
            return true;
        }
        return false;
    }

    @Override
    public boolean sendEvent(Event event) {
        if (this.eventAdmin != null) {
            this.eventAdmin.sendEvent(event);
            return true;
        }
        return false;
    }

    @Override
    public boolean register(String topic, EventHandler eventHandler) {
        return this.register(topic, null, eventHandler);
    }

    @Override
    public boolean register(String[] topics, EventHandler eventHandler) {
        return this.register(topics, null, eventHandler);
    }

    @Override
    public boolean register(String topic, String filter, EventHandler eventHandler) {
        String[] topics = new String[]{topic};
        return this.register(topics, filter, eventHandler);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isBlackListed(List<String> topics, EventHandler eventHandler) {
        List<String> blackListed;
        String className = eventHandler.getClass().getName();
        EventHandler eventHandler2 = eventHandler;
        if (eventHandler2 instanceof BaseEventHandler) {
            void beh;
            BaseEventHandler baseEventHandler = (BaseEventHandler)eventHandler2;
            BaseEventHandler cfr_ignored_0 = (BaseEventHandler)eventHandler2;
            if (beh.getDelegateClass() != null) {
                className = beh.getDelegateClass().getName();
            }
        }
        if (this.blackListEventHandlers != null && this.blackListEventHandlers.contains(className)) {
            return true;
        }
        if (this.blackListTopicMap != null && !this.blackListTopicMap.isEmpty() && (blackListed = this.blackListTopicMap.get(className)) != null && !blackListed.isEmpty()) {
            Iterator<String> iterator = topics.iterator();
            while (iterator.hasNext()) {
                String topic = iterator.next();
                if (!blackListed.contains(topic)) continue;
                iterator.remove();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean register(String[] topics, String filter, EventHandler eventHandler) {
        BundleContext bundleContext = BaseActivator.getBundleContext();
        if (bundleContext == null) {
            log.severe("No bundle context. Topic=" + Arrays.toString(topics));
            return false;
        }
        List topicList = Arrays.stream(topics).collect(Collectors.toCollection(ArrayList::new));
        if (this.isBlackListed(topicList, eventHandler)) {
            return false;
        }
        if (topicList.isEmpty()) {
            return false;
        }
        if (topicList.size() != topics.length) {
            topics = topicList.toArray(new String[0]);
        }
        Hashtable<String, Object> d = new Hashtable<String, Object>();
        ((Dictionary)d).put("event.topics", topics);
        if (filter != null) {
            ((Dictionary)d).put("event.filter", filter);
        }
        ServiceRegistration registration = bundleContext.registerService(EventHandler.class.getName(), (Object)eventHandler, d);
        Map<EventHandler, List<ServiceRegistration<?>>> map = this.registrations;
        synchronized (map) {
            List<ServiceRegistration<?>> list = this.registrations.get(eventHandler);
            if (list == null) {
                list = new ArrayList();
                this.registrations.put(eventHandler, list);
            }
            list.add(registration);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unregister(EventHandler eventHandler) {
        List<ServiceRegistration<?>> serviceRegistrations = null;
        Map<EventHandler, List<ServiceRegistration<?>>> map = this.registrations;
        synchronized (map) {
            serviceRegistrations = this.registrations.remove(eventHandler);
        }
        if (serviceRegistrations == null) {
            return false;
        }
        for (ServiceRegistration<?> registration : serviceRegistrations) {
            registration.unregister();
        }
        return true;
    }

    public static Event newEvent(String topic, Object data) {
        return EventManager.newEvent(topic, data, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Event newEvent(String topic, Object data, boolean copySessionContext) {
        Event event = null;
        if (data instanceof Dictionary) {
            Dictionary dict = (Dictionary)data;
            if (dict.get("event.errorMessages") == null) {
                dict.put("event.errorMessages", new ArrayList());
            }
            if (copySessionContext) {
                dict.put("event.context", EventManager.getCurrentSessionContext());
            }
            event = new Event(topic, dict);
        } else if (data instanceof Map) {
            Map map = (Map)data;
            if (!map.containsKey("event.errorMessages")) {
                map.put("event.errorMessages", new ArrayList());
            }
            if (copySessionContext) {
                map.put("event.context", EventManager.getCurrentSessionContext());
            }
            event = new Event(topic, map);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            map.put("event.topics", topic);
            if (data != null) {
                map.put("event.data", data);
                Object object = data;
                if (object instanceof PO) {
                    void po;
                    PO pO = (PO)object;
                    PO cfr_ignored_0 = (PO)object;
                    map.put("tableName", po.get_TableName());
                }
            }
            map.put("event.errorMessages", new ArrayList());
            if (copySessionContext) {
                map.put("event.context", EventManager.getCurrentSessionContext());
            }
            event = new Event(topic, map);
        }
        return event;
    }

    private static Properties getCurrentSessionContext() {
        Properties context = new Properties();
        Env.setContext(context, "#AD_Client_ID", Env.getAD_Client_ID(Env.getCtx()));
        Env.setContext(context, "#AD_Org_ID", Env.getAD_Org_ID(Env.getCtx()));
        Env.setContext(context, "#AD_User_ID", Env.getAD_User_ID(Env.getCtx()));
        Env.setContext(context, "#AD_Role_ID", Env.getAD_Role_ID(Env.getCtx()));
        Env.setContext(context, "#M_Warehouse_ID", Env.getContext(Env.getCtx(), "#M_Warehouse_ID"));
        Env.setContext(context, "#AD_Language", Env.getContext(Env.getCtx(), "#AD_Language"));
        return context;
    }

    public static Event newEvent(String topic, EventProperty ... properties) {
        Event event = null;
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        if (properties != null) {
            int i2 = 0;
            while (i2 < properties.length) {
                map.put(properties[i2].name, properties[i2].value);
                ++i2;
            }
            if (!map.containsKey("event.topics")) {
                map.put("event.topics", topic);
            }
            if (!map.containsKey("event.errorMessages")) {
                map.put("event.errorMessages", new ArrayList());
            }
        }
        event = new Event(topic, map);
        return event;
    }
}

