/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource.file;

import com.trekglobal.idempiere.rest.api.util.ClusterUtil;
import com.trekglobal.idempiere.rest.api.v1.resource.file.FileInfo;
import com.trekglobal.idempiere.rest.api.v1.resource.file.ReadFileCallable;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.idempiere.distributed.IClusterMember;
import org.idempiere.distributed.IClusterService;

public class RemoteFileStreamingOutput
implements StreamingOutput {
    private FileInfo fileInfo;
    private IClusterMember member;

    public RemoteFileStreamingOutput(FileInfo fileInfo, IClusterMember member) {
        this.fileInfo = fileInfo;
        this.member = member;
    }

    public void write(OutputStream output) throws IOException, WebApplicationException {
        if (this.fileInfo.getLength() == 0L) {
            return;
        }
        IClusterService service = ClusterUtil.getClusterService();
        BufferedOutputStream bos = new BufferedOutputStream(output);
        int i = 0;
        while (i < this.fileInfo.getNoOfBlocks()) {
            ReadFileCallable callable = new ReadFileCallable(this.fileInfo.getParentFolderName(), this.fileInfo.getFileName(), this.fileInfo.getBlockSize(), i);
            try {
                byte[] contents = (byte[])service.execute((Callable)callable, this.member).get();
                if (contents == null || contents.length == 0) break;
                bos.write(contents);
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                throw new WebApplicationException((Throwable)e);
            }
            ++i;
        }
        bos.flush();
    }
}

