/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.oidc.keycloak;

import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.model.MOIDCService;
import com.trekglobal.idempiere.rest.api.oidc.AbstractOIDCProvider;
import com.trekglobal.idempiere.rest.api.oidc.AuthenticatedUser;
import com.trekglobal.idempiere.rest.api.oidc.IOIDCProvider;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;
import javax.ws.rs.container.ContainerRequestContext;
import org.compiere.model.MOrg;
import org.compiere.model.MRole;
import org.compiere.model.MSession;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={IOIDCProvider.class}, property={"name=Keycloak"})
public class KeycloakProvider
extends AbstractOIDCProvider {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AuthenticatedUser getAuthenticatedUser(DecodedJWT decodedJwt, ContainerRequestContext requestContext, MOIDCService oidcService) {
        MSession session;
        MRole mRole;
        boolean useEmail;
        String userId;
        String headerOrgValue;
        String roleHeader;
        int AD_Role_ID;
        int AD_User_ID;
        int AD_Org_ID;
        int AD_Client_ID;
        block37: {
            Query query;
            String orgHeader;
            block34: {
                block36: {
                    Query query2;
                    ArrayList roleNames;
                    block35: {
                        AD_Client_ID = oidcService.getAD_Client_ID();
                        AD_Org_ID = -1;
                        AD_User_ID = -1;
                        AD_Role_ID = -1;
                        orgHeader = requestContext.getHeaderString("X-ID-Organization");
                        roleHeader = requestContext.getHeaderString("X-ID-Role");
                        headerOrgValue = null;
                        if (!oidcService.isAuthorization_OIDC()) break block34;
                        roleNames = new ArrayList();
                        Claim azpClaim = decodedJwt.getClaim("azp");
                        String keycloakClientId = azpClaim.asString();
                        Claim resourceAccessClaim = decodedJwt.getClaim("resource_access");
                        if (resourceAccessClaim.isNull() || resourceAccessClaim.isMissing()) {
                            throw new JWTVerificationException("Missing roles claim");
                        }
                        String resourceAccessText = resourceAccessClaim.toString();
                        Gson gson = new Gson();
                        JsonObject resourceAccessJson = (JsonObject)gson.fromJson(resourceAccessText, JsonObject.class);
                        JsonObject resourceClientJson = resourceAccessJson.getAsJsonObject(keycloakClientId);
                        JsonElement rolesElement = resourceClientJson.get("roles");
                        JsonArray rolesArray = rolesElement.getAsJsonArray();
                        rolesArray.forEach(e -> {
                            boolean bl = roleNames.add(e.getAsString());
                        });
                        if (roleNames.size() == 0) {
                            throw new JWTVerificationException("Missing roles claim");
                        }
                        Claim groupsClaim = decodedJwt.getClaim("groups");
                        if (groupsClaim.isNull() || groupsClaim.isMissing()) {
                            throw new JWTVerificationException("Missing organization claim");
                        }
                        String[] groupNames = (String[])groupsClaim.asArray(String.class);
                        ArrayList<MOrg> orgList = new ArrayList<MOrg>();
                        String[] stringArray = groupNames;
                        int n = groupNames.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Query query3;
                            MOrg org;
                            String groupName = stringArray[n2];
                            if (groupName.startsWith("/")) {
                                groupName = groupName.substring(1);
                            }
                            if ((org = (MOrg)(query3 = new Query(Env.getCtx(), "AD_Org", "AD_Client_ID=? AND Value=?", null)).setOnlyActiveRecords(true).setParameters(new Object[]{AD_Client_ID, groupName}).first()) != null) {
                                orgList.add(org);
                            }
                            ++n2;
                        }
                        if (orgList.size() == 0) {
                            throw new JWTVerificationException("Missing organization claim");
                        }
                        if (orgList.size() == 1) {
                            if (!Util.isEmpty((String)orgHeader) && !orgHeader.equals(((MOrg)orgList.get(0)).getValue())) throw new JWTVerificationException("Invalid %s header".formatted("X-ID-Organization"));
                            AD_Org_ID = ((MOrg)orgList.get(0)).get_ID();
                        } else if (!Util.isEmpty((String)orgHeader)) {
                            int i = 0;
                            while (i < orgList.size()) {
                                if (orgHeader.equals(((MOrg)orgList.get(i)).getValue())) {
                                    AD_Org_ID = ((MOrg)orgList.get(i)).get_ID();
                                    break;
                                }
                                ++i;
                            }
                            if (AD_Org_ID == -1) {
                                throw new JWTVerificationException("Invalid %s header".formatted("X-ID-Organization"));
                            }
                        }
                        String roleName = null;
                        if (roleNames.size() == 1) {
                            roleName = (String)roleNames.get(0);
                            if (!Util.isEmpty((String)roleHeader) && !roleHeader.equals(roleName)) {
                                throw new JWTVerificationException("Invalid %s header".formatted("X-ID-Role"));
                            }
                        } else if (!Util.isEmpty((String)roleHeader)) {
                            Optional<String> optional = roleNames.stream().filter(e -> roleHeader.equals(e)).findFirst();
                            if (!optional.isPresent()) throw new JWTVerificationException("Invalid %s header".formatted("X-ID-Role"));
                            roleName = optional.get();
                        }
                        query2 = new Query(Env.getCtx(), "AD_Role", "AD_Client_ID=? AND Name=?", null);
                        if (roleName == null) break block35;
                        MRole mRole2 = (MRole)query2.setOnlyActiveRecords(true).setParameters(new Object[]{AD_Client_ID, roleName}).first();
                        if (mRole2 == null) break block36;
                        AD_Role_ID = mRole2.get_ID();
                        break block36;
                    }
                    MRole mRole3 = null;
                    for (String r : roleNames) {
                        mRole3 = (MRole)query2.setOnlyActiveRecords(true).setParameters(new Object[]{AD_Client_ID, r}).first();
                        if (mRole3 == null) continue;
                        AD_Role_ID = mRole3.get_ID();
                        break;
                    }
                }
                if (AD_Role_ID == -1) {
                    throw new JWTVerificationException("Invalid Role claim");
                }
                break block37;
            }
            if (!Util.isEmpty((String)orgHeader)) {
                query = new Query(Env.getCtx(), "AD_Org", "AD_Client_ID=? AND Value=?", null);
                MOrg org = (MOrg)query.setOnlyActiveRecords(true).setParameters(new Object[]{AD_Client_ID, orgHeader}).first();
                if (org != null) {
                    AD_Org_ID = org.getAD_Org_ID();
                }
                if (AD_Org_ID == -1) {
                    throw new JWTVerificationException("Invalid %s header".formatted("X-ID-Organization"));
                }
            }
            if (!Util.isEmpty((String)roleHeader)) {
                query = new Query(Env.getCtx(), "AD_Role", "AD_Client_ID=? AND Name=?", null);
                MRole mRole4 = (MRole)query.setOnlyActiveRecords(true).setParameters(new Object[]{AD_Client_ID, roleHeader}).first();
                if (mRole4 == null) throw new JWTVerificationException("Invalid %s header".formatted("X-ID-Role"));
                AD_Role_ID = mRole4.getAD_Role_ID();
            }
        }
        if (Util.isEmpty((String)(userId = decodedJwt.getClaim((useEmail = MSysConfig.getBooleanValue((String)"USE_EMAIL_FOR_LOGIN", (boolean)false)) ? "email" : "name").asString()))) {
            throw new JWTVerificationException("Missing user claim");
        }
        Query query = new Query(Env.getCtx(), "AD_User", "AD_Client_ID IN (0,?) AND %s=?".formatted(useEmail ? "Email" : "Name"), null);
        MUser user = (MUser)query.setOnlyActiveRecords(true).setParameters(new Object[]{AD_Client_ID, userId}).setOrderBy("AD_Client_ID DESC").first();
        if (user == null) {
            throw new JWTVerificationException("Invalid user claim");
        }
        AD_User_ID = user.get_ID();
        boolean orgAccessValidated = false;
        if (AD_Role_ID == -1) {
            if (!Util.isEmpty((String)roleHeader)) {
                query = new Query(Env.getCtx(), "AD_Role", "AD_Client_ID=? AND Name=?", null);
                mRole = (MRole)query.setOnlyActiveRecords(true).setParameters(new Object[]{AD_Client_ID, roleHeader}).first();
                if (mRole == null) throw new JWTVerificationException("Invalid %s header".formatted("X-ID-Role"));
                AD_Role_ID = mRole.getAD_Role_ID();
            } else {
                AD_Role_ID = this.getSingleRoleIDOnly(AD_Client_ID, user);
            }
        }
        if (AD_Role_ID < 0) throw new JWTVerificationException("Missing Role Claim or Header");
        if (AD_Org_ID == -1) {
            if (!Util.isEmpty(headerOrgValue)) {
                query = new Query(Env.getCtx(), "AD_Org", "AD_Client_ID=? AND Value=?", null);
                MOrg org = (MOrg)query.setOnlyActiveRecords(true).setParameters(new Object[]{AD_Client_ID, headerOrgValue}).first();
                if (org == null) throw new JWTVerificationException("Invalid %s header".formatted("X-ID-Organization"));
                AD_Org_ID = org.getAD_Org_ID();
            } else {
                AD_Org_ID = this.getSingleOrgIdOnly(AD_Client_ID, AD_Role_ID, user);
                if (AD_Org_ID < 0) throw new JWTVerificationException("Missing Organization Claim or Header");
                orgAccessValidated = true;
            }
        }
        if (AD_Role_ID >= 0 && AD_Org_ID >= 0 && !orgAccessValidated) {
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_Client_ID", (int)AD_Client_ID);
            mRole = new MRole(Env.getCtx(), AD_Role_ID, null);
            if (mRole.isUseUserOrgAccess()) {
                mRole.setAD_User_ID(AD_User_ID);
            }
            if (!mRole.isOrgAccess(AD_Org_ID, false)) {
                throw new JWTVerificationException("Invalid user and organization combination");
            }
        }
        if ((session = MSession.get((Properties)Env.getCtx())) != null) return new AuthenticatedUser(AD_Client_ID, AD_Org_ID, AD_Role_ID, AD_User_ID, session.getAD_Session_ID());
        session = MSession.create((Properties)Env.getCtx());
        session.setWebSession("idempiere-rest-oidc");
        session.saveEx();
        return new AuthenticatedUser(AD_Client_ID, AD_Org_ID, AD_Role_ID, AD_User_ID, session.getAD_Session_ID());
    }
}

