/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.select.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.zkoss.fsm.StateCtx;
import org.zkoss.fsm.StateMachine;
import org.zkoss.zk.ui.select.impl.CharSequenceIterator;
import org.zkoss.zk.ui.select.impl.ParseException;
import org.zkoss.zk.ui.select.impl.Token;

public class Tokenizer {
    private final StateMachine<State, CharClass, Character> _machine = new StateMachine<State, CharClass, Character>(){
        private int _anchor;
        private char _prevChar;
        private CharClass _prevClass;
        protected boolean _inDoubleQuote;
        protected boolean _inSingleQuote;
        protected boolean _inParam;
        protected boolean _escaped;
        protected boolean _opEscaped;

        protected void init() {
            this.getState((Object)State.MAIN).setReturningAll(true).addTransition((Object)CharClass.OPEN_BRACKET, (Object)State.IN_ATTRIBUTE);
            this.setState((Object)State.IN_ATTRIBUTE, (StateCtx)new StateCtx<State, CharClass, Character>(){

                protected void onReturn(Character i, CharClass cls) {
                    if (cls != CharClass.OTHER) {
                        return;
                    }
                    if (i.charValue() == '\"') {
                        _inDoubleQuote = !_inDoubleQuote;
                    } else if (i.charValue() == '\'') {
                        _inSingleQuote = !_inSingleQuote;
                    }
                }
            }).setReturningAll(true).addTransition((Object)CharClass.CLOSE_BRACKET, (Object)State.MAIN);
        }

        protected void onReset() {
            this._inDoubleQuote = false;
            this._inSingleQuote = false;
            this._inParam = false;
            this._escaped = false;
            this._opEscaped = false;
            this._anchor = 0;
            this._prevChar = (char)33;
            this._prevClass = null;
            Tokenizer.this._tokens = new ArrayList();
        }

        protected void afterStep(Character input, CharClass inputClass, State origin, State destination) {
            boolean isPrefix;
            this.doDebug("* OP Escaped: " + this._opEscaped);
            if (inputClass == CharClass.ESCAPE) {
                return;
            }
            boolean bl = isPrefix = origin == State.IN_ATTRIBUTE && inputClass == CharClass.OTHER && (input.charValue() == '^' || input.charValue() == '$' || input.charValue() == '*');
            if (this._prevChar == ':' && input.charValue() == ':' && !this._inParam) {
                this.flush(Token.Type.NTN_PSDOELEM, true);
            }
            if (this._prevChar == ':' && input.charValue() != ':' && !this._inParam && this.previousTokenIsNotPseudoElement()) {
                this.flush(this._prevChar, this._prevClass, false);
            }
            if (inputClass != this._prevClass && this._prevClass != null && this._prevClass.isMultiple()) {
                this.flush(this._prevChar, this._prevClass, false);
            }
            if (origin == State.IN_ATTRIBUTE && this._opEscaped && input.charValue() != '=') {
                this.flush(this._prevChar, this._prevClass, false);
            }
            if (!inputClass.isMultiple() && !isPrefix && input.charValue() != ':') {
                this.flush(input.charValue(), inputClass, true);
            }
            if (input.charValue() == '(') {
                this._inParam = true;
            } else if (input.charValue() == ')') {
                this._inParam = false;
            }
            this._prevChar = input.charValue();
            this._prevClass = inputClass;
            this._opEscaped = isPrefix;
        }

        protected void onStop(boolean endOfInput) {
            if (!endOfInput) {
                return;
            }
            if (this._anchor < this._step) {
                this.flush(this._prevChar, this._prevClass, false);
            }
        }

        protected CharClass getClass(Character c) {
            if (this._inDoubleQuote && (this._escaped || c.charValue() != '\"')) {
                return CharClass.LITERAL;
            }
            if (this._inSingleQuote && (this._escaped || c.charValue() != '\'')) {
                return CharClass.LITERAL;
            }
            if (this._current == State.MAIN && c.charValue() == '[') {
                return CharClass.OPEN_BRACKET;
            }
            if (this._current == State.IN_ATTRIBUTE && !this._inDoubleQuote && !this._inSingleQuote && c.charValue() == ']') {
                return CharClass.CLOSE_BRACKET;
            }
            if (this._inParam && c.charValue() != ',' && c.charValue() != ')') {
                return Character.isWhitespace(c.charValue()) ? CharClass.OTHER : CharClass.LITERAL;
            }
            if (this._escaped) {
                return Character.isWhitespace(c.charValue()) ? CharClass.WHITESPACE : CharClass.LITERAL;
            }
            if (Character.isLetter(c.charValue()) || Character.isDigit(c.charValue()) || c.charValue() == '-' || c.charValue() == '_') {
                return CharClass.LITERAL;
            }
            if (Character.isWhitespace(c.charValue())) {
                return CharClass.WHITESPACE;
            }
            if ('.' == c.charValue() && this._current == State.IN_ATTRIBUTE) {
                return CharClass.LITERAL;
            }
            return c.charValue() == '\\' ? CharClass.ESCAPE : CharClass.OTHER;
        }

        protected State getLandingState(Character input, CharClass inputClass) {
            if (input.charValue() == '[') {
                return State.IN_ATTRIBUTE;
            }
            if (this._current == State.IN_ATTRIBUTE && (this._inDoubleQuote || this._inSingleQuote)) {
                return State.IN_ATTRIBUTE;
            }
            if (inputClass == CharClass.ESCAPE) {
                this._escaped = true;
            }
            return State.MAIN;
        }

        protected void onReject(Character input) {
            throw new ParseException(this._step, this._current, input);
        }

        private boolean previousTokenIsNotPseudoElement() {
            return Tokenizer.this._tokens.isEmpty() || !Tokenizer.this._tokens.get(Tokenizer.this._tokens.size() - 1).getType().equals((Object)Token.Type.NTN_PSDOELEM);
        }

        private void flush(char input, CharClass inputClass, boolean withCurrChar) {
            int endIndex = this._step + (withCurrChar ? 1 : (this._escaped ? -1 : 0));
            Tokenizer.this._tokens.add(new Token(this.getTokenType(input, inputClass), this._anchor, endIndex));
            this.doDebug("! flush: [" + this._anchor + ", " + endIndex + "]");
            this._anchor = endIndex;
        }

        private void flush(Token.Type tokenType, boolean withCurrChar) {
            int endIndex = this._step + (withCurrChar ? 1 : (this._escaped ? -1 : 0));
            Tokenizer.this._tokens.add(new Token(tokenType, this._anchor, endIndex));
            this.doDebug("! flush: [" + this._anchor + ", " + endIndex + "]");
            this._anchor = endIndex;
        }

        private Token.Type getTokenType(char input, CharClass inputClass) {
            switch (inputClass) {
                case LITERAL: {
                    return Token.Type.IDENTIFIER;
                }
                case WHITESPACE: {
                    return Token.Type.WHITESPACE;
                }
            }
            switch (input) {
                case ',': {
                    return this._inParam ? Token.Type.PARAM_SEPARATOR : Token.Type.SELECTOR_SEPARATOR;
                }
                case '*': {
                    return Token.Type.UNIVERSAL;
                }
                case '>': {
                    return Token.Type.CBN_CHILD;
                }
                case '+': {
                    return Token.Type.CBN_ADJACENT_SIBLING;
                }
                case '~': {
                    return Token.Type.CBN_GENERAL_SIBLING;
                }
                case '#': {
                    return Token.Type.NTN_ID;
                }
                case '.': {
                    return inputClass == CharClass.ATTR_GETTER_OP ? Token.Type.IDENTIFIER : Token.Type.NTN_CLASS;
                }
                case ':': {
                    return Token.Type.NTN_PSDOCLS;
                }
                case '\'': {
                    return Token.Type.SINGLE_QUOTE;
                }
                case '\"': {
                    return Token.Type.DOUBLE_QUOTE;
                }
                case '[': {
                    return Token.Type.OPEN_BRACKET;
                }
                case ']': {
                    return Token.Type.CLOSE_BRACKET;
                }
                case '(': {
                    return Token.Type.OPEN_PAREN;
                }
                case ')': {
                    return Token.Type.CLOSE_PAREN;
                }
                case '=': {
                    switch (this._prevChar) {
                        case '^': {
                            return Token.Type.OP_BEGIN_WITH;
                        }
                        case '$': {
                            return Token.Type.OP_END_WITH;
                        }
                        case '*': {
                            return Token.Type.OP_CONTAIN;
                        }
                    }
                    return Token.Type.OP_EQUAL;
                }
            }
            return Character.isWhitespace(input) ? Token.Type.MINOR_WHITESPACE : Token.Type.UNKNOWN_CHAR;
        }
    };
    private ArrayList<Token> _tokens = null;

    public ArrayList<Token> tokenize(String selector) {
        this._machine.start((Iterator)new CharSequenceIterator(selector));
        return this._tokens;
    }

    public void setDebugMode(boolean mode) {
        this._machine.setDebugMode(mode);
    }

    private static enum CharClass {
        LITERAL(true),
        WHITESPACE(true),
        ESCAPE,
        OTHER,
        ATTR_GETTER_OP,
        OPEN_BRACKET,
        CLOSE_BRACKET;

        private boolean _multiple;

        private CharClass() {
            this(false);
        }

        private CharClass(boolean multiple) {
            this._multiple = multiple;
        }

        public boolean isMultiple() {
            return this._multiple;
        }
    }

    private static enum State {
        MAIN,
        IN_ATTRIBUTE;

    }
}

