/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.event;

import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.event.Event;

public class ClientInfoEvent
extends Event {
    private final int _scrnwd;
    private final int _scrnhgh;
    private final int _colorDepth;
    private final int _dtwd;
    private final int _dthgh;
    private final int _dtx;
    private final int _dty;
    private final double _dpr;
    private final String _orient;
    private final String _media;
    private final boolean _mediaMatched;
    private final ZoneId _zoneId;

    public static final ClientInfoEvent getClientInfoEvent(AuRequest request) {
        Map<String, Object> data = request.getData();
        List inf = (List)data.get("");
        return new ClientInfoEvent(request.getCommand(), ClientInfoEvent.getInt(inf, 0), ClientInfoEvent.getInt(inf, 1), ClientInfoEvent.getInt(inf, 2), ClientInfoEvent.getInt(inf, 3), ClientInfoEvent.getInt(inf, 4), ClientInfoEvent.getInt(inf, 5), ClientInfoEvent.getInt(inf, 6), ClientInfoEvent.getInt(inf, 7), ClientInfoEvent.getDouble(inf, 8), ClientInfoEvent.getString(inf, 9), ClientInfoEvent.getString(inf, 10), ClientInfoEvent.getBoolean(inf, 11), ClientInfoEvent.getString(inf, 12));
    }

    private static final int getInt(List inf, int j) {
        return j < inf.size() ? (Integer)inf.get(j) : 0;
    }

    private static final double getDouble(List inf, int j) {
        return j < inf.size() ? Double.parseDouble((String)inf.get(j)) : 0.0;
    }

    private static final String getString(List inf, int j) {
        return j < inf.size() ? String.valueOf(inf.get(j)) : "";
    }

    private static final boolean getBoolean(List inf, int j) {
        return j < inf.size() && (Boolean)inf.get(j) != false;
    }

    public ClientInfoEvent(String name, int timeZoneOfs, int scrnwd, int scrnhgh, int colorDepth, int dtwd, int dthgh, int dtx, int dty, double dpr, String orient, String zoneId, boolean mediaMatched, String media) {
        super(name, null);
        StringBuffer sb = new StringBuffer(8).append("GMT");
        this._scrnwd = scrnwd;
        this._scrnhgh = scrnhgh;
        this._colorDepth = colorDepth;
        this._dtwd = dtwd;
        this._dthgh = dthgh;
        this._dtx = dtx;
        this._dty = dty;
        this._dpr = dpr;
        this._orient = orient;
        this._zoneId = ZoneId.of(zoneId);
        this._mediaMatched = mediaMatched;
        this._media = media;
    }

    public int getScreenWidth() {
        return this._scrnwd;
    }

    public int getScreenHeight() {
        return this._scrnhgh;
    }

    public int getColorDepth() {
        return this._colorDepth;
    }

    public int getDesktopWidth() {
        return this._dtwd;
    }

    public int getDesktopHeight() {
        return this._dthgh;
    }

    public int getDesktopXOffset() {
        return this._dtx;
    }

    public int getDesktopYOffset() {
        return this._dty;
    }

    public double getDevicePixelRatio() {
        return this._dpr;
    }

    public String getOrientation() {
        return this._orient;
    }

    public boolean isPortrait() {
        return "portrait".equals(this._orient);
    }

    public boolean isVertical() {
        return this.isPortrait();
    }

    public boolean isLandscape() {
        return "landscape".equals(this._orient);
    }

    public boolean isHorizontal() {
        return this.isLandscape();
    }

    public String getMedia() {
        return this._media;
    }

    public boolean isMediaMatched() {
        return this._mediaMatched;
    }

    public ZoneId getZoneId() {
        return this._zoneId;
    }
}

