/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.server;

import java.util.function.Consumer;
import org.eclipse.jetty.quic.common.ProtocolSession;
import org.eclipse.jetty.quic.common.QuicSession;
import org.eclipse.jetty.quic.common.QuicStreamEndPoint;
import org.eclipse.jetty.quic.server.ServerQuicSession;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerProtocolSession
extends ProtocolSession {
    private static final Logger LOG = LoggerFactory.getLogger(ServerProtocolSession.class);
    private final Runnable producer = Invocable.from((Invocable.InvocationType)Invocable.InvocationType.EITHER, () -> this.produce());
    private final Consumer<QuicStreamEndPoint> openProtocolEndPoint = arg_0 -> ((ServerProtocolSession)this).openProtocolEndPoint(arg_0);

    public ServerProtocolSession(ServerQuicSession session) {
        super((QuicSession)session);
    }

    public ServerQuicSession getQuicSession() {
        return (ServerQuicSession)super.getQuicSession();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.onStart();
    }

    protected void onStart() {
    }

    protected void doStop() throws Exception {
        this.onStop();
        super.doStop();
    }

    protected void onStop() {
    }

    public Runnable getProducerTask() {
        return this.producer;
    }

    protected boolean onReadable(long readableStreamId) {
        QuicStreamEndPoint streamEndPoint = this.getOrCreateStreamEndPoint(readableStreamId, this.openProtocolEndPoint);
        if (LOG.isDebugEnabled()) {
            LOG.debug("stream #{} selected for read: {}", (Object)readableStreamId, (Object)streamEndPoint);
        }
        return streamEndPoint.onReadable();
    }

    protected void onFailure(long error, String reason, Throwable failure) {
    }

    protected void onClose(long error, String reason) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("session closed remotely 0x{}/{} {}", new Object[]{Long.toHexString(error), reason, this});
        }
    }
}

