/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class PptxBorderHelper
extends BaseHelper {
    public PptxBorderHelper(JasperReportsContext jasperReportsContext, Writer writer) {
        super(jasperReportsContext, writer);
    }

    protected void exportBorder(JRExporterGridCell gridCell, JRExporterGridCell topGridCell, JRExporterGridCell leftGridCell, JRExporterGridCell rightGridCell, JRExporterGridCell bottomGridCell) {
        OccupiedGridCell occupiedGridCell;
        JRPen pen = null;
        if (gridCell != null && gridCell.getBox() != null) {
            pen = gridCell.getBox().getLeftPen();
        }
        if ((pen == null || pen.getLineWidth().floatValue() == 0.0f) && leftGridCell != null) {
            if (leftGridCell.getType() == 2) {
                occupiedGridCell = (OccupiedGridCell)leftGridCell;
                leftGridCell = occupiedGridCell.getOccupier();
            }
            if (leftGridCell.getBox() != null) {
                pen = leftGridCell.getBox().getRightPen();
            }
        }
        if (pen != null && pen.getLineWidth().floatValue() > 0.0f) {
            this.exportBorder("lnL", (JRBoxPen)pen);
        }
        pen = null;
        if (gridCell != null && gridCell.getBox() != null) {
            pen = gridCell.getBox().getRightPen();
        }
        if ((pen == null || pen.getLineWidth().floatValue() == 0.0f) && rightGridCell != null) {
            if (rightGridCell.getType() == 2) {
                occupiedGridCell = (OccupiedGridCell)rightGridCell;
                rightGridCell = occupiedGridCell.getOccupier();
            }
            if (rightGridCell.getBox() != null) {
                pen = rightGridCell.getBox().getLeftPen();
            }
        }
        if (pen != null && pen.getLineWidth().floatValue() > 0.0f) {
            this.exportBorder("lnR", (JRBoxPen)pen);
        }
        pen = null;
        if (gridCell != null && gridCell.getBox() != null) {
            pen = gridCell.getBox().getTopPen();
        }
        if ((pen == null || pen.getLineWidth().floatValue() == 0.0f) && topGridCell != null) {
            if (topGridCell.getType() == 2) {
                occupiedGridCell = (OccupiedGridCell)topGridCell;
                topGridCell = occupiedGridCell.getOccupier();
            }
            if (topGridCell.getBox() != null) {
                pen = topGridCell.getBox().getBottomPen();
            }
        }
        if (pen != null && pen.getLineWidth().floatValue() > 0.0f) {
            this.exportBorder("lnT", (JRBoxPen)pen);
        }
        pen = null;
        if (gridCell != null && gridCell.getBox() != null) {
            pen = gridCell.getBox().getBottomPen();
        }
        if ((pen == null || pen.getLineWidth().floatValue() == 0.0f) && bottomGridCell != null) {
            if (bottomGridCell.getType() == 2) {
                occupiedGridCell = (OccupiedGridCell)bottomGridCell;
                bottomGridCell = occupiedGridCell.getOccupier();
            }
            if (bottomGridCell.getBox() != null) {
                pen = bottomGridCell.getBox().getTopPen();
            }
        }
        if (pen != null && pen.getLineWidth().floatValue() > 0.0f) {
            this.exportBorder("lnB", (JRBoxPen)pen);
        }
    }

    protected void exportBorder(String side, JRBoxPen pen) {
        this.write("<a:" + side + " w=\"" + LengthUtil.emu(pen.getLineWidth().floatValue()) + "\">\n");
        this.write("  <a:solidFill>\n");
        this.write("    <a:srgbClr val=\"" + JRColorUtil.getColorHexa(pen.getLineColor()) + "\"/>\n");
        this.write("  </a:solidFill>\n");
        this.write("  <a:prstDash val=\"" + this.getLineStyle(pen.getLineStyleValue()) + "\"/>\n");
        this.write("</a:" + side + ">\n");
    }

    protected String getLineStyle(LineStyleEnum lineStyleEnum) {
        String lineStyle = null;
        switch (lineStyleEnum) {
            case DASHED: {
                lineStyle = "dash";
                break;
            }
            case DOTTED: {
                lineStyle = "dot";
                break;
            }
            default: {
                lineStyle = "solid";
            }
        }
        return lineStyle;
    }
}

