/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocManager;
import org.compiere.acct.Doc_GLJournal;
import org.compiere.acct.Fact;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MNote;
import org.compiere.model.MPeriod;
import org.compiere.model.MRefList;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.X_M_MatchInv;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public abstract class Doc {
    public static final String DOC_TYPE_BY_DOC_BASE_TYPE_SQL = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID=? AND DocBaseType=? AND IsActive='Y' ORDER BY IsDefault DESC, C_DocType_ID";
    public static final String DOCTYPE_ARInvoice = "ARI";
    public static final String DOCTYPE_ARCredit = "ARC";
    public static final String DOCTYPE_ARReceipt = "ARR";
    public static final String DOCTYPE_ARProForma = "ARF";
    public static final String DOCTYPE_APInvoice = "API";
    public static final String DOCTYPE_APCredit = "APC";
    public static final String DOCTYPE_APPayment = "APP";
    public static final String DOCTYPE_BankStatement = "CMB";
    public static final String DOCTYPE_CashJournal = "CMC";
    public static final String DOCTYPE_Allocation = "CMA";
    public static final String DOCTYPE_MatShipment = "MMS";
    public static final String DOCTYPE_MatReceipt = "MMR";
    public static final String DOCTYPE_MatInventory = "MMI";
    public static final String DOCTYPE_MatMovement = "MMM";
    public static final String DOCTYPE_MatProduction = "MMP";
    public static final String DOCTYPE_MatMatchInv = "MXI";
    public static final String DOCTYPE_MatMatchPO = "MXP";
    public static final String DOCTYPE_GLJournal = "GLJ";
    public static final String DOCTYPE_POrder = "POO";
    public static final String DOCTYPE_SOrder = "SOO";
    public static final String DOCTYPE_ProjectIssue = "PJI";
    public static final String DOCTYPE_PurchaseRequisition = "POR";
    public static final String STATUS_NotPosted = "N";
    public static final String STATUS_NotBalanced = "b";
    public static final String STATUS_NotConvertible = "c";
    public static final String STATUS_PeriodClosed = "p";
    public static final String STATUS_InvalidAccount = "i";
    public static final String STATUS_PostPrepared = "y";
    public static final String STATUS_Posted = "Y";
    public static final String STATUS_Error = "E";
    public static final String STATUS_Deferred = "d";
    protected static final CLogger s_log = CLogger.getCLogger(Doc.class);
    protected transient CLogger log = CLogger.getCLogger(this.getClass());
    private boolean m_manageLocalTrx;
    private MAcctSchema m_as = null;
    private Properties m_ctx = null;
    private String m_trxName = null;
    protected PO p_po = null;
    private String m_DocumentType = null;
    private String m_DocStatus = null;
    private String m_DocumentNo = null;
    private String m_Description = null;
    private int m_GL_Category_ID = 0;
    private MPeriod m_period = null;
    private int m_C_Period_ID = 0;
    private int m_C_LocFrom_ID = 0;
    private int m_C_LocTo_ID = 0;
    private Timestamp m_DateAcct = null;
    private Timestamp m_DateDoc = null;
    private boolean m_TaxIncluded = false;
    private boolean m_MultiCurrency = false;
    private int m_BP_C_SalesRegion_ID = -1;
    private int m_C_BPartner_ID = -1;
    private int m_C_BankAccount_ID = -1;
    private int m_C_CashBook_ID = -1;
    private int m_C_Currency_ID = -1;
    protected DocLine[] p_lines;
    private ArrayList<Fact> m_fact = null;
    protected static final int NO_CURRENCY = -2;
    protected String p_Status = "E";
    protected String p_Error = null;
    public static final int AMTTYPE_Gross = 0;
    public static final int AMTTYPE_Net = 1;
    public static final int AMTTYPE_Charge = 2;
    private BigDecimal[] m_Amounts = new BigDecimal[4];
    private BigDecimal m_qty = null;
    public static final int ACCTTYPE_Charge = 0;
    public static final int ACCTTYPE_C_Receivable = 1;
    public static final int ACCTTYPE_V_Liability = 2;
    public static final int ACCTTYPE_V_Liability_Services = 3;
    public static final int ACCTTYPE_C_Receivable_Services = 4;
    public static final int ACCTTYPE_UnallocatedCash = 10;
    public static final int ACCTTYPE_BankInTransit = 11;
    public static final int ACCTTYPE_PaymentSelect = 12;
    public static final int ACCTTYPE_C_Prepayment = 13;
    public static final int ACCTTYPE_V_Prepayment = 14;
    public static final int ACCTTYPE_CashAsset = 20;
    public static final int ACCTTYPE_CashTransfer = 21;
    public static final int ACCTTYPE_CashExpense = 22;
    public static final int ACCTTYPE_CashReceipt = 23;
    public static final int ACCTTYPE_CashDifference = 24;
    public static final int ACCTTYPE_DiscountExp = 30;
    public static final int ACCTTYPE_DiscountRev = 31;
    public static final int ACCTTYPE_WriteOff = 32;
    public static final int ACCTTYPE_BankAsset = 40;
    public static final int ACCTTYPE_InterestRev = 41;
    public static final int ACCTTYPE_InterestExp = 42;
    public static final int ACCTTYPE_InvDifferences = 50;
    public static final int ACCTTYPE_NotInvoicedReceipts = 51;
    public static final int ACCTTYPE_ProjectAsset = 61;
    public static final int ACCTTYPE_ProjectWIP = 62;
    public static final int ACCTTYPE_PPVOffset = 101;
    public static final int ACCTTYPE_CommitmentOffset = 111;
    public static final int ACCTTYPE_CommitmentOffsetSales = 112;

    public static Doc get(MAcctSchema as, int AD_Table_ID, int Record_ID, String trxName) {
        return DocManager.getDocument(as, AD_Table_ID, Record_ID, trxName);
    }

    public static Doc get(MAcctSchema as, int AD_Table_ID, ResultSet rs, String trxName) {
        return DocManager.getDocument(as, AD_Table_ID, rs, trxName);
    }

    public static String postImmediate(MAcctSchema[] ass, int AD_Table_ID, int Record_ID, boolean force, String trxName) {
        return DocManager.postDocument(ass, AD_Table_ID, Record_ID, force, true, trxName);
    }

    public static String manualPosting(int WindowNo, int AD_Client_ID, int AD_Table_ID, int Record_ID, boolean force) {
        String error = null;
        MAcctSchema[] ass = MAcctSchema.getClientAcctSchema(Env.getCtx(), AD_Client_ID);
        trx.setDisplayName(Doc.class.getName() + "_manualPosting");
        try (Trx trx = Trx.get(Trx.createTrxName("ManulPosting"), true);){
            try {
                int n;
                int n2;
                PO[] pOArray;
                if (AD_Table_ID == 319) {
                    MMatchPO[] matchPos = MMatchPO.getInOut(Env.getCtx(), Record_ID, trx.getTrxName());
                    pOArray = matchPos;
                    n2 = matchPos.length;
                    n = 0;
                    while (n < n2) {
                        MMatchPO matchPo = pOArray[n];
                        if (!matchPo.isPosted() && !Util.isEmpty(error = Doc.postImmediate(ass, matchPo.get_Table_ID(), matchPo.get_ID(), force, matchPo.get_TrxName()))) break;
                        ++n;
                    }
                }
                if (Util.isEmpty(error)) {
                    error = Doc.postImmediate(ass, AD_Table_ID, Record_ID, force, trx.getTrxName());
                }
                if (Util.isEmpty(error) && AD_Table_ID == 318) {
                    MMatchInv[] matchInvs = MMatchInv.getInvoice(Env.getCtx(), Record_ID, trx.getTrxName());
                    pOArray = matchInvs;
                    n2 = matchInvs.length;
                    n = 0;
                    while (n < n2) {
                        PO matchInv = pOArray[n];
                        if (!((X_M_MatchInv)matchInv).isPosted() && !Util.isEmpty(error = Doc.postImmediate(ass, matchInv.get_Table_ID(), matchInv.get_ID(), force, matchInv.get_TrxName()))) break;
                        ++n;
                    }
                }
                if (Util.isEmpty(error)) {
                    trx.commit(true);
                } else {
                    trx.rollback();
                }
            }
            catch (Throwable t) {
                SQLException sqlEx;
                String messageError;
                trx.rollback();
                if (t instanceof SQLException && (messageError = DBException.getDefaultDBExceptionMessage(sqlEx = (SQLException)t)) != null) {
                    String string = Msg.getMsg(Env.getCtx(), messageError);
                    trx.close();
                    return string;
                }
                String string = "@Error@ " + t.getLocalizedMessage();
                trx.close();
                return string;
            }
        }
        return error;
    }

    public Doc(MAcctSchema as, Class<?> clazz, ResultSet rs, String defaultDocumentType, String trxName) {
        this.m_as = as;
        this.m_ctx = new Properties(this.m_as.getCtx());
        this.m_ctx.setProperty("#AD_Client_ID", String.valueOf(this.m_as.getAD_Client_ID()));
        String className = clazz.getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        try {
            Constructor<?> constructor = clazz.getConstructor(Properties.class, ResultSet.class, String.class);
            this.p_po = (PO)constructor.newInstance(this.m_ctx, rs, trxName);
        }
        catch (Exception e) {
            String msg = className + ": " + e.getLocalizedMessage();
            this.log.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        this.p_po.load(this.p_po.get_TrxName(), new String[0]);
        int index = this.p_po.get_ColumnIndex("DocStatus");
        if (index != -1) {
            this.m_DocStatus = (String)this.p_po.get_Value(index);
        }
        this.setDocumentType(defaultDocumentType);
        this.m_trxName = trxName;
        this.m_manageLocalTrx = false;
        if (this.m_trxName == null) {
            this.m_trxName = "Post" + this.m_DocumentType + this.p_po.get_ID();
            this.m_manageLocalTrx = true;
        }
        this.p_po.set_TrxName(this.m_trxName);
        int i2 = 0;
        while (i2 < this.m_Amounts.length) {
            this.m_Amounts[i2] = Env.ZERO;
            ++i2;
        }
    }

    public String getPostStatus() {
        return this.p_Status;
    }

    public Properties getCtx() {
        return this.m_ctx;
    }

    public String get_TableName() {
        return this.p_po.get_TableName();
    }

    public int get_Table_ID() {
        return this.p_po.get_Table_ID();
    }

    public int get_ID() {
        return this.p_po.get_ID();
    }

    public PO getPO() {
        return this.p_po;
    }

    public final String post(boolean force, boolean repost) {
        if (!(this.m_DocStatus == null || this.m_DocStatus.equals("CO") || this.m_DocStatus.equals("CL") || this.m_DocStatus.equals("VO") || this.m_DocStatus.equals("RE"))) {
            StringBuilder msgreturn = new StringBuilder("Invalid DocStatus='").append(this.m_DocStatus).append("' for DocumentNo=").append(this.getDocumentNo());
            return msgreturn.toString();
        }
        if (this.p_po.getAD_Client_ID() != this.m_as.getAD_Client_ID()) {
            StringBuilder error = new StringBuilder("AD_Client_ID Conflict - Document=").append(this.p_po.getAD_Client_ID()).append(", AcctSchema=").append(this.m_as.getAD_Client_ID());
            this.log.severe(error.toString());
            return error.toString();
        }
        String trxName = null;
        if (!this.m_manageLocalTrx) {
            trxName = this.getTrxName();
        }
        StringBuilder sql = new StringBuilder("UPDATE ");
        sql.append(this.get_TableName()).append(" SET Processing='Y' WHERE ").append(this.get_TableName()).append("_ID=").append(this.get_ID()).append(" AND Processed='Y' AND IsActive='Y'");
        if (!force) {
            sql.append(" AND (Processing='N' OR Processing IS NULL)");
        }
        if (!repost) {
            sql.append(" AND Posted IN ('N','d')");
        }
        if (DB.executeUpdate(sql.toString(), trxName) == 1) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Locked: " + this.get_TableName() + "_ID=" + this.get_ID());
            }
        } else {
            this.log.log(Level.SEVERE, "Resubmit - Cannot lock " + this.get_TableName() + "_ID=" + this.get_ID() + ", Force=" + force + ",RePost=" + repost);
            if (!this.p_po.isActive()) {
                return Msg.translate(this.getCtx(), "CannotPostInactiveDocument");
            }
            if (force) {
                return Msg.translate(this.getCtx(), "CannotLockReSubmit");
            }
            return Msg.translate(this.getCtx(), "CannotLockReSubmitOrRePostWithForce");
        }
        this.p_Error = this.loadDocumentDetails();
        if (this.p_Error != null) {
            return this.p_Error;
        }
        if (this.isDeferPosting()) {
            this.unlock();
            this.p_Status = STATUS_Deferred;
            return null;
        }
        Trx trx = Trx.get(this.getTrxName(), true);
        if (repost) {
            if (this.isPosted() && !this.isPeriodOpen()) {
                this.log.log(Level.SEVERE, this.toString() + " - Period Closed for already posed document");
                this.unlock();
                trx.commit();
                trx.close();
                return "PeriodClosed";
            }
            this.deleteAcct();
        } else if (this.isPosted()) {
            this.log.log(Level.SEVERE, this.toString() + " - Document already posted");
            this.unlock();
            trx.commit();
            trx.close();
            return "AlreadyPosted";
        }
        this.p_Status = STATUS_NotPosted;
        this.m_fact = new ArrayList();
        this.getPO().setDoc(this);
        try {
            boolean skip = false;
            if (this.m_as.getAD_OrgOnly_ID() != 0) {
                skip = this.m_as.isSkipOrg(this.getAD_Org_ID());
                if (this.p_lines != null) {
                    int line = 0;
                    while (skip && line < this.p_lines.length) {
                        skip = this.m_as.isSkipOrg(this.p_lines[line].getAD_Org_ID());
                        if (!skip) break;
                        ++line;
                    }
                }
            }
            this.p_Status = !skip ? this.postLogic() : STATUS_Posted;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
            this.p_Status = STATUS_Error;
            this.p_Error = e.toString();
        }
        String validatorMsg = null;
        if (this.p_Status.equals(STATUS_Posted) && (validatorMsg = ModelValidationEngine.get().fireDocValidate(this.getPO(), 15)) != null) {
            this.p_Status = STATUS_Error;
            this.p_Error = validatorMsg;
        }
        this.p_Status = this.postCommit(this.p_Status);
        if (this.p_Status.equals(STATUS_Posted) && (validatorMsg = ModelValidationEngine.get().fireDocValidate(this.getPO(), 16)) != null) {
            this.p_Status = STATUS_Error;
            this.p_Error = validatorMsg;
        }
        if (!this.p_Status.equals(STATUS_Posted) && !this.p_Status.equals(STATUS_Deferred)) {
            StringBuilder Text2;
            block30: {
                SimpleDateFormat dateFormat = DisplayType.getDateFormat(15);
                DecimalFormat numberFormat = DisplayType.getNumberFormat(12);
                String AD_MessageValue = "PostingError-" + this.p_Status;
                int AD_User_ID = this.p_po.getUpdatedBy();
                MNote note = new MNote(this.getCtx(), AD_MessageValue, AD_User_ID, this.getAD_Client_ID(), this.getAD_Org_ID(), null);
                note.setRecord(this.p_po.get_Table_ID(), this.p_po.get_ID());
                note.setReference(this.toString());
                Text2 = new StringBuilder(Msg.getMsg(Env.getCtx(), AD_MessageValue));
                if (this.p_Error != null) {
                    Text2.append(" (").append(this.p_Error).append(")");
                }
                String cn = this.getClass().getName();
                Text2.append(" - ").append(cn.substring(cn.lastIndexOf(46))).append(" (").append(this.getDocumentType()).append(" - " + Msg.getElement(Env.getCtx(), "DocumentNo") + "=").append(this.getDocumentNo()).append(" - " + Msg.getElement(Env.getCtx(), "DateAcct") + "=").append(dateFormat.format(this.getDateAcct())).append(" - " + Msg.getMsg(Env.getCtx(), "Amount") + "=").append(numberFormat.format(this.getAmount())).append(" - " + Msg.getElement(Env.getCtx(), "DocStatus") + "=").append(MRefList.getListName(this.getCtx(), 131, this.m_DocStatus)).append(" - " + Msg.getMsg(Env.getCtx(), "PeriodOpen") + "=").append(Msg.getMsg(Env.getCtx(), String.valueOf(this.isPeriodOpen()))).append(" - " + Msg.getElement(Env.getCtx(), "IsBalanced") + "=").append(Msg.getMsg(Env.getCtx(), String.valueOf(this.isBalanced()))).append(" - " + Msg.getElement(Env.getCtx(), "C_AcctSchema_ID") + "=").append(this.m_as.getName());
                note.setTextMsg(Text2.toString());
                try {
                    note.saveEx();
                }
                catch (AdempiereException e) {
                    if (e.getMessage() != null && e.getMessage().startsWith("Foreign ID " + this.p_po.get_ID() + " not found in ")) break block30;
                    throw e;
                }
            }
            this.p_Error = Text2.toString();
        }
        int i2 = 0;
        while (i2 < this.m_fact.size()) {
            Fact fact = this.m_fact.get(i2);
            if (fact != null) {
                fact.dispose();
            }
            ++i2;
        }
        this.p_lines = null;
        if (this.p_Status.equals(STATUS_Posted)) {
            return null;
        }
        return this.p_Error;
    }

    protected int deleteAcct() {
        StringBuilder sql = new StringBuilder("DELETE FROM Fact_Acct WHERE AD_Table_ID=").append(this.get_Table_ID()).append(" AND Record_ID=").append(this.p_po.get_ID()).append(" AND C_AcctSchema_ID=").append(this.m_as.getC_AcctSchema_ID());
        int no = DB.executeUpdate(sql.toString(), this.getTrxName());
        if (no != 0 && this.log.isLoggable(Level.INFO)) {
            this.log.info("deleted=" + no);
        }
        return no;
    }

    private final String postLogic() {
        if (!this.m_as.isSuspenseBalancing() && !this.isBalanced()) {
            return STATUS_NotBalanced;
        }
        if (!this.isConvertible(this.m_as)) {
            return STATUS_NotConvertible;
        }
        if (!this.isPeriodOpen()) {
            return STATUS_PeriodClosed;
        }
        ArrayList<Fact> facts = this.createFacts(this.m_as);
        if (facts == null) {
            return STATUS_Error;
        }
        String validatorMsg = ModelValidationEngine.get().fireFactsValidate(this.m_as, facts, this.getPO());
        if (validatorMsg != null) {
            this.p_Error = validatorMsg;
            return STATUS_Error;
        }
        int f = 0;
        while (f < facts.size()) {
            Fact fact = facts.get(f);
            if (fact == null) {
                return STATUS_Error;
            }
            this.m_fact.add(fact);
            this.p_Status = STATUS_PostPrepared;
            if (!fact.checkAccounts()) {
                return STATUS_InvalidAccount;
            }
            if (!fact.distribute()) {
                return STATUS_Error;
            }
            if (!fact.isSourceBalanced()) {
                fact.balanceSource();
                if (!fact.isSourceBalanced()) {
                    return STATUS_NotBalanced;
                }
            }
            if (!fact.isSegmentBalanced()) {
                fact.balanceSegments();
                if (!fact.isSegmentBalanced()) {
                    return STATUS_NotBalanced;
                }
            }
            if (!fact.isAcctBalanced()) {
                fact.balanceAccounting();
                if (!fact.isAcctBalanced()) {
                    return STATUS_NotBalanced;
                }
            }
            ++f;
        }
        return STATUS_Posted;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String postCommit(String status) {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Sta=" + status + " DT=" + this.getDocumentType() + " ID=" + this.p_po.get_ID());
        }
        this.p_Status = status;
        Trx trx = Trx.get(this.getTrxName(), true);
        try {
            if (status.equals(STATUS_Posted)) {
                int i2 = 0;
                while (i2 < this.m_fact.size()) {
                    Fact fact = this.m_fact.get(i2);
                    if (fact != null && !fact.save(this.getTrxName())) {
                        this.log.log(Level.SEVERE, "(fact not saved) ... rolling back");
                        if (this.m_manageLocalTrx) {
                            trx.rollback();
                            trx.close();
                        }
                        this.unlock();
                        return STATUS_Error;
                    }
                    ++i2;
                }
            }
            this.unlock();
            if (this.m_manageLocalTrx) {
                trx.commit(true);
                trx.close();
                trx = null;
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "... rolling back", e);
            status = STATUS_Error;
            if (this.m_manageLocalTrx) {
                try {
                    if (trx != null) {
                        trx.rollback();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (trx != null) {
                        trx.close();
                    }
                    trx = null;
                }
                catch (Exception exception) {}
            }
            this.unlock();
        }
        this.p_Status = status;
        return status;
    }

    public String getTrxName() {
        return this.m_trxName;
    }

    private void unlock() {
        String trxName = null;
        if (!this.m_manageLocalTrx) {
            trxName = this.getTrxName();
        }
        StringBuilder sql = new StringBuilder("UPDATE ");
        sql.append(this.get_TableName()).append(" SET Processing='N' WHERE ").append(this.get_TableName()).append("_ID=").append(this.p_po.get_ID());
        DB.executeUpdate(sql.toString(), trxName);
    }

    public String getDocumentType() {
        if (this.m_DocumentType == null) {
            this.setDocumentType(null);
        }
        return this.m_DocumentType;
    }

    public void setDocumentType(String DocumentType2) {
        block27: {
            ResultSet rsDT;
            CPreparedStatement pstmt;
            String sql;
            block25: {
                block23: {
                    if (DocumentType2 != null) {
                        this.m_DocumentType = DocumentType2;
                    }
                    if (this.p_po.get_ColumnIndex("C_DocType_ID") >= 0 && this.getC_DocType_ID() != 0) {
                        sql = "SELECT DocBaseType, GL_Category_ID FROM C_DocType WHERE C_DocType_ID=?";
                        pstmt = null;
                        rsDT = null;
                        try {
                            try {
                                pstmt = DB.prepareStatement(sql, null);
                                pstmt.setInt(1, this.getC_DocType_ID());
                                rsDT = pstmt.executeQuery();
                                if (rsDT.next()) {
                                    this.m_DocumentType = rsDT.getString(1);
                                    this.m_GL_Category_ID = rsDT.getInt(2);
                                }
                            }
                            catch (SQLException e) {
                                this.log.log(Level.SEVERE, sql, e);
                                DB.close(rsDT, pstmt);
                                rsDT = null;
                                pstmt = null;
                                break block23;
                            }
                        }
                        catch (Throwable throwable) {
                            DB.close(rsDT, pstmt);
                            rsDT = null;
                            pstmt = null;
                            throw throwable;
                        }
                        DB.close(rsDT, pstmt);
                        rsDT = null;
                        pstmt = null;
                    }
                }
                if (this.m_DocumentType == null) {
                    this.log.log(Level.SEVERE, "No DocBaseType for C_DocType_ID=" + this.getC_DocType_ID() + ", DocumentNo=" + this.getDocumentNo());
                }
                if (this.m_GL_Category_ID == 0) {
                    sql = "SELECT GL_Category_ID FROM C_DocType WHERE AD_Client_ID=? AND DocBaseType=?";
                    pstmt = null;
                    rsDT = null;
                    try {
                        try {
                            pstmt = DB.prepareStatement(sql.toString(), null);
                            pstmt.setInt(1, this.getAD_Client_ID());
                            pstmt.setString(2, this.m_DocumentType);
                            rsDT = pstmt.executeQuery();
                            if (rsDT.next()) {
                                this.m_GL_Category_ID = rsDT.getInt(1);
                            }
                        }
                        catch (SQLException e) {
                            this.log.log(Level.SEVERE, sql, e);
                            DB.close(rsDT, pstmt);
                            rsDT = null;
                            pstmt = null;
                            break block25;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rsDT, pstmt);
                        rsDT = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close(rsDT, pstmt);
                    rsDT = null;
                    pstmt = null;
                }
            }
            if (this.m_GL_Category_ID == 0) {
                sql = "SELECT GL_Category_ID FROM GL_Category WHERE AD_Client_ID=? ORDER BY IsDefault DESC";
                pstmt = null;
                rsDT = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, null);
                        pstmt.setInt(1, this.getAD_Client_ID());
                        rsDT = pstmt.executeQuery();
                        if (rsDT.next()) {
                            this.m_GL_Category_ID = rsDT.getInt(1);
                        }
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, sql, e);
                        DB.close(rsDT, pstmt);
                        rsDT = null;
                        pstmt = null;
                        break block27;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rsDT, pstmt);
                    rsDT = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rsDT, pstmt);
                rsDT = null;
                Object var3_3 = null;
            }
        }
        if (this.m_GL_Category_ID == 0) {
            this.log.log(Level.SEVERE, "No default GL_Category - " + this.toString());
        }
        if (this.m_DocumentType == null) {
            throw new IllegalStateException("Document Type not found");
        }
    }

    public boolean isBalanced() {
        boolean retValue;
        if (this.isMultiCurrency()) {
            return true;
        }
        boolean bl = retValue = this.getBalance().signum() == 0;
        if (retValue) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Yes " + this.toString());
            }
        } else {
            this.log.warning("NO - " + this.toString());
        }
        return retValue;
    }

    public boolean isConvertible(MAcctSchema acctSchema) {
        if (this.getC_Currency_ID() == -2) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("(none) - " + this.toString());
            }
            return true;
        }
        if (this instanceof Doc_GLJournal) {
            int glj_as = (Integer)this.p_po.get_Value("C_AcctSchema_ID");
            if (acctSchema.getC_AcctSchema_ID() != glj_as) {
                return true;
            }
        }
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(this.getC_Currency_ID());
        int i2 = 0;
        while (this.p_lines != null && i2 < this.p_lines.length) {
            int C_Currency_ID = this.p_lines[i2].getC_Currency_ID();
            if (C_Currency_ID != -2) {
                set.add(C_Currency_ID);
            }
            ++i2;
        }
        if (set.size() == 1 && acctSchema.getC_Currency_ID() == this.getC_Currency_ID()) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("(same) Cur=" + this.getC_Currency_ID() + " - " + this.toString());
            }
            return true;
        }
        boolean convertible = true;
        Iterator it = set.iterator();
        while (it.hasNext() && convertible) {
            int C_Currency_ID = (Integer)it.next();
            if (C_Currency_ID == acctSchema.getC_Currency_ID()) continue;
            BigDecimal amt = MConversionRate.getRate(C_Currency_ID, acctSchema.getC_Currency_ID(), this.getDateAcct(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
            if (amt == null) {
                convertible = false;
                this.log.warning("NOT from C_Currency_ID=" + C_Currency_ID + " to " + acctSchema.getC_Currency_ID() + " - " + this.toString());
                continue;
            }
            if (!this.log.isLoggable(Level.FINE)) continue;
            this.log.fine("From C_Currency_ID=" + C_Currency_ID);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Convertible=" + convertible + ", AcctSchema C_Currency_ID=" + acctSchema.getC_Currency_ID() + " - " + this.toString());
        }
        return convertible;
    }

    public void setPeriod() {
        Integer ii;
        if (this.m_period != null) {
            return;
        }
        int index = this.p_po.get_ColumnIndex("C_Period_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            this.m_period = MPeriod.get(this.getCtx(), ii);
        }
        if (this.m_period == null) {
            this.m_period = MPeriod.get(this.getCtx(), this.getDateAcct(), this.getAD_Org_ID(), null);
        }
        this.m_C_Period_ID = this.m_period != null && this.m_period.isOpen(this.getDocumentType(), this.getDateAcct(), true) ? this.m_period.getC_Period_ID() : -1;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(this.getDateAcct()) + " - " + this.getDocumentType() + " => " + this.m_C_Period_ID);
        }
    }

    public int getC_Period_ID() {
        if (this.m_period == null) {
            this.setPeriod();
        }
        return this.m_C_Period_ID;
    }

    public boolean isPeriodOpen() {
        boolean open;
        this.setPeriod();
        boolean bl = open = this.m_C_Period_ID > 0;
        if (open) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Yes - " + this.toString());
            }
        } else {
            this.log.warning("NO - " + this.toString());
        }
        return open;
    }

    public BigDecimal getAmount(int AmtType) {
        if (AmtType < 0 || AmtType >= this.m_Amounts.length) {
            return null;
        }
        return this.m_Amounts[AmtType];
    }

    public void setAmount(int AmtType, BigDecimal amt) {
        if (AmtType < 0 || AmtType >= this.m_Amounts.length) {
            return;
        }
        this.m_Amounts[AmtType] = amt == null ? Env.ZERO : amt;
    }

    public BigDecimal getAmount() {
        return this.m_Amounts[0];
    }

    public void setQty(BigDecimal qty) {
        this.m_qty = qty;
    }

    public BigDecimal getQty() {
        if (this.m_qty == null) {
            int index = this.p_po.get_ColumnIndex("Qty");
            this.m_qty = index != -1 ? (BigDecimal)this.p_po.get_Value(index) : Env.ZERO;
        }
        return this.m_qty;
    }

    public int getValidCombination_ID(int AcctType, MAcctSchema as) {
        int para_1 = 0;
        String sql = null;
        if (AcctType == 0) {
            int cmp = this.getAmount(2).compareTo(Env.ZERO);
            if (cmp == 0) {
                return 0;
            }
            sql = "SELECT CH_Expense_Acct FROM C_Charge_Acct WHERE C_Charge_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_Charge_ID();
        } else if (AcctType == 2) {
            sql = "SELECT V_Liability_Acct FROM C_BP_Vendor_Acct WHERE C_BPartner_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BPartner_ID();
        } else if (AcctType == 3) {
            sql = "SELECT V_Liability_Services_Acct FROM C_BP_Vendor_Acct WHERE C_BPartner_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BPartner_ID();
        } else if (AcctType == 1) {
            sql = "SELECT C_Receivable_Acct FROM C_BP_Customer_Acct WHERE C_BPartner_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BPartner_ID();
        } else if (AcctType == 4) {
            sql = "SELECT C_Receivable_Services_Acct FROM C_BP_Customer_Acct WHERE C_BPartner_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BPartner_ID();
        } else if (AcctType == 14) {
            sql = "SELECT V_Prepayment_Acct FROM C_BP_Vendor_Acct WHERE C_BPartner_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BPartner_ID();
        } else if (AcctType == 13) {
            sql = "SELECT C_Prepayment_Acct FROM C_BP_Customer_Acct WHERE C_BPartner_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BPartner_ID();
        } else if (AcctType == 10) {
            sql = "SELECT B_UnallocatedCash_Acct FROM C_BankAccount_Acct WHERE C_BankAccount_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BankAccount_ID();
        } else if (AcctType == 11) {
            sql = "SELECT B_InTransit_Acct FROM C_BankAccount_Acct WHERE C_BankAccount_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BankAccount_ID();
        } else if (AcctType == 12) {
            sql = "SELECT B_PaymentSelect_Acct FROM C_BankAccount_Acct WHERE C_BankAccount_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BankAccount_ID();
        } else if (AcctType == 30) {
            sql = "SELECT a.PayDiscount_Exp_Acct FROM C_BP_Group_Acct a, C_BPartner bp WHERE a.C_BP_Group_ID=bp.C_BP_Group_ID AND bp.C_BPartner_ID=? AND a.C_AcctSchema_ID=?";
            para_1 = this.getC_BPartner_ID();
        } else if (AcctType == 31) {
            sql = "SELECT PayDiscount_Rev_Acct FROM C_BP_Group_Acct a, C_BPartner bp WHERE a.C_BP_Group_ID=bp.C_BP_Group_ID AND bp.C_BPartner_ID=? AND a.C_AcctSchema_ID=?";
            para_1 = this.getC_BPartner_ID();
        } else if (AcctType == 32) {
            sql = "SELECT WriteOff_Acct FROM C_BP_Group_Acct a, C_BPartner bp WHERE a.C_BP_Group_ID=bp.C_BP_Group_ID AND bp.C_BPartner_ID=? AND a.C_AcctSchema_ID=?";
            para_1 = this.getC_BPartner_ID();
        } else if (AcctType == 40) {
            sql = "SELECT B_Asset_Acct FROM C_BankAccount_Acct WHERE C_BankAccount_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BankAccount_ID();
        } else if (AcctType == 41) {
            sql = "SELECT B_InterestRev_Acct FROM C_BankAccount_Acct WHERE C_BankAccount_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BankAccount_ID();
        } else if (AcctType == 42) {
            sql = "SELECT B_InterestExp_Acct FROM C_BankAccount_Acct WHERE C_BankAccount_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BankAccount_ID();
        } else if (AcctType == 20) {
            sql = "SELECT CB_Asset_Acct FROM C_CashBook_Acct WHERE C_CashBook_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_CashBook_ID();
        } else if (AcctType == 21) {
            sql = "SELECT CB_CashTransfer_Acct FROM C_CashBook_Acct WHERE C_CashBook_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_CashBook_ID();
        } else if (AcctType == 22) {
            sql = "SELECT CB_Expense_Acct FROM C_CashBook_Acct WHERE C_CashBook_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_CashBook_ID();
        } else if (AcctType == 23) {
            sql = "SELECT CB_Receipt_Acct FROM C_CashBook_Acct WHERE C_CashBook_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_CashBook_ID();
        } else if (AcctType == 24) {
            sql = "SELECT CB_Differences_Acct FROM C_CashBook_Acct WHERE C_CashBook_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_CashBook_ID();
        } else if (AcctType == 50) {
            sql = "SELECT W_Differences_Acct FROM M_Warehouse_Acct WHERE M_Warehouse_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getM_Warehouse_ID();
        } else if (AcctType == 51) {
            sql = "SELECT NotInvoicedReceipts_Acct FROM C_BP_Group_Acct a, C_BPartner bp WHERE a.C_BP_Group_ID=bp.C_BP_Group_ID AND bp.C_BPartner_ID=? AND a.C_AcctSchema_ID=?";
            para_1 = this.getC_BPartner_ID();
        } else if (AcctType == 61) {
            sql = "SELECT PJ_Asset_Acct FROM C_Project_Acct WHERE C_Project_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_Project_ID();
        } else if (AcctType == 62) {
            sql = "SELECT PJ_WIP_Acct FROM C_Project_Acct WHERE C_Project_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_Project_ID();
        } else if (AcctType == 101) {
            sql = "SELECT PPVOffset_Acct FROM C_AcctSchema_GL WHERE C_AcctSchema_ID=?";
            para_1 = -1;
        } else if (AcctType == 111) {
            sql = "SELECT CommitmentOffset_Acct FROM C_AcctSchema_GL WHERE C_AcctSchema_ID=?";
            para_1 = -1;
        } else if (AcctType == 112) {
            sql = "SELECT CommitmentOffsetSales_Acct FROM C_AcctSchema_GL WHERE C_AcctSchema_ID=?";
            para_1 = -1;
        } else {
            this.log.warning("Not found AcctType=" + AcctType);
            return 0;
        }
        if (sql == null || para_1 == 0) {
            this.log.warning("No Parameter for AcctType=" + AcctType + " - SQL=" + sql);
            return 0;
        }
        int Account_ID = 0;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, this.getTrxName());
                if (para_1 == -1) {
                    pstmt.setInt(1, as.getC_AcctSchema_ID());
                } else {
                    pstmt.setInt(1, para_1);
                    pstmt.setInt(2, as.getC_AcctSchema_ID());
                }
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    Account_ID = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, "AcctType=" + AcctType + " - SQL=" + sql, e);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return 0;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (Account_ID == 0) {
            this.log.warning("NO account Type=" + AcctType + ", Record=" + this.p_po.get_ID());
            return 0;
        }
        return Account_ID;
    }

    public final MAccount getAccount(int AcctType, MAcctSchema as) {
        int C_ValidCombination_ID = this.getValidCombination_ID(AcctType, as);
        if (C_ValidCombination_ID == 0) {
            return null;
        }
        MAccount acct = MAccount.get(as.getCtx(), C_ValidCombination_ID);
        return acct;
    }

    public DocLine getDocLine(int Record_ID) {
        if (this.p_lines == null || this.p_lines.length == 0 || Record_ID == 0) {
            return null;
        }
        int i2 = 0;
        while (i2 < this.p_lines.length) {
            if (this.p_lines[i2].get_ID() == Record_ID) {
                return this.p_lines[i2];
            }
            ++i2;
        }
        return null;
    }

    public String toString() {
        return this.p_po.toString();
    }

    public int getAD_Client_ID() {
        return this.p_po.getAD_Client_ID();
    }

    public int getAD_Org_ID() {
        return this.p_po.getAD_Org_ID();
    }

    public String getDocumentNo() {
        if (this.m_DocumentNo != null) {
            return this.m_DocumentNo;
        }
        int index = this.p_po.get_ColumnIndex("DocumentNo");
        if (index == -1) {
            index = this.p_po.get_ColumnIndex("Name");
        }
        if (index == -1) {
            throw new UnsupportedOperationException("No DocumentNo");
        }
        this.m_DocumentNo = (String)this.p_po.get_Value(index);
        return this.m_DocumentNo;
    }

    public String getDescription() {
        if (this.m_Description == null) {
            int index = this.p_po.get_ColumnIndex("Description");
            this.m_Description = index != -1 ? (String)this.p_po.get_Value(index) : "";
        }
        return this.m_Description;
    }

    public int getC_Currency_ID() {
        if (this.m_C_Currency_ID == -1) {
            Integer ii;
            int index = this.p_po.get_ColumnIndex("C_Currency_ID");
            if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
                this.m_C_Currency_ID = ii;
            }
            if (this.m_C_Currency_ID == -1) {
                this.m_C_Currency_ID = -2;
            }
        }
        return this.m_C_Currency_ID;
    }

    public void setC_Currency_ID(int C_Currency_ID) {
        this.m_C_Currency_ID = C_Currency_ID;
    }

    public boolean isMultiCurrency() {
        return this.m_MultiCurrency;
    }

    public void setIsMultiCurrency(boolean mc) {
        this.m_MultiCurrency = mc;
    }

    public boolean isTaxIncluded() {
        return this.m_TaxIncluded;
    }

    public void setIsTaxIncluded(boolean ti) {
        this.m_TaxIncluded = ti;
    }

    public int getC_ConversionType_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_ConversionType_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public BigDecimal getCurrencyRate() {
        return null;
    }

    public int getGL_Category_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("GL_Category_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return this.m_GL_Category_ID;
    }

    public int getGL_Budget_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("GL_Budget_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public Timestamp getDateAcct() {
        if (this.m_DateAcct != null) {
            return this.m_DateAcct;
        }
        int index = this.p_po.get_ColumnIndex("DateAcct");
        if (index != -1) {
            this.m_DateAcct = (Timestamp)this.p_po.get_Value(index);
            if (this.m_DateAcct != null) {
                return this.m_DateAcct;
            }
        }
        throw new IllegalStateException("No DateAcct");
    }

    public void setDateAcct(Timestamp da) {
        this.m_DateAcct = da;
    }

    public Timestamp getDateDoc() {
        if (this.m_DateDoc != null) {
            return this.m_DateDoc;
        }
        int index = this.p_po.get_ColumnIndex("DateDoc");
        if (index == -1) {
            index = this.p_po.get_ColumnIndex("MovementDate");
        }
        if (index != -1) {
            this.m_DateDoc = (Timestamp)this.p_po.get_Value(index);
            if (this.m_DateDoc != null) {
                return this.m_DateDoc;
            }
        }
        throw new IllegalStateException("No DateDoc");
    }

    public void setDateDoc(Timestamp dd) {
        this.m_DateDoc = dd;
    }

    public boolean isPosted() {
        int index = this.p_po.get_ColumnIndex("Posted");
        if (index != -1) {
            Object posted = this.p_po.get_Value(index);
            if (posted instanceof Boolean) {
                return (Boolean)posted;
            }
            if (posted instanceof String) {
                return STATUS_Posted.equals(posted);
            }
        }
        throw new IllegalStateException("No Posted");
    }

    public boolean isSOTrx() {
        int index = this.p_po.get_ColumnIndex("IsSOTrx");
        if (index == -1) {
            index = this.p_po.get_ColumnIndex("IsReceipt");
        }
        if (index != -1) {
            Object posted = this.p_po.get_Value(index);
            if (posted instanceof Boolean) {
                return (Boolean)posted;
            }
            if (posted instanceof String) {
                return STATUS_Posted.equals(posted);
            }
        }
        return false;
    }

    public int getC_DocType_ID() {
        int docTypeId;
        int index = this.p_po.get_ColumnIndex("C_DocType_ID");
        if (index != -1) {
            Integer ii = (Integer)this.p_po.get_Value(index);
            if (ii != null && ii == 0 && (index = this.p_po.get_ColumnIndex("C_DocTypeTarget_ID")) != -1) {
                ii = (Integer)this.p_po.get_Value(index);
            }
            if (ii != null) {
                return ii;
            }
        } else if (this.p_po.get_TableName().equals("M_MatchPO")) {
            int docTypeId2 = DB.getSQLValue(null, DOC_TYPE_BY_DOC_BASE_TYPE_SQL, this.p_po.getAD_Client_ID(), DOCTYPE_MatMatchPO);
            if (docTypeId2 > 0) {
                return docTypeId2;
            }
        } else if (this.p_po.get_TableName().equals("M_MatchInv")) {
            int docTypeId3 = DB.getSQLValue(null, DOC_TYPE_BY_DOC_BASE_TYPE_SQL, this.p_po.getAD_Client_ID(), DOCTYPE_MatMatchInv);
            if (docTypeId3 > 0) {
                return docTypeId3;
            }
        } else if (this.p_po.get_TableName().equals("C_AllocationHdr")) {
            int docTypeId4 = DB.getSQLValue(null, DOC_TYPE_BY_DOC_BASE_TYPE_SQL, this.p_po.getAD_Client_ID(), DOCTYPE_Allocation);
            if (docTypeId4 > 0) {
                return docTypeId4;
            }
        } else if (this.p_po.get_TableName().equals("C_Cash")) {
            int docTypeId5 = DB.getSQLValue(null, DOC_TYPE_BY_DOC_BASE_TYPE_SQL, this.p_po.getAD_Client_ID(), DOCTYPE_CashJournal);
            if (docTypeId5 > 0) {
                return docTypeId5;
            }
        } else if (this.p_po.get_TableName().equals("C_ProjectIssue") && (docTypeId = DB.getSQLValue(null, DOC_TYPE_BY_DOC_BASE_TYPE_SQL, this.p_po.getAD_Client_ID(), DOCTYPE_ProjectIssue)) > 0) {
            return docTypeId;
        }
        return 0;
    }

    public int getC_Charge_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_Charge_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getSalesRep_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("SalesRep_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getC_BankAccount_ID() {
        if (this.m_C_BankAccount_ID == -1) {
            Integer ii;
            int index = this.p_po.get_ColumnIndex("C_BankAccount_ID");
            if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
                this.m_C_BankAccount_ID = ii;
            }
            if (this.m_C_BankAccount_ID == -1) {
                this.m_C_BankAccount_ID = 0;
            }
        }
        return this.m_C_BankAccount_ID;
    }

    public void setC_BankAccount_ID(int C_BankAccount_ID) {
        this.m_C_BankAccount_ID = C_BankAccount_ID;
    }

    public int getC_CashBook_ID() {
        if (this.m_C_CashBook_ID == -1) {
            Integer ii;
            int index = this.p_po.get_ColumnIndex("C_CashBook_ID");
            if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
                this.m_C_CashBook_ID = ii;
            }
            if (this.m_C_CashBook_ID == -1) {
                this.m_C_CashBook_ID = 0;
            }
        }
        return this.m_C_CashBook_ID;
    }

    public void setC_CashBook_ID(int C_CashBook_ID) {
        this.m_C_CashBook_ID = C_CashBook_ID;
    }

    public int getM_Warehouse_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("M_Warehouse_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getC_BPartner_ID() {
        if (this.m_C_BPartner_ID == -1) {
            Integer ii;
            int index = this.p_po.get_ColumnIndex("C_BPartner_ID");
            if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
                this.m_C_BPartner_ID = ii;
            }
            if (this.m_C_BPartner_ID == -1) {
                this.m_C_BPartner_ID = 0;
            }
        }
        return this.m_C_BPartner_ID;
    }

    public void setC_BPartner_ID(int C_BPartner_ID) {
        this.m_C_BPartner_ID = C_BPartner_ID;
    }

    public int getC_BPartner_Location_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_BPartner_Location_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getC_Project_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_Project_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getC_ProjectPhase_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_ProjectPhase_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getC_ProjectTask_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_ProjectTask_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getC_SalesRegion_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_SalesRegion_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getBP_C_SalesRegion_ID() {
        if (this.m_BP_C_SalesRegion_ID == -1) {
            Integer ii;
            int index = this.p_po.get_ColumnIndex("C_SalesRegion_ID");
            if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
                this.m_BP_C_SalesRegion_ID = ii;
            }
            if (this.m_BP_C_SalesRegion_ID == -1) {
                this.m_BP_C_SalesRegion_ID = 0;
            }
        }
        return this.m_BP_C_SalesRegion_ID;
    }

    public void setBP_C_SalesRegion_ID(int C_SalesRegion_ID) {
        this.m_BP_C_SalesRegion_ID = C_SalesRegion_ID;
    }

    public int getC_Activity_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_Activity_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getC_Campaign_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_Campaign_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getM_Product_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("M_Product_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getAD_OrgTrx_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("AD_OrgTrx_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getC_LocFrom_ID() {
        return this.m_C_LocFrom_ID;
    }

    public void setC_LocFrom_ID(int C_LocFrom_ID) {
        this.m_C_LocFrom_ID = C_LocFrom_ID;
    }

    public int getC_LocTo_ID() {
        return this.m_C_LocTo_ID;
    }

    public void setC_LocTo_ID(int C_LocTo_ID) {
        this.m_C_LocTo_ID = C_LocTo_ID;
    }

    public int getUser1_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("User1_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getUser2_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("User2_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getValue(String ColumnName) {
        Integer ii;
        int index = this.p_po.get_ColumnIndex(ColumnName);
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    protected abstract String loadDocumentDetails();

    public abstract BigDecimal getBalance();

    public abstract ArrayList<Fact> createFacts(MAcctSchema var1);

    public ArrayList<Fact> getFacts() {
        return this.m_fact;
    }

    protected MAcctSchema getAcctSchema() {
        return this.m_as;
    }

    public boolean isDeferPosting() {
        return false;
    }
}

