/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.html.HTMLs;
import org.zkoss.idom.Element;
import org.zkoss.idom.input.SAXBuilder;
import org.zkoss.idom.util.IDOMs;
import org.zkoss.io.Files;
import org.zkoss.json.JSONArray;
import org.zkoss.json.JSONObject;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Library;
import org.zkoss.lang.Strings;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.http.Encodes;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.web.util.resource.ClassWebResource;
import org.zkoss.web.util.resource.ExtendletConfig;
import org.zkoss.web.util.resource.ExtendletContext;
import org.zkoss.web.util.resource.ExtendletLoader;
import org.zkoss.xml.XMLs;
import org.zkoss.zk.device.Device;
import org.zkoss.zk.device.Devices;
import org.zkoss.zk.fn.JspFns;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zk.ui.http.AbstractExtendlet;
import org.zkoss.zk.ui.http.ScriptManager;
import org.zkoss.zk.ui.http.ScriptManagerImpl;
import org.zkoss.zk.ui.http.Utils;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.WidgetDefinition;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.URIInfo;

public class WpdExtendlet
extends AbstractExtendlet<Object> {
    public static final String SOURCE_MAP_JAVASCRIPT_PATH = "$zk$sourcemapJsPath";
    private static final String SOURCE_MAP_DIVIDED_WPDS = "$zk$dividedWPDs";
    private static final String SOURCE_MAP_DIVIDED_WPDS_NUMBER = "$zk$dividedWPDsNum";
    private ConcurrentMap<String, List<Element>> _dividedWpds = new ConcurrentHashMap<String, List<Element>>(1);
    private ConcurrentMap<String, Integer> _dividedPackageCnt = new ConcurrentHashMap<String, Integer>(1);
    private Set<String> _lastDynamicWpds = ConcurrentHashMap.newKeySet(1);

    public void init(ExtendletConfig config) {
        this.init(config, new WpdLoader());
        if (!this.isDebugJS()) {
            config.addCompressExtension("wpd");
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        byte[] bs;
        byte[] data = this.retrieve(request, response, path);
        if (data == null) {
            return;
        }
        response.setContentType("text/javascript;charset=UTF-8");
        if (this._webctx.shallCompress((ServletRequest)request, "wpd") && data.length > 200 && (bs = Https.gzip((HttpServletRequest)request, (HttpServletResponse)response, null, (byte[])data)) != null) {
            data = bs;
        }
        response.setContentLength(data.length);
        response.getOutputStream().write(data);
        response.flushBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] retrieve(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        boolean isNotModified;
        boolean cacheable;
        byte[] data;
        boolean retrievingLastContent;
        Object packagePartsCnt;
        String pkg = null;
        boolean sourceMapEnabled = this.sourceMapEnabled();
        if (((String)path).endsWith(".map")) {
            if (sourceMapEnabled) {
                InputStream resourceAsStream;
                if (((String)path).endsWith("js/index.js.map")) {
                    path = ((String)path).replace("js/index.js.map", "js/zk/index.js.map");
                }
                if ((resourceAsStream = this._webctx.getResourceAsStream((String)path)) != null) {
                    return resourceAsStream.readAllBytes();
                }
            }
            response.sendError(404, (String)path);
            return null;
        }
        String resourceCache = Library.getProperty((String)"org.zkoss.zk.WPD.cache");
        if (resourceCache != null && "false".equalsIgnoreCase(resourceCache)) {
            this._cache.clear();
        }
        if (sourceMapEnabled && !((String)path).endsWith("lang.wpd")) {
            boolean pkgStart = ((String)path).endsWith("0.wpd");
            boolean pkgEnd = ((String)path).endsWith("$.wpd");
            int lastPartIndex = ((String)path).lastIndexOf("/") + 1;
            String lastPart = ((String)path).substring(lastPartIndex);
            String pkgName = lastPart.replaceAll("[\\d]{1,2}\\.wpd", "");
            if (pkgStart || pkgEnd) {
                if (pkgStart) {
                    return ("(function(){zk._p=zkpi('" + pkgName + "');})()").getBytes();
                }
                return ("(function(){zk.setLoaded('" + lastPart.replace("$.wpd", "") + "');})()").getBytes();
            }
            List dividedElements = (List)this._dividedWpds.get(lastPart);
            if (dividedElements == null) {
                try {
                    byte[] dynamicContent = this.processDynamicWpdWithSourceMapIfAny(request, response, pkgName, (String)path);
                    if (dynamicContent != null) {
                        return dynamicContent;
                    }
                    dividedElements = (List)this._dividedWpds.get(lastPart);
                }
                catch (Exception e) {
                    log.error("fail to process source for source map", (Throwable)e);
                    return new byte[0];
                }
            }
            request.setAttribute(SOURCE_MAP_DIVIDED_WPDS, (Object)dividedElements);
            packagePartsCnt = (Integer)this._dividedPackageCnt.get(pkgName);
            if (packagePartsCnt != null && (Integer)packagePartsCnt >= 1) {
                int num = Integer.parseInt(lastPart.replace(pkgName, "").replace(".wpd", ""));
                request.setAttribute(SOURCE_MAP_DIVIDED_WPDS_NUMBER, (Object)num);
            }
            path = ((String)path).substring(0, lastPartIndex) + (String)(pkgName.endsWith("wpd") ? pkgName : pkgName + ".wpd");
        }
        Content content = (Content)this._cache.get(path);
        Content latestContent = null;
        boolean bl = retrievingLastContent = sourceMapEnabled && !(content._cnt instanceof SourceInfo);
        if (retrievingLastContent) {
            try {
                latestContent = (Content)this._cache.getLoader().load(path);
            }
            catch (Exception e) {
                log.error("Failed to load the resource: " + (String)path);
                throw new UiException("Failed to load the resource: " + (String)path, (Throwable)e);
            }
        }
        if (content == null || retrievingLastContent && latestContent == null) {
            if (Servlets.isIncluded((ServletRequest)request)) {
                log.error("Failed to load the resource: " + (String)path);
                throw new FileNotFoundException("Failed to load the resource: " + (String)path);
            }
            response.sendError(404, HTMLs.encodeJavaScript((String)XMLs.escapeXML((String)path)));
            return null;
        }
        AbstractExtendlet.RequestContext reqctx = new AbstractExtendlet.RequestContext(this, request, response);
        packagePartsCnt = content;
        synchronized (packagePartsCnt) {
            Object rawdata;
            Object object = sourceMapEnabled ? new Content((SourceInfo)(latestContent == null ? content : latestContent)._cnt).parse(reqctx) : (rawdata = content.parse(reqctx));
            if (rawdata instanceof ByteContent) {
                ByteContent bc = (ByteContent)rawdata;
                data = bc.content;
                cacheable = bc.cacheable;
            } else {
                WpdContent wc = (WpdContent)rawdata;
                data = wc.toByteArray(reqctx);
                pkg = wc.name;
                cacheable = wc.cacheable;
            }
        }
        if (cacheable && (isNotModified = JspFns.setCacheControl(this.getServletContext(), request, response, "org.zkoss.web.classWebResource.cache", 8760))) {
            return null;
        }
        return pkg != null && !sourceMapEnabled ? this.mergeJavaScript(request, response, pkg, data) : data;
    }

    protected String getDeviceType() {
        return "ajax";
    }

    protected byte[] mergeJavaScript(HttpServletRequest request, HttpServletResponse response, String pkgTo, byte[] data) throws ServletException, IOException {
        ByteArrayOutputStream out = null;
        Device device = null;
        String deviceType = this.getDeviceType();
        for (LanguageDefinition langdef : LanguageDefinition.getByDeviceType(deviceType)) {
            for (String pkg : langdef.getMergedJavaScriptPackages(pkgTo)) {
                String path;
                if (out == null) {
                    out = new ByteArrayOutputStream(102400);
                    out.write(data);
                    device = Devices.getDevice(deviceType);
                }
                if ((data = this.retrieve(request, response, path = device.packageToPath(pkg))) != null) {
                    out.write(data);
                    continue;
                }
                log.error("Failed to load the resource: " + path);
            }
        }
        return out != null ? out.toByteArray() : data;
    }

    private Object parse(AbstractExtendlet.RequestContext reqctx, InputStream is, String path) throws Exception {
        Integer totalPartialCount;
        Element root = new SAXBuilder(true, false, true).build(is).getRootElement();
        String name = IDOMs.getRequiredAttributeValue((Element)root, (String)"name");
        if (name.length() == 0) {
            throw new UiException("The name attribute must be specified, " + root.getLocator() + ", " + path);
        }
        boolean zk = "zk".equals(name);
        boolean aaas = "zk.aaas".equals(name);
        String lang = root.getAttributeValue("language");
        LanguageDefinition langdef = lang != null ? LanguageDefinition.lookup(lang) : null;
        String dir = path.substring(0, path.lastIndexOf(47) + 1);
        boolean cacheable = !"false".equals(root.getAttributeValue("cacheable"));
        WpdContent wc = zk || aaas || !cacheable || this.isWpdContentRequired(name, root) ? new WpdContent(name, dir, cacheable) : null;
        ByteArrayOutputStream out = new ByteArrayOutputStream(16384);
        String depends = null;
        List partialElements = (List)reqctx.request.getAttribute(SOURCE_MAP_DIVIDED_WPDS);
        boolean processingPartial = partialElements != null;
        Integer partialNum = (Integer)reqctx.request.getAttribute(SOURCE_MAP_DIVIDED_WPDS_NUMBER);
        if (partialNum == null) {
            partialNum = 0;
        }
        if ((totalPartialCount = (Integer)this._dividedPackageCnt.get(name)) == null) {
            totalPartialCount = 0;
        }
        if (zk) {
            if (!processingPartial) {
                this.write((OutputStream)out, "if(!window.zk){\n");
            }
        } else if (!aaas) {
            depends = root.getAttributeValue("depends");
            if (depends != null && depends.length() == 0) {
                depends = null;
            }
            if (depends != null) {
                this.write((OutputStream)out, "zk.load('");
                if (processingPartial && partialNum > 1 && totalPartialCount > 1) {
                    this.write((OutputStream)out, name + (partialNum - 1));
                } else {
                    this.write((OutputStream)out, depends);
                }
                this.write((OutputStream)out, "',");
            } else if (!processingPartial) {
                this.write((OutputStream)out, '(');
            }
            if (depends != null || !processingPartial) {
                this.write((OutputStream)out, "function(){");
                if (processingPartial && totalPartialCount > 1) {
                    String[] pkgs = name.split("\\.");
                    Object pkgParts = "";
                    int l = pkgs.length;
                    for (int i = 0; i < l - 1; ++i) {
                        pkgParts = (String)pkgParts + pkgs[i];
                        this.write((OutputStream)out, "if(!window." + (String)pkgParts + ")window." + (String)pkgParts + "={};");
                        pkgParts = (String)pkgParts + ".";
                    }
                    this.write((OutputStream)out, "if(!window." + name + ")window." + name + "={};");
                }
                this.write((OutputStream)out, "if(zk._p=zkpi('");
                if (processingPartial && totalPartialCount > 1) {
                    this.write((OutputStream)out, name + partialNum);
                } else {
                    this.write((OutputStream)out, name);
                }
                this.write((OutputStream)out, '\'');
                if (reqctx.getResource(dir + "wv/zk.wpd") != null) {
                    this.write((OutputStream)out, ",true");
                }
                this.write((OutputStream)out, "))try{\n");
            }
        }
        HashMap<String, String[]> moldInfos = new HashMap<String, String[]>();
        List elements = processingPartial ? partialElements : root.getElements();
        boolean processingSourceMapScript = false;
        for (Element el : elements) {
            String elnm = el.getName();
            if ("widget".equals(elnm)) {
                WidgetDefinition wgtdef;
                String jspath;
                String wgtnm = IDOMs.getRequiredAttributeValue((Element)el, (String)"name");
                boolean moldOnly = "true".equals(el.getAttributeValue("moldOnly"));
                if (!moldOnly && !this.writeResource(reqctx, out, jspath = wgtnm + ".js", dir, false)) {
                    log.error("Widget " + wgtnm + ": " + jspath + " not found, " + el.getLocator() + ", " + path);
                    continue;
                }
                String wgtflnm = name + "." + wgtnm;
                this.write((OutputStream)out, "zkreg('");
                this.write((OutputStream)out, wgtflnm);
                this.write((OutputStream)out, "'");
                WidgetDefinition widgetDefinition = wgtdef = langdef != null ? langdef.getWidgetDefinitionIfAny(wgtflnm) : null;
                if (wgtdef != null && wgtdef.isBlankPreserved()) {
                    this.write((OutputStream)out, ",true");
                }
                this.write((OutputStream)out, ");\n");
                if (wgtdef == null) continue;
                try {
                    boolean first = true;
                    for (String mold : wgtdef.getMoldNames()) {
                        String uri = wgtdef.getMoldURI(mold);
                        if (uri == null) continue;
                        if (first) {
                            first = false;
                            this.write((OutputStream)out, "zk._m={};\n");
                        }
                        this.write((OutputStream)out, "zk._m['");
                        this.write((OutputStream)out, mold);
                        this.write((OutputStream)out, "']=");
                        String[] info = (String[])moldInfos.get(uri);
                        if (info != null) {
                            this.write((OutputStream)out, "[");
                            this.write((OutputStream)out, name);
                            this.write((OutputStream)out, ".");
                            this.write((OutputStream)out, info[0]);
                            this.write((OutputStream)out, ",'");
                            this.write((OutputStream)out, info[1]);
                            this.write((OutputStream)out, "'];\n");
                            continue;
                        }
                        moldInfos.put(uri, new String[]{wgtnm, mold});
                        if (!this.writeResource(reqctx, out, uri, dir, true)) {
                            this.write((OutputStream)out, "zk.$void;zk.error('");
                            this.write((OutputStream)out, uri);
                            this.write((OutputStream)out, " not found')");
                            log.error("Failed to load mold " + mold + " for widget " + wgtflnm + ": " + uri + " not found");
                        }
                        this.write((OutputStream)out, ';');
                    }
                    if (first) continue;
                    this.write((OutputStream)out, "zkmld(");
                    if (zk) {
                        this.write((OutputStream)out, "zk.");
                    } else {
                        this.write((OutputStream)out, name);
                        this.write((OutputStream)out, ".");
                    }
                    this.write((OutputStream)out, wgtnm);
                    this.write((OutputStream)out, ",zk._m);\n");
                }
                catch (Throwable ex) {
                    log.error("Failed to load molds for widget " + wgtflnm + ".\nCause: " + Exceptions.getMessage((Throwable)ex));
                }
                continue;
            }
            if ("script".equals(elnm)) {
                String s;
                String browser = el.getAttributeValue("browser");
                String jspath = el.getAttributeValue("src");
                if (jspath != null && jspath.length() > 0) {
                    if (!zk && "true".equals(el.getAttribute("sourceMap")) && depends != null && processingPartial) {
                        processingSourceMapScript = true;
                        this.write((OutputStream)out, "var script=document.createElement('script');");
                        this.write((OutputStream)out, "script.type='text/javascript';");
                        this.write((OutputStream)out, "script.onload=function(){\n");
                        this.write((OutputStream)out, "zk.setLoaded('");
                        if (totalPartialCount > 1 && partialNum < totalPartialCount) {
                            this.write((OutputStream)out, name + partialNum);
                        } else {
                            this.write((OutputStream)out, name);
                        }
                        this.write((OutputStream)out, "');");
                        String requestURI = reqctx.request.getRequestURI();
                        String prefixURI = requestURI.substring(0, requestURI.lastIndexOf("/js"));
                        this.write((OutputStream)out, "};script.src='" + prefixURI + this.findResourcePath(reqctx, out, jspath, dir, true, false));
                        this.write((OutputStream)out, "';\ndocument.getElementsByTagName('head')[0].appendChild(script);");
                    } else if (wc != null && (browser != null || jspath.indexOf(42) >= 0)) {
                        this.move(wc, out);
                        wc.add(jspath, browser);
                    } else {
                        if (browser != null && (!Servlets.isBrowser((ServletRequest)reqctx.request, (String)browser) || this.getScriptManager().isScriptIgnored((ServletRequest)reqctx.request, jspath))) continue;
                        if (!this.writeResource(reqctx, out, jspath, dir, true)) {
                            log.error(jspath + " not found, " + el.getLocator() + ", " + path);
                        }
                    }
                }
                if ((s = el.getText(true)) == null || s.length() <= 0) continue;
                this.write((OutputStream)out, s);
                this.write((OutputStream)out, '\n');
                continue;
            }
            if ("function".equals(elnm)) {
                AbstractExtendlet.MethodInfo mtd = WpdExtendlet.getMethodInfo(el);
                if (mtd == null) continue;
                if (wc != null) {
                    this.move(wc, out);
                    wc.add(mtd);
                    continue;
                }
                this.write(reqctx, out, mtd);
                continue;
            }
            log.warn("Unknown element " + elnm + ", " + el.getLocator() + ", " + path);
        }
        if (zk) {
            if (!processingPartial || Objects.equals(partialNum, totalPartialCount)) {
                WebApp wapp = this.getWebApp();
                if (wapp != null) {
                    this.writeAppInfo(reqctx, out, wapp);
                }
                if (!processingPartial) {
                    this.write((OutputStream)out, '}');
                }
                this.writeHost(wc, out, wapp, reqctx);
            }
        } else if (aaas) {
            this.writeHost(wc, out, this.getWebApp(), reqctx);
        } else {
            if (depends != null || !processingPartial) {
                this.write((OutputStream)out, "\n}catch(error){console.error(error);}finally{");
                if (!processingSourceMapScript) {
                    this.write((OutputStream)out, "zk.setLoaded(zk._p.n);");
                    if (processingPartial && Objects.equals(partialNum, totalPartialCount)) {
                        this.write((OutputStream)out, "zk.setLoaded('");
                        this.write((OutputStream)out, name);
                        this.write((OutputStream)out, "');");
                    }
                }
                this.write((OutputStream)out, "}");
            }
            if (depends != null) {
                this.write((OutputStream)out, "});");
                if (!processingPartial || !this._lastDynamicWpds.contains(name + partialNum + ".wpd")) {
                    this.write((OutputStream)out, "zk.setLoaded('");
                    if (processingPartial && totalPartialCount > 1 && partialNum < totalPartialCount) {
                        this.write((OutputStream)out, name + partialNum);
                    } else {
                        this.write((OutputStream)out, name);
                    }
                    this.write((OutputStream)out, "',1);");
                }
            } else if (!processingPartial) {
                this.write((OutputStream)out, "})();");
            }
        }
        if (wc != null) {
            this.move(wc, out);
            return wc;
        }
        return new ByteContent(out.toByteArray(), cacheable);
    }

    public ScriptManager getScriptManager() {
        return ScriptManagerHolder.INSTANCE;
    }

    private boolean isWpdContentRequired(String pkg, Element root) {
        for (LanguageDefinition langdef : LanguageDefinition.getByDeviceType(this.getDeviceType())) {
            if (!langdef.getJavaScriptPackagesWithMerges().contains(pkg)) continue;
            return true;
        }
        for (Element el : root.getElements("script")) {
            if (el.getAttributeValue("browser") == null) continue;
            return true;
        }
        return false;
    }

    private void writeHost(WpdContent wc, ByteArrayOutputStream out, WebApp wapp, AbstractExtendlet.RequestContext reqctx) throws ServletException, IOException {
        Object[] pkgs;
        if (wapp != null && (pkgs = wapp.getConfiguration().getClientPackages()).length > 0) {
            this.move(wc, out);
            wc.addHost(wapp, JSONArray.toJSONString((Object[])pkgs));
        }
    }

    private String findResourcePath(AbstractExtendlet.RequestContext reqctx, OutputStream out, String path, String dir, boolean locate, boolean write) throws ServletException, IOException {
        if (((String)path).startsWith("~./")) {
            path = ((String)path).substring(2);
        } else if (((String)path).charAt(0) != '/') {
            path = Files.normalize((String)dir, (String)path);
        }
        String originalPath = "";
        if (this.isDebugJS() && !this.sourceMapEnabled() && "js".equals(Servlets.getExtension((String)path)) && !((String)path).endsWith(".src.js")) {
            originalPath = path;
            path = ((String)path).substring(0, ((String)path).length() - 3) + ".src.js";
        }
        InputStream is = reqctx.getResourceAsStream((String)path, locate);
        while (is == null) {
            if (Strings.isEmpty((String)originalPath)) {
                this.write(out, "zk.log('");
                this.write(out, (String)path);
                this.write(out, " not found');");
                return null;
            }
            path = originalPath;
            is = reqctx.getResourceAsStream((String)path, locate);
            originalPath = null;
        }
        if (write) {
            Files.copy((OutputStream)out, (InputStream)is);
            Files.close((InputStream)is);
            this.write(out, '\n');
        }
        return path;
    }

    private boolean writeResource(AbstractExtendlet.RequestContext reqctx, OutputStream out, String path, String dir, boolean locate) throws IOException, ServletException {
        return this.findResourcePath(reqctx, out, path, dir, locate, true) != null;
    }

    private int countLines(String js) {
        int line = 0;
        for (int i = 0; i < js.length(); ++i) {
            if (js.charAt(i) != '\n') continue;
            ++line;
        }
        return line;
    }

    private void write(OutputStream out, String s) throws IOException {
        if (s != null) {
            byte[] bs = s.getBytes("UTF-8");
            out.write(bs, 0, bs.length);
        }
    }

    private void write(OutputStream out, char cc) throws IOException {
        assert (cc < '\u0080');
        byte[] bs = new byte[]{(byte)cc};
        out.write(bs, 0, 1);
    }

    private String write(AbstractExtendlet.RequestContext reqctx, OutputStream out, AbstractExtendlet.MethodInfo mtd) throws IOException {
        String result = this.invoke(reqctx, mtd);
        this.write(out, result);
        return result;
    }

    private void writeln(OutputStream out) throws IOException {
        this.write(out, '\n');
    }

    private void move(WpdContent wc, ByteArrayOutputStream out) {
        byte[] bs = out.toByteArray();
        if (bs.length > 0) {
            wc.add(bs);
            out.reset();
        }
    }

    private void writeAppInfo(AbstractExtendlet.RequestContext reqctx, OutputStream out, WebApp wapp) throws IOException, ServletException {
        String deviceType;
        Object[][] infs;
        String verInfoEnabled = Library.getProperty((String)"org.zkoss.zk.ui.versionInfo.enabled", (String)"true");
        boolean exposeVer = "true".equals(verInfoEnabled);
        StringBuffer sb = new StringBuffer(256);
        if (exposeVer) {
            sb.append("\nzkver('").append(wapp.getVersion()).append("','");
        } else {
            sb.append("\nzkver('','");
        }
        String build = wapp.getBuild();
        sb.append(exposeVer ? build : Utils.obfuscateHashWithSalt(build, verInfoEnabled));
        ServletContext ctx = this.getServletContext();
        Object s = Encodes.encodeURL((ServletContext)ctx, (ServletRequest)reqctx.request, (ServletResponse)reqctx.response, (String)"/");
        int j = ((String)s).lastIndexOf(47);
        if (j >= 0) {
            s = ((String)s).substring(0, j) + ((String)s).substring(j + 1);
        }
        sb.append("','").append((String)s).append("','").append(Encodes.encodeURL((ServletContext)ctx, (ServletRequest)reqctx.request, (ServletResponse)reqctx.response, (String)wapp.getUpdateURI(false)));
        sb.append("',{");
        for (LanguageDefinition langdef : LanguageDefinition.getByDeviceType(this.getDeviceType())) {
            for (Map.Entry<String, String> me : langdef.getJavaScriptModules().entrySet()) {
                String value = me.getValue();
                sb.append('\'').append((Object)me.getKey()).append("':'").append((Object)(exposeVer ? value : Utils.obfuscateHashWithSalt(value, verInfoEnabled))).append("',");
            }
            WpdExtendlet.removeLast(sb, ',');
        }
        sb.append("},{");
        if (WebApps.getFeature("ee")) {
            sb.append("ed:'e',");
        } else if (WebApps.getFeature("pe")) {
            sb.append("ed:'p',");
        }
        Configuration config = wapp.getConfiguration();
        int v = config.getProcessingPromptDelay();
        if (v != 900) {
            sb.append("pd:").append(v).append(',');
        }
        if ((v = config.getTooltipDelay()) != 800) {
            sb.append("td:").append(v).append(',');
        }
        if ((v = config.getAutoResendTimeout()) != 200) {
            sb.append("art:").append(v).append(',');
        }
        if (config.isTimerKeepAlive()) {
            sb.append("ta:1,");
        }
        if (config.isDebugJS()) {
            sb.append("dj:1,");
        }
        if (config.isSendClientErrors()) {
            sb.append("sce:1,");
        }
        if (config.isKeepDesktopAcrossVisits()) {
            sb.append("kd:1,");
        }
        if (config.getPerformanceMeter() != null) {
            sb.append("pf:1,");
        }
        if (!config.isHistoryStateEnabled()) {
            sb.append("hs:0,");
        }
        if ((infs = config.getClientErrorReloads(deviceType = this.getDeviceType(), null)) != null) {
            sb.append("eu:{");
            this.outErrReloads(reqctx, config, sb, infs);
            sb.append("},");
        }
        if ((infs = config.getClientErrorReloads(deviceType, "server-push")) != null) {
            sb.append("eup:{");
            this.outErrReloads(reqctx, config, sb, infs);
            sb.append("},");
        }
        sb.append("resURI:'").append(Encodes.encodeURL((ServletContext)ctx, (ServletRequest)reqctx.request, (ServletResponse)reqctx.response, (String)wapp.getResourceURI(false))).append("'").append("});");
        this.write(out, sb.toString());
    }

    private void outErrReloads(AbstractExtendlet.RequestContext reqctx, Configuration config, StringBuffer sb, Object[][] infs) {
        for (int j = 0; j < infs.length; ++j) {
            if (j > 0) {
                sb.append(',');
            }
            sb.append('\'').append(infs[j][0]).append("':'");
            String uri = ((URIInfo)infs[j][1]).uri;
            if (uri.length() > 0) {
                try {
                    uri = Encodes.encodeURL((ServletContext)this.getServletContext(), (ServletRequest)reqctx.request, (ServletResponse)reqctx.response, (String)uri);
                }
                catch (ServletException ex) {
                    throw new UiException("Unable to encode " + uri, (Throwable)ex);
                }
            }
            sb.append(Strings.escape((String)uri, (String)"'\\")).append('\'');
        }
    }

    private static void removeLast(StringBuffer sb, char cc) {
        if (sb.charAt(sb.length() - 1) == cc) {
            sb.setLength(sb.length() - 1);
        }
    }

    private static String outMain(String main, Map<String, String[]> params) {
        StringBuffer sb = new StringBuffer("\nzkamn('");
        int j = main.lastIndexOf(46);
        if (j >= 0) {
            sb.append(main.substring(0, j));
        }
        sb.append("',function(){\n").append(main).append(".main(");
        LinkedHashMap<String, String[]> ms = new LinkedHashMap<String, String[]>();
        for (Map.Entry<String, String[]> me : params.entrySet()) {
            String nm = me.getKey();
            if ("main".equals(nm)) continue;
            String[] vals = me.getValue();
            ms.put(nm, (String[])(vals.length == 0 ? null : (vals.length == 1 ? vals[0] : vals)));
        }
        sb.append(JSONObject.toJSONString(ms)).append(")\n})");
        return sb.toString();
    }

    private static String outHost(HttpServletRequest request, WebApp wapp, String clientPackages) {
        String uri;
        StringBuffer sb = new StringBuffer().append("zk.setHost('").append(request.getScheme()).append("://").append(request.getServerName());
        if (request.getServerPort() != 80) {
            sb.append(':').append(request.getServerPort());
        }
        if ((uri = request.getContextPath()) != null && uri.length() > 0) {
            if (uri.charAt(0) != '/') {
                sb.append('/');
            }
            sb.append(uri);
            WpdExtendlet.removeLast(sb, '/');
        }
        return sb.append("','").append(wapp.getResourceURI(false)).append("',").append(clientPackages).append(");").toString();
    }

    private boolean sourceMapEnabled() {
        return this.getWebApp().getConfiguration().isSourceMapEnabled();
    }

    public List<String> splitSourceMapJsPathIfAny(String path) throws Exception {
        int pathPrefixIndex;
        String originalPath = path;
        if (path.startsWith("~.")) {
            path = path.replace("~.", "");
        }
        if ((pathPrefixIndex = path.indexOf("/web")) != -1) {
            path = path.substring("/web".length());
        }
        LinkedList<String> paths = new LinkedList<String>();
        ClassWebResource cwr = WebManager.getWebManager(this.getWebApp()).getClassWebResource();
        path = cwr.modifyPath(path);
        String originalPathPrefix = originalPath.substring(0, originalPath.lastIndexOf(path));
        String packageName = this.processWpdForSourcemapIfAny(paths, originalPathPrefix, cwr.modifyPath(path));
        String deviceType = this.getDeviceType();
        Device device = Devices.getDevice(deviceType);
        for (LanguageDefinition langdef : LanguageDefinition.getByDeviceType(deviceType)) {
            for (String pkg : langdef.getMergedJavaScriptPackages(packageName)) {
                String packageToPath = device.packageToPath(pkg);
                this.processWpdForSourcemapIfAny(paths, originalPathPrefix, cwr.modifyPath(packageToPath));
            }
        }
        return paths;
    }

    private String processWpdForSourcemapIfAny(List<String> paths, String originalPathPrefix, String path) throws Exception {
        Content content = (Content)this._cache.get((Object)path);
        if (content == null) {
            log.error("Failed to load the resource: " + path);
            throw new FileNotFoundException("Failed to load the resource: " + path);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(((SourceInfo)content._cnt)._raw);
        Element root = new SAXBuilder(true, false, true).build((InputStream)is).getRootElement();
        String name = IDOMs.getRequiredAttributeValue((Element)root, (String)"name");
        if (name.length() == 0) {
            throw new UiException("The name attribute must be specified, " + root.getLocator() + ", " + path);
        }
        boolean sourceMapProcessed = false;
        int dividedNum = 1;
        int pathStartIndex = paths.size();
        LinkedList<Element> elements = new LinkedList<Element>();
        for (Element el : root.getElements()) {
            String elnm = el.getName();
            if ("widget".equals(elnm)) {
                elements.add(el);
                continue;
            }
            if ("script".equals(elnm)) {
                String sourcemap = el.getAttribute("sourceMap");
                if (sourcemap != null && "true".equals(sourcemap)) {
                    String dividedPath = originalPathPrefix + path.replace(name, name + dividedNum);
                    if (elements.size() != 0) {
                        paths.add(dividedPath);
                        this._dividedWpds.put(dividedPath.substring(dividedPath.lastIndexOf("/") + 1), elements);
                        dividedPath = originalPathPrefix + path.replace(name, name + ++dividedNum);
                        elements = new LinkedList();
                    }
                    elements.add(el);
                    this._dividedWpds.put(dividedPath.substring(dividedPath.lastIndexOf("/") + 1), elements);
                    paths.add(dividedPath);
                    ++dividedNum;
                    elements = new LinkedList();
                    sourceMapProcessed = true;
                    continue;
                }
                elements.add(el);
                continue;
            }
            if ("function".equals(elnm)) {
                elements.add(el);
                continue;
            }
            log.warn("Unknown element " + elnm + ", " + el.getLocator() + ", " + path);
        }
        if (elements.size() != 0) {
            String dividedPath = originalPathPrefix + path.replace(name, name + dividedNum);
            paths.add(dividedPath);
            this._dividedWpds.put(dividedPath.substring(dividedPath.lastIndexOf("/") + 1), elements);
            this._dividedPackageCnt.put(name, dividedNum);
        } else {
            this._dividedPackageCnt.put(name, dividedNum - 1);
        }
        String depends = root.getAttributeValue("depends");
        if (depends != null && depends.length() == 0) {
            depends = null;
        }
        if (!"zk".equals(name) && depends == null && sourceMapProcessed) {
            paths.add(pathStartIndex, originalPathPrefix + path.replace(name, name + "0"));
            paths.add(originalPathPrefix + path.replace(name, name + "$"));
        }
        return name;
    }

    private byte[] processDynamicWpdWithSourceMapIfAny(HttpServletRequest request, HttpServletResponse response, String pkgWpd, String path) throws Exception {
        List<String> dividedPaths = this.splitSourceMapJsPathIfAny(path);
        StringBuilder sb = new StringBuilder();
        int index = 0;
        String lastWpd = null;
        if (dividedPaths.size() == 0) {
            throw new UiException("Failed to load the resource: " + path);
        }
        if (dividedPaths.size() == 1) {
            return null;
        }
        for (String dividedPath : dividedPaths) {
            String url;
            String scriptVariableName = "script" + index++;
            sb.append("var ").append(scriptVariableName).append("=document.createElement('script');");
            sb.append(scriptVariableName).append(".type='text/javascript';");
            try {
                url = Encodes.encodeURL((ServletContext)this.getServletContext(), (ServletRequest)request, (ServletResponse)response, (String)("~." + dividedPath));
            }
            catch (ServletException ex) {
                throw new UiException(ex);
            }
            sb.append(scriptVariableName).append(".src='").append(url).append("';");
            sb.append("\ndocument.getElementsByTagName('head')[0].appendChild(").append(scriptVariableName).append(");");
            lastWpd = dividedPath.substring(dividedPath.lastIndexOf("/") + 1);
        }
        if (!Strings.isEmpty(lastWpd)) {
            this._lastDynamicWpds.add(lastWpd);
            sb.append("\nzk.setLoaded('").append(pkgWpd.replace(".wpd", "")).append("',1);");
        }
        return sb.toString().getBytes();
    }

    private class WpdContent {
        private final String name;
        private final String _dir;
        private final List<Object> _cnt = new LinkedList<Object>();
        private final boolean cacheable;

        private WpdContent(String name, String dir, boolean cacheable) {
            this.name = name;
            this._dir = dir;
            this.cacheable = cacheable;
        }

        private void add(byte[] bs) {
            this._cnt.add(bs);
        }

        private void add(AbstractExtendlet.MethodInfo mtd) {
            this._cnt.add(mtd);
        }

        private void add(String jspath, String browser) {
            this._cnt.add(new String[]{jspath, browser});
        }

        private void addHost(WebApp wapp, String clientPackages) {
            this._cnt.add(new Object[]{wapp, clientPackages});
        }

        private byte[] toByteArray(AbstractExtendlet.RequestContext reqctx) throws ServletException, IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            HttpServletRequest request = reqctx.request;
            String main = request != null ? request.getParameter("main") : null;
            ArrayList<String> resultList = new ArrayList<String>(16);
            for (Object o : this._cnt) {
                Object[] inf;
                String result = "";
                if (o instanceof byte[]) {
                    out.write((byte[])o);
                    continue;
                }
                if (o instanceof AbstractExtendlet.MethodInfo) {
                    result = WpdExtendlet.this.write(reqctx, out, (AbstractExtendlet.MethodInfo)o);
                    resultList.add(result);
                    continue;
                }
                if (o instanceof String[]) {
                    resultList.add("$skipped$");
                    inf = (String[])o;
                    if (inf[1] != null && request != null && (!Servlets.isBrowser((ServletRequest)request, (String)inf[1]) || WpdExtendlet.this.getScriptManager().isScriptIgnored((ServletRequest)reqctx.request, (String)inf[0])) || WpdExtendlet.this.writeResource(reqctx, out, (String)inf[0], this._dir, true)) continue;
                    AbstractExtendlet.log.error((String)inf[0] + " not found");
                    continue;
                }
                if (!(o instanceof Object[]) || main == null) continue;
                inf = (Object[])o;
                result = WpdExtendlet.outHost(request, (WebApp)inf[0], (String)inf[1]);
                resultList.add(result);
                WpdExtendlet.this.write((OutputStream)out, result);
            }
            if (main != null && main.length() > 0) {
                WpdExtendlet.this.write((OutputStream)out, WpdExtendlet.outMain(main, request.getParameterMap()));
            }
            return out.toByteArray();
        }
    }

    private static class ByteContent {
        private final byte[] content;
        private final boolean cacheable;

        private ByteContent(byte[] cnt, boolean cacheable) {
            this.content = cnt;
            this.cacheable = cacheable;
        }
    }

    private class SourceInfo {
        private final byte[] _raw;
        private final String _path;

        private SourceInfo(InputStream input, String path) throws IOException {
            this._raw = Files.readAll((InputStream)input);
            this._path = path;
        }

        private Object parse(AbstractExtendlet.RequestContext reqctx) throws Exception {
            return WpdExtendlet.this.parse(reqctx, new ByteArrayInputStream(this._raw), this._path);
        }
    }

    private static class Content {
        private Object _cnt;

        private Content(SourceInfo si) {
            this._cnt = si;
        }

        private Object parse(AbstractExtendlet.RequestContext reqctx) throws ServletException, IOException {
            if (this._cnt instanceof SourceInfo) {
                try {
                    this._cnt = ((SourceInfo)this._cnt).parse(reqctx);
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (ServletException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw UiException.Aide.wrap(ex);
                }
            }
            return this._cnt;
        }
    }

    private class WpdLoader
    extends ExtendletLoader<Object> {
        private WpdLoader() {
        }

        protected Object parse(InputStream is, String path, String orgpath) throws Exception {
            return new Content(new SourceInfo(is, path));
        }

        protected ExtendletContext getExtendletContext() {
            return WpdExtendlet.this._webctx;
        }

        protected String getRealPath(String path) {
            if (path.endsWith("map")) {
                return path;
            }
            int j = path.lastIndexOf(".wpd");
            return path.substring(0, j).replace('.', '/') + "/zk" + path.substring(j);
        }
    }

    private static class ScriptManagerHolder {
        private static final ScriptManager INSTANCE = ScriptManagerHolder.initializeScriptManager();

        private ScriptManagerHolder() {
        }

        private static ScriptManager initializeScriptManager() {
            String clsnm = Library.getProperty((String)"org.zkoss.zk.ui.http.ScriptManager.class");
            ScriptManager manager = null;
            if (clsnm != null) {
                try {
                    manager = (ScriptManager)Classes.newInstanceByThread((String)clsnm);
                }
                catch (Throwable ex) {
                    AbstractExtendlet.log.error("Unable to instantiate " + clsnm, ex);
                }
            }
            if (manager == null) {
                manager = new ScriptManagerImpl();
            }
            return manager;
        }
    }
}

