/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.parts;

import net.sf.jasperreports.engine.JRPart;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.part.PartComponentXmlWriter;
import net.sf.jasperreports.engine.util.VersionComparator;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public abstract class AbstractPartComponentXmlWriter
implements PartComponentXmlWriter {
    public static final String PROPERTY_PART_COMPONENTS_PREFIX = "net.sf.jasperreports.parts.";
    protected final JasperReportsContext jasperReportsContext;
    protected final VersionComparator versionComparator;

    public AbstractPartComponentXmlWriter(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
        this.versionComparator = new VersionComparator();
    }

    public static String getVersion(JasperReportsContext jasperReportsContext, JRPart part, JRXmlWriter reportWriter) {
        String version = null;
        ComponentKey componentKey = part.getComponentKey();
        String versionProperty = PROPERTY_PART_COMPONENTS_PREFIX + componentKey.getName() + ".version";
        if (part.getPropertiesMap().containsProperty(versionProperty)) {
            version = part.getPropertiesMap().getProperty(versionProperty);
        } else {
            JRReport report = reportWriter.getReport();
            version = JRPropertiesUtil.getInstance(jasperReportsContext).getProperty(report, versionProperty);
            if (version == null) {
                version = JRPropertiesUtil.getInstance(jasperReportsContext).getProperty(report, "net.sf.jasperreports.report.version");
            }
        }
        return version;
    }

    protected boolean isNewerVersionOrEqual(JRPart part, JRXmlWriter reportWriter, String oldVersion) {
        return this.versionComparator.compare(AbstractPartComponentXmlWriter.getVersion(this.jasperReportsContext, part, reportWriter), oldVersion) >= 0;
    }

    protected boolean isOlderVersionThan(JRPart part, JRXmlWriter reportWriter, String version) {
        return this.versionComparator.compare(AbstractPartComponentXmlWriter.getVersion(this.jasperReportsContext, part, reportWriter), version) < 0;
    }
}

