/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.theme;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.zkoss.lang.Strings;
import org.zkoss.web.fn.ServletFns;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.util.ThemeProvider;
import org.zkoss.zul.theme.Themes;

public class StandardThemeProvider
implements ThemeProvider {
    public static final String DEFAULT_WCS = "~./zul/css/zk.wcs";

    protected static String getThemeFileSuffix() {
        String suffix = Themes.getCurrentTheme();
        return "iceblue".equals(suffix) ? null : suffix;
    }

    private void bypassURI(List<Object> uris, String suffix) {
        ListIterator<Object> it = uris.listIterator();
        while (it.hasNext()) {
            String uri;
            Object o = it.next();
            if (!(o instanceof String) || !(uri = (String)o).startsWith(DEFAULT_WCS)) continue;
            it.set(ThemeProvider.Aide.injectURI((String)uri, (String)suffix));
            break;
        }
    }

    public Collection<Object> getThemeURIs(Execution exec, List<Object> uris) {
        String suffix = StandardThemeProvider.getThemeFileSuffix();
        if (!Strings.isEmpty((String)suffix)) {
            this.bypassURI(uris, suffix);
        }
        return uris;
    }

    public int getWCSCacheControl(Execution exec, String uri) {
        return 8760;
    }

    public String beforeWCS(Execution exec, String uri) {
        return uri;
    }

    public String beforeWidgetCSS(Execution exec, String uri) {
        if (uri.startsWith("~./zul/css/") || uri.startsWith("~./js/zul/")) {
            uri = ServletFns.resolveThemeURL((String)uri);
        }
        return uri;
    }
}

