/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.zkoss.util.media.Media;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.DeferredValue;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.StateChangeEvent;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Track;
import org.zkoss.zul.ext.MediaElement;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public class Audio
extends XulElement
implements MediaElement {
    public static final int STOP = 0;
    public static final int PLAY = 1;
    public static final int PAUSE = 2;
    public static final int END = 3;
    protected List<String> _src = new ArrayList<String>();
    private org.zkoss.sound.Audio _audio;
    private byte _audver;
    private boolean _autoplay;
    private boolean _controls;
    private boolean _loop;
    private boolean _muted;
    private String _preload;
    private int _currentState = 0;

    public Audio() {
    }

    public Audio(String src) {
        this.setSrc(src);
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if ("onStateChange".equals(cmd)) {
            StateChangeEvent event = StateChangeEvent.getStateChangeEvent((AuRequest)request);
            this._currentState = event.getState();
            Events.postEvent((Event)event);
        } else {
            super.service(request, everError);
        }
    }

    public void play() {
        if (this._currentState != 1) {
            this.response("ctrl", (AuResponse)new AuInvoke((Component)this, "play"));
        }
    }

    public void stop() {
        if (this._currentState != 0) {
            this.response("ctrl", (AuResponse)new AuInvoke((Component)this, "stop"));
        }
    }

    public void pause() {
        if (this._currentState != 2) {
            this.response("ctrl", (AuResponse)new AuInvoke((Component)this, "pause"));
        }
    }

    public List<String> getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        String[] split = src.split(",");
        ArrayList<String> list = new ArrayList<String>(split.length);
        for (String s : split) {
            list.add(s.trim());
        }
        if (this._audio != null || !this._src.equals(list)) {
            this._audio = null;
            this.setSrc(list);
        }
    }

    public void setSrc(List<String> src) {
        if (!src.equals(this._src)) {
            this._src = src;
            this.smartUpdate("src", new EncodedSrc());
        }
    }

    public boolean isAutoplay() {
        return this._autoplay;
    }

    public void setAutoplay(boolean autoplay) {
        if (this._autoplay != autoplay) {
            this._autoplay = autoplay;
            this.smartUpdate("autoplay", this._autoplay);
        }
    }

    public String getPreload() {
        return this._preload;
    }

    public void setPreload(String preload) {
        if (!(preload = "none".equalsIgnoreCase(preload) ? "none" : ("metadata".equalsIgnoreCase(preload) ? "metadata" : "auto")).equals(this._preload)) {
            this._preload = preload;
            this.smartUpdate("preload", this._preload);
        }
    }

    public boolean isControls() {
        return this._controls;
    }

    public void setControls(boolean controls) {
        if (this._controls != controls) {
            this._controls = controls;
            this.smartUpdate("controls", this._controls);
        }
    }

    public boolean isLoop() {
        return this._loop;
    }

    public void setLoop(boolean loop) {
        if (this._loop != loop) {
            this._loop = loop;
            this.smartUpdate("loop", this._loop);
        }
    }

    public boolean isMuted() {
        return this._muted;
    }

    public void setMuted(boolean muted) {
        if (this._muted != muted) {
            this._muted = muted;
            this.smartUpdate("muted", this._muted);
        }
    }

    public boolean isPlaying() {
        return this._currentState == 1;
    }

    public boolean isPaused() {
        return this._currentState == 2;
    }

    public boolean isStopped() {
        return this._currentState == 0 || this._currentState == 3;
    }

    public boolean isEnded() {
        return this._currentState == 3;
    }

    public void setContent(org.zkoss.sound.Audio audio) {
        if (this._src != null || audio != this._audio) {
            this._audio = audio;
            this._src = null;
            if (this._audio != null) {
                this._audver = (byte)(this._audver + 1);
            }
            this.smartUpdate("src", new EncodedSrc());
        }
    }

    public org.zkoss.sound.Audio getContent() {
        return this._audio;
    }

    private List<String> getEncodedSrc() {
        Desktop dt = this.getDesktop();
        ArrayList<String> list = new ArrayList<String>();
        if (this._audio != null) {
            list.add(this.getAudioSrc());
        } else if (dt != null) {
            for (String src : this._src) {
                list.add(dt.getExecution().encodeURL(src));
            }
        }
        return list;
    }

    private String getAudioSrc() {
        return Utils.getDynamicMediaURI((AbstractComponent)this, this._audver, this._audio.getName(), this._audio.getFormat());
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "src", this.getEncodedSrc());
        this.render(renderer, "autoplay", this._autoplay);
        this.render(renderer, "preload", this._preload);
        this.render(renderer, "controls", this._controls);
        this.render(renderer, "loop", this._loop);
        this.render(renderer, "muted", this._muted);
    }

    public void beforeChildAdded(Component child, Component insertBefore) {
        if (!(child instanceof Track)) {
            throw new UiException("Unsupported child for audio: " + child);
        }
        super.beforeChildAdded(child, insertBefore);
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    static {
        Audio.addClientEvent(Audio.class, (String)"onStateChange", (int)1);
    }

    private class EncodedSrc
    implements DeferredValue {
        private EncodedSrc() {
        }

        public Object getValue() {
            return Audio.this.getEncodedSrc();
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements DynamicMedia {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Audio.this);
        }

        public Media getMedia(String pathInfo) {
            return Audio.this._audio;
        }
    }
}

