/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Tab;
import org.zkoss.zul.Tabbox;
import org.zkoss.zul.impl.XulElement;

public class Tabs
extends XulElement {
    private String _align = "start";

    public Tabbox getTabbox() {
        return (Tabbox)this.getParent();
    }

    public String getWidth() {
        String width = super.getWidth();
        Tabbox tabbox = this.getTabbox();
        if (width == null && tabbox != null && tabbox.isVertical()) {
            width = "50px";
        }
        return width;
    }

    public String getAlign() {
        return this._align;
    }

    public void setAlign(String align) throws WrongValueException {
        if (!("start".equals(align) || "center".equals(align) || "end".equals(align))) {
            throw new WrongValueException(align);
        }
        if (!Objects.equals((Object)this._align, (Object)align)) {
            this._align = align;
            this.smartUpdate("align", this._align);
        }
    }

    public void invalidate() {
        Tabbox tbox = this.getTabbox();
        if (tbox != null && tbox.isVertical()) {
            tbox.invalidate();
        } else {
            super.invalidate();
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-tabs" : this._zclass;
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Tabbox)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.beforeParentChanged(parent);
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (!(child instanceof Tab)) {
            throw new UiException("Unsupported child for tabs: " + child);
        }
        super.beforeChildAdded(child, refChild);
    }

    public boolean insertBefore(Component child, Component refChild) {
        block5: {
            block6: {
                Tab newtab;
                boolean desel;
                block7: {
                    boolean sel = !this.getChildren().stream().filter(Component::isVisible).findAny().isPresent();
                    desel = false;
                    newtab = (Tab)child;
                    if (!sel && newtab.isSelected()) {
                        if (newtab.getTabbox() != null) {
                            newtab.setSelected(false);
                        } else {
                            newtab.setSelectedDirectly(false);
                        }
                        desel = true;
                        sel = true;
                    }
                    if (!super.insertBefore(child, refChild)) break block5;
                    Tabbox tabbox = this.getTabbox();
                    if (!sel || !newtab.isVisible()) break block6;
                    if (tabbox == null) break block7;
                    if (tabbox.getModel() != null && !tabbox.getSelectableModel().isSelectionEmpty()) break block6;
                    tabbox.setSelectedTab(newtab);
                    break block6;
                }
                newtab.setSelectedDirectly(true);
                if (desel) {
                    for (Tab tab : this.getChildren()) {
                        if (tab == newtab || !tab.isSelected()) continue;
                        tab.setSelectedDirectly(false);
                        break;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        Tabbox tabbox = this.getTabbox();
        if (tabbox != null) {
            Tab tab = (Tab)child;
            tab.removeEventListener("onSelect", tabbox._listener);
            if (tabbox.getSelectedTab() == tab) {
                tabbox.clearSelectedTab();
            }
        }
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        Tabbox tabbox = this.getTabbox();
        if (tabbox != null) {
            ((Tab)child).addEventListener("onSelect", tabbox._listener);
        }
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (!"start".equals(this._align)) {
            this.render(renderer, "align", this._align);
        }
    }
}

